/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.client.SharedResources;
import com.sap.sailing.gwt.home.desktop.partials.media.MediaPageResources;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.ui.client.media.GalleryImageHolder;
import com.sap.sse.gwt.client.media.ImageDTO;
import java.util.Date;

public class GalleryImageHolder
extends Composite
implements HasClickHandlers {
    private static VideoThumbnailUiBinder uiBinder = (VideoThumbnailUiBinder)GWT.create(VideoThumbnailUiBinder.class);
    private final String imageSourceRef;
    private final Date imageCreateAt;
    @UiField
    DivElement imageHolderUi;
    @UiField
    Anchor deleteAnchor;
    @UiField
    DivElement overlay;

    public GalleryImageHolder(ImageDTO image, ClickHandler deleteHandler) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        SharedResources.INSTANCE.mainCss().ensureInjected();
        MediaPageResources.INSTANCE.css().ensureInjected();
        SharedHomeResources.INSTANCE.sharedHomeCss().ensureInjected();
        this.imageSourceRef = image.getSourceRef();
        this.imageCreateAt = image.getCreatedAtDate();
        this.deleteAnchor.addClickHandler(deleteHandler);
        this.imageHolderUi.getStyle().setBackgroundImage("url(\"" + UriUtils.fromString((String)image.getSourceRef()).asString() + "\")");
    }

    public boolean isImage(ImageDTO image) {
        return image != null && image.getSourceRef().equals(this.imageSourceRef) && image.getCreatedAtDate().equals(this.imageCreateAt);
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    public void setManageable(boolean manageable) {
        if (manageable) {
            this.overlay.getStyle().setDisplay(Style.Display.BLOCK);
        } else {
            this.overlay.getStyle().setDisplay(Style.Display.NONE);
        }
    }
}

