/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.tractrac;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.TracTracConfigurationWithSecurityDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;

public class TracTracConnectionDialog
extends DataEntryDialog<TracTracConfigurationWithSecurityDTO> {
    private static final StringMessages stringMessages = StringMessages.INSTANCE;
    private Grid grid;
    protected TextBox storedURITextBox;
    protected TextBox liveURITextBox;
    protected TextBox jsonURLTextBox;
    protected TextBox tracTracUpdateURITextBox;
    protected TextBox tractracUsernameTextBox;
    protected PasswordTextBox tractracPasswordTextBox;
    protected String creatorName;
    protected String name;

    public TracTracConnectionDialog(DataEntryDialog.DialogCallback<TracTracConfigurationWithSecurityDTO> callback, UserService userService, ErrorReporter errorReporter) {
        super(stringMessages.tracTracConnection(), null, stringMessages.ok(), stringMessages.cancel(), null, true, callback);
        this.ensureDebugId("TracTracConnectionDialog");
        this.createUi();
    }

    private void createUi() {
        this.grid = new Grid(7, 2);
        this.grid.setWidget(0, 0, (Widget)new Label(String.valueOf(stringMessages.details()) + ":"));
        Label liveURILabel = new Label(String.valueOf(stringMessages.liveUri()) + ":");
        liveURILabel.setTitle(stringMessages.leaveEmptyForDefault());
        this.liveURITextBox = this.createTextBox("");
        this.liveURITextBox.ensureDebugId("LiveURITextBox");
        this.liveURITextBox.setVisibleLength(40);
        this.liveURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(1, 0, (Widget)liveURILabel);
        this.grid.setWidget(1, 1, (Widget)this.liveURITextBox);
        Label storedURILabel = new Label(String.valueOf(stringMessages.storedUri()) + ":");
        storedURILabel.setTitle(stringMessages.leaveEmptyForDefault());
        this.storedURITextBox = this.createTextBox("");
        this.storedURITextBox.ensureDebugId("StoredURITextBox");
        this.storedURITextBox.setVisibleLength(40);
        this.storedURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(2, 0, (Widget)storedURILabel);
        this.grid.setWidget(2, 1, (Widget)this.storedURITextBox);
        Label jsonURLLabel = new Label(String.valueOf(stringMessages.jsonUrl()) + ":");
        this.jsonURLTextBox = this.createTextBox("");
        this.jsonURLTextBox.ensureDebugId("JsonURLTextBox");
        this.jsonURLTextBox.setVisibleLength(100);
        this.jsonURLTextBox.addKeyUpHandler(e -> super.getOkButton().setEnabled(!this.jsonURLTextBox.getText().isEmpty()));
        this.grid.setWidget(3, 0, (Widget)jsonURLLabel);
        this.grid.setWidget(3, 1, (Widget)this.jsonURLTextBox);
        Label tracTracUpdateURLLabel = new Label(String.valueOf(stringMessages.tracTracUpdateUrl()) + ":");
        this.tracTracUpdateURITextBox = this.createTextBox("");
        this.tracTracUpdateURITextBox.ensureDebugId("TracTracUpdateURITextBox");
        this.tracTracUpdateURITextBox.setVisibleLength(100);
        this.tracTracUpdateURITextBox.setTitle(stringMessages.leaveEmptyForDefault());
        this.grid.setWidget(4, 0, (Widget)tracTracUpdateURLLabel);
        this.grid.setWidget(4, 1, (Widget)this.tracTracUpdateURITextBox);
        this.tractracUsernameTextBox = this.createTextBox("");
        this.tractracUsernameTextBox.ensureDebugId("TracTracUsernameTextBox");
        this.tractracUsernameTextBox.setVisibleLength(40);
        this.grid.setWidget(5, 0, (Widget)new Label(String.valueOf(stringMessages.tractracUsername()) + ":"));
        this.grid.setWidget(5, 1, (Widget)this.tractracUsernameTextBox);
        this.tractracPasswordTextBox = this.createPasswordTextBox("");
        this.tractracPasswordTextBox.ensureDebugId("TracTracPasswordTextBox");
        this.tractracPasswordTextBox.setVisibleLength(40);
        this.grid.setWidget(6, 0, (Widget)new Label(String.valueOf(stringMessages.tractracPassword()) + ":"));
        this.grid.setWidget(6, 1, (Widget)this.tractracPasswordTextBox);
    }

    protected Focusable getInitialFocusWidget() {
        return this.jsonURLTextBox;
    }

    protected TracTracConfigurationWithSecurityDTO getResult() {
        String jsonURL = this.jsonURLTextBox.getValue();
        String liveDataURI = this.liveURITextBox.getValue();
        String storedDataURI = this.storedURITextBox.getValue();
        String courseDesignUpdateURI = this.tracTracUpdateURITextBox.getValue();
        String tractracUsername = this.tractracUsernameTextBox.getValue();
        String tractracPassword = Util.hasLength((String)this.tractracPasswordTextBox.getValue()) ? this.tractracPasswordTextBox.getValue() : null;
        return new TracTracConfigurationWithSecurityDTO(this.name, jsonURL, liveDataURI, storedDataURI, courseDesignUpdateURI, tractracUsername, tractracPassword, this.creatorName);
    }

    protected Widget getAdditionalWidget() {
        return this.grid;
    }
}

