/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.multivideo;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IntegerBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.dto.VideoMetadataDTO;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.gwt.ui.adminconsole.multivideo.MultiVideoDialog;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.media.JSDownloadUtils;
import com.sap.sailing.gwt.ui.client.media.TimeFormatUtil;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.LeaderboardGroupDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.datetime.DateAndTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultiVideoDialog
extends DialogBox {
    private static final String EMPTY_TEXT = "";
    private static final int DELETE_COLUMN = 0;
    private static final int URL_COLUMN = 1;
    private static final int STATUS_COLUMN = 2;
    private static final int DURATION_COLUMN = 3;
    private static final int STARTTIME_COLUMN = 4;
    private static final int MIMETYPE_COLUMN = 5;
    private static final int RACES_COLUMN = 6;
    private static final Logger logger = Logger.getLogger(MultiVideoDialog.class.getName());
    private static final Style STYLE = ((StyleHolder)GWT.create(StyleHolder.class)).style();
    private StringMessages stringMessages;
    private List<RemoteFileInfo> remoteFiles = new ArrayList();
    private FlexTable dataTable;
    private MediaServiceWriteAsync mediaServiceWrite;
    private Button doScanButton;
    private Label statusLabel;
    private SailingServiceAsync sailingService;
    private Button doSaveButton;
    private Runnable afterLinking;
    private ErrorReporter errorReporter;
    protected int offsetTimeInMS;
    private boolean isWorking;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$ui$adminconsole$multivideo$MultiVideoDialog$EStatus;

    public MultiVideoDialog(SailingServiceAsync sailingService, MediaServiceWriteAsync mediaServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter, Runnable afterLinking) {
        this.stringMessages = stringMessages;
        this.mediaServiceWrite = mediaServiceWrite;
        this.sailingService = sailingService;
        this.errorReporter = errorReporter;
        this.afterLinking = afterLinking;
        this.setGlassEnabled(true);
        FlowPanel mainContent = new FlowPanel();
        Label descriptionLabel = new Label(this.stringMessages.multiVideoDescription());
        descriptionLabel.getElement().getStyle().setPadding(0.5, Style.Unit.EM);
        mainContent.add((Widget)descriptionLabel);
        Label indexUrl = new Label(stringMessages.multiVideoURLOfIndex());
        mainContent.add((Widget)indexUrl);
        TextBox urlInput = new TextBox();
        mainContent.add((Widget)urlInput);
        this.doScanButton = new Button(stringMessages.multiVideoScan());
        mainContent.add((Widget)this.doScanButton);
        this.doScanButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.statusLabel = new Label(stringMessages.multiVideoIdle());
        mainContent.add((Widget)this.statusLabel);
        FlowPanel offsetPanel = new FlowPanel();
        IntegerBox timeOffset = new IntegerBox();
        timeOffset.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Label lbl = new Label(stringMessages.multiVideoOffsetInput());
        lbl.getElement().getStyle().setDisplay(Style.Display.INLINE_BLOCK);
        offsetPanel.add((Widget)lbl);
        offsetPanel.add((Widget)timeOffset);
        mainContent.add((Widget)offsetPanel);
        FlowPanel buttonPanel = new FlowPanel();
        DockPanel dockPanel = new DockPanel();
        this.add((Widget)dockPanel);
        dockPanel.add((Widget)new ScrollPanel((Widget)mainContent), DockPanel.CENTER);
        this.dataTable = new FlexTable();
        STYLE.ensureInjected();
        this.dataTable.addStyleName(STYLE.tableStyle());
        mainContent.add((Widget)this.dataTable);
        Button cancelButton = new Button(stringMessages.close());
        cancelButton.getElement().getStyle().setMargin(3.0, Style.Unit.PX);
        cancelButton.ensureDebugId("CancelButton");
        cancelButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.doSaveButton = new Button(stringMessages.addMediaTrack());
        this.doSaveButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.doSaveButton.setEnabled(false);
        buttonPanel.add((Widget)this.doSaveButton);
        buttonPanel.add((Widget)cancelButton);
        dockPanel.add((Widget)buttonPanel, DockPanel.SOUTH);
        this.updateUI();
    }

    public void setWorking(boolean working) {
        this.isWorking = working;
        this.updateUI();
    }

    protected void updateUI() {
        int y = 0;
        this.dataTable.removeAllRows();
        this.dataTable.clear();
        this.dataTable.setWidget(y, 0, (Widget)new Label(this.stringMessages.addMediaTrack()));
        this.dataTable.setWidget(y, 1, (Widget)new Label(this.stringMessages.url()));
        this.dataTable.setWidget(y, 2, (Widget)new Label(this.stringMessages.status()));
        this.dataTable.setWidget(y, 3, (Widget)new Label(this.stringMessages.duration()));
        this.dataTable.setWidget(y, 4, (Widget)new Label(this.stringMessages.startTime()));
        this.dataTable.setWidget(y, 5, (Widget)new Label(this.stringMessages.mimeType()));
        this.dataTable.setWidget(y, 6, (Widget)new Label(this.stringMessages.linkedRaces()));
        int row = 0;
        while (row < this.dataTable.getCellCount(0)) {
            this.dataTable.getFlexCellFormatter().addStyleName(y, row, STYLE.tableHeader());
            ++row;
        }
        ++y;
        for (RemoteFileInfo remoteFile : this.remoteFiles) {
            Anchor link = new Anchor(remoteFile.url);
            link.setHref(remoteFile.url);
            link.setTarget("_blank");
            this.dataTable.setWidget(y, 1, (Widget)link);
            if (remoteFile.selected || remoteFile.status != EStatus.WAIT_FOR_SAVE) {
                this.dataTable.setWidget(y, 2, (Widget)new Label(this.asString(remoteFile.status)));
            } else {
                this.dataTable.setWidget(y, 2, (Widget)new Label(this.stringMessages.multiVideoDoNoAdd()));
            }
            CheckBox removeVideo = new CheckBox();
            removeVideo.setEnabled(!remoteFile.isWorking && remoteFile.status == EStatus.WAIT_FOR_SAVE);
            removeVideo.setValue(Boolean.valueOf(remoteFile.selected));
            removeVideo.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.dataTable.setWidget(y, 0, (Widget)removeVideo);
            if (remoteFile.duration == null) {
                this.dataTable.setWidget(y, 3, (Widget)new Label(""));
            } else {
                TextBox durationInput = new TextBox();
                durationInput.setText(TimeFormatUtil.durationToHrsMinSec((Duration)remoteFile.duration));
                durationInput.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.dataTable.setWidget(y, 3, (Widget)durationInput);
            }
            if (remoteFile.startTime == null) {
                this.dataTable.setWidget(y, 4, (Widget)new Label(""));
            } else {
                DateAndTimeInput startTimeInput = new DateAndTimeInput(DateTimeInput.Accuracy.MILLISECONDS);
                startTimeInput.setValue(new Date(remoteFile.startTime.asMillis() + (long)this.offsetTimeInMS));
                startTimeInput.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                this.dataTable.setWidget(y, 4, (Widget)startTimeInput);
            }
            if (remoteFile.mime == null) {
                if (remoteFile.message == null) {
                    this.dataTable.setWidget(y, 5, (Widget)new Label(""));
                } else {
                    this.dataTable.setWidget(y, 5, (Widget)new Label(remoteFile.message));
                }
            } else {
                ListBox mimeTypeBox = new ListBox();
                mimeTypeBox.setMultipleSelect(false);
                mimeTypeBox.addItem(MimeType.mp4.name());
                mimeTypeBox.addItem(MimeType.mp4panorama.name());
                mimeTypeBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                mimeTypeBox.setSelectedIndex(MimeType.mp4 == remoteFile.mime ? 0 : 1);
                this.dataTable.setWidget(y, 5, (Widget)mimeTypeBox);
            }
            FlowPanel ft = new FlowPanel();
            this.dataTable.setWidget(y, 6, (Widget)ft);
            Button refresh = new Button(this.stringMessages.refresh());
            refresh.setEnabled(remoteFile.status == EStatus.WAIT_FOR_SAVE);
            refresh.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            ft.add((Widget)refresh);
            if (remoteFile.candidates != null) {
                if (remoteFile.candidates.isEmpty()) {
                    ft.add((Widget)new Label(this.stringMessages.empty()));
                } else {
                    for (Map.Entry entry : remoteFile.candidates.entrySet()) {
                        RegattaAndRaceIdentifier candidate = (RegattaAndRaceIdentifier)entry.getKey();
                        Boolean selected = (Boolean)entry.getValue();
                        CheckBox cb = new CheckBox(String.valueOf(candidate.getRegattaName()) + " " + candidate.getRaceName());
                        cb.setValue(selected, false);
                        cb.setEnabled(!remoteFile.isWorking);
                        cb.addStyleName(STYLE.checkboxStyle());
                        ft.add((Widget)cb);
                        cb.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                    }
                }
            }
            ++y;
        }
        this.doScanButton.setEnabled(!this.isWorking);
        if (!this.isWorking) {
            this.statusLabel.setText(this.stringMessages.multiVideoIdle());
        }
        if (this.isShowing()) {
            this.center();
        }
    }

    private void startNextLinkingRemoteTask() {
        if (!this.isShowing()) {
            return;
        }
        for (RemoteFileInfo remoteFile : this.remoteFiles) {
            if (remoteFile.status != EStatus.WAIT_FOR_SAVE || !remoteFile.selected) continue;
            Set selectedCandidates = remoteFile.candidates.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
            MediaTrack mediaTrack = new MediaTrack(remoteFile.url, remoteFile.url, remoteFile.startTime.plus((long)this.offsetTimeInMS), remoteFile.duration, remoteFile.mime, selectedCandidates);
            this.mediaServiceWrite.addMediaTrack(mediaTrack, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        this.afterLinking.run();
    }

    private void startNextInitializingRemoteTask() {
        if (!this.isShowing()) {
            return;
        }
        for (RemoteFileInfo remoteFile : this.remoteFiles) {
            if (!remoteFile.isWorking) continue;
            return;
        }
        this.doSaveButton.setEnabled(false);
        for (RemoteFileInfo remoteFile : this.remoteFiles) {
            this.statusLabel.setText(String.valueOf(this.stringMessages.analyze()) + ": " + remoteFile.url);
            this.statusLabel.setText(remoteFile.url);
            if (remoteFile.status == EStatus.WAITING_FOR_LINK) {
                remoteFile.isWorking = true;
                this.sailingService.getEvents((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                return;
            }
            if (remoteFile.status != EStatus.NOT_ANALYSED) continue;
            remoteFile.isWorking = true;
            this.checkMetadata(remoteFile, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            return;
        }
        this.doSaveButton.setEnabled(true);
        this.setWorking(false);
    }

    private void collectAllOverlappingRaces(RemoteFileInfo remoteFile, List<EventDTO> result, Set<RegattaAndRaceIdentifier> candidates) {
        for (EventDTO event : result) {
            for (LeaderboardGroupDTO groups : event.getLeaderboardGroups()) {
                for (StrippedLeaderboardDTO leaderboard : groups.getLeaderboards()) {
                    for (RaceColumnDTO raceColumn : leaderboard.getRaceList()) {
                        for (FleetDTO fleet : raceColumn.getFleets()) {
                            if (!raceColumn.isTrackedRace(fleet)) continue;
                            RaceDTO race = raceColumn.getRace(fleet);
                            if (race.trackedRace == null) continue;
                            Date startTimeWithOffset = remoteFile.startTime.plus((long)this.offsetTimeInMS).asDate();
                            if (race.endOfRace != null && !race.endOfRace.after(startTimeWithOffset) || race.trackedRace.endOfTracking != null && !race.trackedRace.endOfTracking.after(startTimeWithOffset)) continue;
                            long endTimeWithOffset = startTimeWithOffset.getTime() + remoteFile.duration.asMillis();
                            if (race.startOfRace != null && !race.startOfRace.before(new Date(endTimeWithOffset)) || race.trackedRace.startOfTracking != null && !race.trackedRace.startOfTracking.before(new Date(endTimeWithOffset))) continue;
                            candidates.add(race.getRaceIdentifier());
                        }
                    }
                }
            }
        }
    }

    private void checkMetadata(RemoteFileInfo file, AsyncCallback<VideoMetadataDTO> asyncCallback) {
        file.status = EStatus.SERVER_ANALYSE;
        this.updateUI();
        this.mediaServiceWrite.checkMetadata(file.url, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * Exception decompiling
     */
    private String asString(EStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void retrieveRemoteFileList(String url) {
        this.remoteFiles.clear();
        this.dataTable.clear();
        this.updateUI();
        JSDownloadUtils.getFileList((String)url, (JSDownloadUtils.JSHrefCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$0(MultiVideoDialog multiVideoDialog) {
        multiVideoDialog.startNextLinkingRemoteTask();
    }

    static /* synthetic */ void access$1(MultiVideoDialog multiVideoDialog) {
        multiVideoDialog.startNextInitializingRemoteTask();
    }

    static /* synthetic */ void access$2(MultiVideoDialog multiVideoDialog, RemoteFileInfo remoteFileInfo, List list, Set set) {
        multiVideoDialog.collectAllOverlappingRaces(remoteFileInfo, list, set);
    }

    static /* synthetic */ ErrorReporter access$3(MultiVideoDialog multiVideoDialog) {
        return multiVideoDialog.errorReporter;
    }

    static /* synthetic */ MediaServiceWriteAsync access$4(MultiVideoDialog multiVideoDialog) {
        return multiVideoDialog.mediaServiceWrite;
    }

    static /* synthetic */ Label access$5(MultiVideoDialog multiVideoDialog) {
        return multiVideoDialog.statusLabel;
    }

    static /* synthetic */ StringMessages access$6(MultiVideoDialog multiVideoDialog) {
        return multiVideoDialog.stringMessages;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$gwt$ui$adminconsole$multivideo$MultiVideoDialog$EStatus() {
        if ($SWITCH_TABLE$com$sap$sailing$gwt$ui$adminconsole$multivideo$MultiVideoDialog$EStatus != null) {
            return $SWITCH_TABLE$com$sap$sailing$gwt$ui$adminconsole$multivideo$MultiVideoDialog$EStatus;
        }
        int[] nArray = new int[EStatus.values().length];
        try {
            nArray[EStatus.ALREADY_ADDED.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.CLIENT_ANALYZE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.DONE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.ERROR_ANALYZE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.ERROR_DOWNLOAD.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.ERROR_LINKING.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.GETTING_MEDIATRACK.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.NOT_ANALYSED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.SERVER_ANALYSE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.WAITING_FOR_LINK.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[EStatus.WAIT_FOR_SAVE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$gwt$ui$adminconsole$multivideo$MultiVideoDialog$EStatus = nArray;
        return nArray;
    }

    static /* synthetic */ List access$8(MultiVideoDialog multiVideoDialog) {
        return multiVideoDialog.remoteFiles;
    }

    static /* synthetic */ Logger access$9() {
        return logger;
    }
}

