/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.InvalidColor;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sailing.gwt.ui.shared.racemap.Pattern;
import com.sap.sailing.gwt.ui.shared.racemap.Shape;
import com.sap.sse.gwt.client.ColorTextBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Arrays;
import java.util.UUID;

public class MarkTemplateEditDialog
extends DataEntryDialog<MarkTemplateDTO> {
    private final TextBox nameTextBox;
    private final ColorTextBox displayColorTextBox;
    private final TextBox shortNameTextBox;
    private final ValueListBox<MarkType> markTypeValueListBox;
    private final ValueListBox<Pattern> patternValueListBox;
    private final ValueListBox<Shape> shapeValueListBox;
    private final StringMessages stringMessages;
    private Label labelShape;
    private Label labelPattern;

    public MarkTemplateEditDialog(StringMessages stringMessages, MarkTemplateDTO markTemplateToEdit, DataEntryDialog.DialogCallback<MarkTemplateDTO> callback) {
        super(String.valueOf(stringMessages.edit()) + " " + stringMessages.markTemplates(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new /* Unavailable Anonymous Inner Class!! */, true, callback);
        this.ensureDebugId("MarkTemplateToEditEditDialog");
        this.stringMessages = stringMessages;
        this.labelPattern = new Label(stringMessages.pattern());
        this.patternValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.labelShape = new Label(stringMessages.shape());
        this.shapeValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.markTypeValueListBox = new ValueListBox((Renderer)new /* Unavailable Anonymous Inner Class!! */);
        this.nameTextBox = this.createTextBox(markTemplateToEdit.getName());
        this.shortNameTextBox = this.createTextBox(markTemplateToEdit.getCommonMarkProperties().getShortName());
        this.markTypeValueListBox.setValue((Object)(markTemplateToEdit.getCommonMarkProperties().getType() != null ? markTemplateToEdit.getCommonMarkProperties().getType() : MarkType.values()[0]));
        this.markTypeValueListBox.setAcceptableValues(Arrays.asList(MarkType.values()));
        this.markTypeValueListBox.addValueChangeHandler(v -> this.handleMarkTypeChange());
        this.displayColorTextBox = this.createColorTextBox(markTemplateToEdit.getCommonMarkProperties().getColor());
        this.shapeValueListBox.setValue(null);
        this.shapeValueListBox.setAcceptableValues(Arrays.asList(Shape.values()));
        this.patternValueListBox.setValue(null);
        this.patternValueListBox.setAcceptableValues(Arrays.asList(Pattern.values()));
        this.handleMarkTypeChange();
    }

    private void handleMarkTypeChange() {
        boolean isBuoy = this.markTypeValueListBox.getValue() == MarkType.BUOY;
        this.shapeValueListBox.setVisible(isBuoy);
        this.patternValueListBox.setVisible(isBuoy);
        this.labelShape.setVisible(isBuoy);
        this.labelPattern.setVisible(isBuoy);
        if (!isBuoy) {
            this.shapeValueListBox.setValue(null);
            this.patternValueListBox.setValue(null);
        }
        this.validateAndUpdate();
    }

    protected Focusable getInitialFocusWidget() {
        return this.nameTextBox;
    }

    protected MarkTemplateDTO getResult() {
        Object color = !this.displayColorTextBox.isValid() ? new InvalidColor(this.stringMessages, this.displayColorTextBox.getValue()) : this.displayColorTextBox.getColor();
        MarkTemplateDTO markTemplate = new MarkTemplateDTO(UUID.randomUUID(), this.nameTextBox.getValue(), this.shortNameTextBox.getValue(), color, this.shapeValueListBox.getValue() == null ? "" : ((Shape)this.shapeValueListBox.getValue()).name(), this.patternValueListBox.getValue() == null ? "" : ((Pattern)this.patternValueListBox.getValue()).name(), (MarkType)this.markTypeValueListBox.getValue());
        return markTemplate;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(6, 2);
        result.setWidget(0, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(0, 1, (Widget)this.nameTextBox);
        result.setWidget(1, 0, (Widget)new Label(this.stringMessages.shortName()));
        result.setWidget(1, 1, (Widget)this.shortNameTextBox);
        result.setWidget(2, 0, (Widget)new Label(this.stringMessages.color()));
        result.setWidget(2, 1, (Widget)this.displayColorTextBox);
        result.setWidget(3, 0, (Widget)this.labelShape);
        result.setWidget(3, 1, (Widget)this.shapeValueListBox);
        result.setWidget(4, 0, (Widget)this.labelPattern);
        result.setWidget(4, 1, (Widget)this.patternValueListBox);
        result.setWidget(5, 0, (Widget)new Label(this.stringMessages.type()));
        result.setWidget(5, 1, (Widget)this.markTypeValueListBox);
        return result;
    }
}

