/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AdminConsoleResources;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkPropertiesDeviceIdentifierEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkPropertiesEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkPropertiesPanel;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkPropertiesPositionEditDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkPropertiesDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class MarkPropertiesPanel
extends FlowPanel
implements FilterablePanelProvider<MarkPropertiesDTO> {
    private static AdminConsoleResources resources = (AdminConsoleResources)GWT.create(AdminConsoleResources.class);
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private static final AbstractImagePrototype positionImagePrototype = AbstractImagePrototype.create((ImageResource)resources.ping());
    private static final AbstractImagePrototype setDeviceIdentifierImagePrototype = AbstractImagePrototype.create((ImageResource)resources.mapDevices());
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final LabeledAbstractFilterablePanel<MarkPropertiesDTO> filterableMarkProperties;
    private List<MarkPropertiesDTO> allMarkProperties;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private FlushableCellTable<MarkPropertiesDTO> markPropertiesTable;
    private ListDataProvider<MarkPropertiesDTO> markPropertiesListDataProvider = new ListDataProvider();
    private RefreshableMultiSelectionModel<MarkPropertiesDTO> refreshableSelectionModel;

    public MarkPropertiesPanel(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, UserService userService) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        AccessControlledButtonPanel buttonAndFilterPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.MARK_TEMPLATE);
        this.add((Widget)buttonAndFilterPanel);
        this.allMarkProperties = new ArrayList();
        Label lblFilterRaces = new Label(String.valueOf(stringMessages.filterMarkPropertiesByName()) + ":");
        lblFilterRaces.setWordWrap(false);
        this.filterableMarkProperties = new /* Unavailable Anonymous Inner Class!! */;
        this.createMarkPropertiesTable(userService);
        buttonAndFilterPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.loadMarkProperties());
        buttonAndFilterPanel.addCreateAction(stringMessages.add(), () -> this.openEditMarkPropertiesDialog(new MarkPropertiesDTO()));
        buttonAndFilterPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableSelectionModel, true, () -> this.removeMarkProperties((Collection)this.refreshableSelectionModel.getSelectedSet().stream().map(markPropertiesDTO -> markPropertiesDTO.getUuid()).collect(Collectors.toList())));
        buttonAndFilterPanel.addUnsecuredWidget((Widget)lblFilterRaces);
        this.filterableMarkProperties.getTextBox().ensureDebugId("MarkPropertiesFilterTextBox");
        buttonAndFilterPanel.addUnsecuredWidget((Widget)this.filterableMarkProperties);
        this.filterableMarkProperties.setUpdatePermissionFilterForCheckbox(event -> userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    private void removeMarkProperties(Collection<UUID> markPropertiesUuids) {
        if (!markPropertiesUuids.isEmpty()) {
            this.sailingServiceWrite.removeMarkProperties(markPropertiesUuids, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void loadMarkProperties() {
        this.markPropertiesListDataProvider.getList().clear();
        this.sailingServiceWrite.getMarkProperties((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createMarkPropertiesTable(UserService userService) {
        this.markPropertiesTable = new FlushableCellTable(1000, (CellTable.Resources)tableResources);
        this.markPropertiesTable.setWidth("100%");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.markPropertiesListDataProvider.getList());
        this.markPropertiesTable.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        this.initTableColumns(sortHandler, userService);
        this.markPropertiesListDataProvider.addDataDisplay((HasData)this.markPropertiesTable);
        this.add((Widget)this.markPropertiesTable);
        this.allMarkProperties.clear();
        this.allMarkProperties.addAll(this.markPropertiesListDataProvider.getList());
    }

    private void initTableColumns(ColumnSortEvent.ListHandler<MarkPropertiesDTO> sortHandler, UserService userService) {
        SelectionCheckboxColumn checkColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterableMarkProperties.getAllListDataProvider(), (Flushable)this.markPropertiesTable);
        this.markPropertiesTable.addColumn((Column)checkColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        this.markPropertiesTable.setColumnWidth((Column)checkColumn, 40.0, Style.Unit.PX);
        5 idColumn = new /* Unavailable Anonymous Inner Class!! */;
        6 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 shortNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 colorColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 shapeColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 patternColumn = new /* Unavailable Anonymous Inner Class!! */;
        11 typeColumn = new /* Unavailable Anonymous Inner Class!! */;
        12 tagsColumn = new /* Unavailable Anonymous Inner Class!! */;
        14 positioningColumn = new /* Unavailable Anonymous Inner Class!! */;
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.markPropertiesTable.addColumn((Column)nameColumn, this.stringMessages.name());
        this.markPropertiesTable.addColumn((Column)shortNameColumn, this.stringMessages.shortName());
        this.markPropertiesTable.addColumn((Column)colorColumn, this.stringMessages.color());
        this.markPropertiesTable.addColumn((Column)shapeColumn, this.stringMessages.shape());
        this.markPropertiesTable.addColumn((Column)patternColumn, this.stringMessages.pattern());
        this.markPropertiesTable.addColumn((Column)typeColumn, this.stringMessages.type());
        this.markPropertiesTable.addColumn((Column)positioningColumn, this.stringMessages.position());
        this.markPropertiesTable.addColumn((Column)tagsColumn, this.stringMessages.tags());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.markPropertiesTable, sortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        HasPermissions type = SecuredDomainType.MARK_PROPERTIES;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new MarkPropertiesImagesbarCell(this.stringMessages), (UserService)userService);
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, markProperties -> this.markPropertiesListDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, markProperties -> {
            AccessControlListDTO accessControlListDTO = markProperties.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, e -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveMarkProperties(e.getName()))) {
                this.sailingServiceWrite.removeMarkProperties(Collections.singletonList(e.getUuid()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditMarkPropertiesDialog(arg_0));
        actionsColumn.addAction("ACTION_SET_DEVICE_IDENTIFIER", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditMarkPropertiesDeviceIdentifierDialog(arg_0));
        actionsColumn.addAction("ACTION_SET_POSITION", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.openEditMarkPropertiesPositionDialog(arg_0));
        actionsColumn.addAction("ACTION_UNSET_POSITION", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.unsetPosition(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, markProperties -> configACL.openDialog((SecuredDTO)markProperties));
        this.markPropertiesTable.addColumn((Column)idColumn, this.stringMessages.id());
        this.markPropertiesTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        this.refreshableSelectionModel = checkColumn.getSelectionModel();
        this.markPropertiesTable.setSelectionModel((SelectionModel)checkColumn.getSelectionModel(), checkColumn.getSelectionManager());
    }

    public void refreshMarkProperties() {
        this.loadMarkProperties();
    }

    void openEditMarkPropertiesDialog(MarkPropertiesDTO originalMarkProperties) {
        MarkPropertiesEditDialog dialog = new MarkPropertiesEditDialog(this.stringMessages, originalMarkProperties, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("MarkPropertiesEditDialog");
        dialog.show();
    }

    void openEditMarkPropertiesDeviceIdentifierDialog(MarkPropertiesDTO originalMarkProperties) {
        MarkPropertiesDeviceIdentifierEditDialog dialog = new MarkPropertiesDeviceIdentifierEditDialog(this.stringMessages, null, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("MarkPropertiesDeviceIdentifierEditDialog");
        dialog.show();
    }

    private void unsetPosition(MarkPropertiesDTO originalMarkProperties) {
        if (Window.confirm((String)this.stringMessages.confirmUnsettingPositionForMarkProperties(originalMarkProperties.getName()))) {
            this.sailingServiceWrite.updateMarkPropertiesPositioning(originalMarkProperties.getUuid(), null, null, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    void openEditMarkPropertiesPositionDialog(MarkPropertiesDTO originalMarkProperties) {
        MarkPropertiesPositionEditDialog dialog = new MarkPropertiesPositionEditDialog(this.stringMessages, null, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("MarkPropertiesPositionEditDialog");
        dialog.show();
    }

    public AbstractFilterablePanel<MarkPropertiesDTO> getFilterablePanel() {
        return this.filterableMarkProperties;
    }

    static /* synthetic */ AdminConsoleResources access$0() {
        return resources;
    }

    static /* synthetic */ FlushableCellTable access$1(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.markPropertiesTable;
    }

    static /* synthetic */ ErrorReporter access$2(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.errorReporter;
    }

    static /* synthetic */ ListDataProvider access$3(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.markPropertiesListDataProvider;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$4(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.filterableMarkProperties;
    }

    static /* synthetic */ AbstractImagePrototype access$5() {
        return positionImagePrototype;
    }

    static /* synthetic */ AbstractImagePrototype access$6() {
        return setDeviceIdentifierImagePrototype;
    }

    static /* synthetic */ StringMessages access$7(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.stringMessages;
    }

    static /* synthetic */ SailingServiceWriteAsync access$8(MarkPropertiesPanel markPropertiesPanel) {
        return markPropertiesPanel.sailingServiceWrite;
    }
}

