/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.CourseTemplateEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.CourseTemplatePanel;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.CourseTemplateDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkRoleDTO;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkTemplateDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class CourseTemplatePanel
extends FlowPanel
implements FilterablePanelProvider<CourseTemplateDTO> {
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final SailingServiceWriteAsync sailingService;
    private final LabeledAbstractFilterablePanel<CourseTemplateDTO> filterableCourseTemplatePanel;
    private List<CourseTemplateDTO> allCourseTemplates;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private FlushableCellTable<CourseTemplateDTO> courseTemplateTable;
    private ListDataProvider<CourseTemplateDTO> courseTemplateListDataProvider = new ListDataProvider();
    private RefreshableMultiSelectionModel<CourseTemplateDTO> refreshableSelectionModel;
    private List<MarkRoleDTO> allMarkRoles;
    private List<MarkTemplateDTO> allMarkTemplates;

    public CourseTemplatePanel(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, UserService userService) {
        this.sailingService = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        AccessControlledButtonPanel buttonAndFilterPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.MARK_TEMPLATE);
        this.add((Widget)buttonAndFilterPanel);
        this.allCourseTemplates = new ArrayList();
        Label lblFilterRaces = new Label(String.valueOf(stringMessages.filterCourseTemplateByName()) + ":");
        lblFilterRaces.setWordWrap(false);
        this.filterableCourseTemplatePanel = new /* Unavailable Anonymous Inner Class!! */;
        this.filterableCourseTemplatePanel.getTextBox().ensureDebugId("CourseTemplateFilterTextBox");
        this.createCourseTemplateTable(userService);
        buttonAndFilterPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.loadCourseTemplates());
        buttonAndFilterPanel.addCreateAction(stringMessages.add(), () -> this.openEditCourseTemplateDialog(new CourseTemplateDTO(), userService, true));
        buttonAndFilterPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableSelectionModel, true, () -> this.removeCourseTemplates((Collection)this.refreshableSelectionModel.getSelectedSet().stream().map(courseTemplateDTO -> courseTemplateDTO.getUuid()).collect(Collectors.toList())));
        buttonAndFilterPanel.addUnsecuredWidget((Widget)lblFilterRaces);
        buttonAndFilterPanel.addUnsecuredWidget((Widget)this.filterableCourseTemplatePanel);
        this.filterableCourseTemplatePanel.setUpdatePermissionFilterForCheckbox(event -> userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    private void removeCourseTemplates(Collection<UUID> courseTemplatesUuids) {
        if (!courseTemplatesUuids.isEmpty()) {
            this.sailingService.removeCourseTemplates(courseTemplatesUuids, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void loadCourseTemplates() {
        this.courseTemplateListDataProvider.getList().clear();
        this.sailingService.getCourseTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadMarkRoles() {
        this.sailingService.getMarkRoles((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadMarkTemplates() {
        this.sailingService.getMarkTemplates((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createCourseTemplateTable(UserService userService) {
        this.courseTemplateTable = new FlushableCellTable(1000, (CellTable.Resources)tableResources);
        this.courseTemplateTable.setWidth("100%");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.courseTemplateListDataProvider.getList());
        this.courseTemplateTable.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        this.initTableColumns(sortHandler, userService);
        this.courseTemplateListDataProvider.addDataDisplay((HasData)this.courseTemplateTable);
        this.add((Widget)this.courseTemplateTable);
        this.allCourseTemplates.clear();
        this.allCourseTemplates.addAll(this.courseTemplateListDataProvider.getList());
    }

    private void initTableColumns(ColumnSortEvent.ListHandler<CourseTemplateDTO> sortHandler, UserService userService) {
        SelectionCheckboxColumn checkColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterableCourseTemplatePanel.getAllListDataProvider(), (Flushable)this.courseTemplateTable);
        this.courseTemplateTable.addColumn((Column)checkColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        this.courseTemplateTable.setColumnWidth((Column)checkColumn, 40.0, Style.Unit.PX);
        7 idColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 urlColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 tagsColumn = new /* Unavailable Anonymous Inner Class!! */;
        11 waypointTemplateCountColumn = new /* Unavailable Anonymous Inner Class!! */;
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.courseTemplateTable.addColumn((Column)nameColumn, this.stringMessages.name());
        this.courseTemplateTable.addColumn((Column)urlColumn, this.stringMessages.url());
        this.courseTemplateTable.addColumn((Column)tagsColumn, this.stringMessages.tags());
        this.courseTemplateTable.addColumn((Column)waypointTemplateCountColumn, this.stringMessages.waypoints());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.courseTemplateTable, sortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        HasPermissions type = SecuredDomainType.COURSE_TEMPLATE;
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, courseTemplateDTO -> this.courseTemplateListDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, courseTemplate -> {
            AccessControlListDTO accessControlListDTO = courseTemplate.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, e -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveCourseTemplate(e.getName()))) {
                this.sailingService.removeCourseTemplates(Collections.singletonList(e.getUuid()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, e -> this.openEditCourseTemplateDialog(e, userService, false));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, courseTemplate -> configACL.openDialog((SecuredDTO)courseTemplate));
        this.courseTemplateTable.addColumn((Column)idColumn, this.stringMessages.id());
        this.courseTemplateTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        this.refreshableSelectionModel = checkColumn.getSelectionModel();
        this.courseTemplateTable.setSelectionModel((SelectionModel)this.refreshableSelectionModel, checkColumn.getSelectionManager());
    }

    public void refreshCourseTemplates() {
        this.loadCourseTemplates();
        this.loadMarkRoles();
        this.loadMarkTemplates();
    }

    void openEditCourseTemplateDialog(CourseTemplateDTO originalCourseTemplate, UserService userService, boolean isNew) {
        CourseTemplateEditDialog dialog = new CourseTemplateEditDialog((SailingServiceAsync)this.sailingService, this.stringMessages, originalCourseTemplate, this.allMarkRoles, this.allMarkTemplates, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, isNew);
        dialog.ensureDebugId("CourseTemplateEditDialog");
        dialog.show();
    }

    public AbstractFilterablePanel<CourseTemplateDTO> getFilterablePanel() {
        return this.filterableCourseTemplatePanel;
    }

    static /* synthetic */ FlushableCellTable access$0(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.courseTemplateTable;
    }

    static /* synthetic */ ErrorReporter access$1(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.errorReporter;
    }

    static /* synthetic */ ListDataProvider access$2(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.courseTemplateListDataProvider;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$3(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.filterableCourseTemplatePanel;
    }

    static /* synthetic */ void access$4(CourseTemplatePanel courseTemplatePanel, List list) {
        courseTemplatePanel.allMarkRoles = list;
    }

    static /* synthetic */ void access$5(CourseTemplatePanel courseTemplatePanel, List list) {
        courseTemplatePanel.allMarkTemplates = list;
    }

    static /* synthetic */ StringMessages access$6(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.stringMessages;
    }

    static /* synthetic */ SailingServiceWriteAsync access$7(CourseTemplatePanel courseTemplatePanel) {
        return courseTemplatePanel.sailingService;
    }
}

