/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AddWindFixDialog;
import com.sap.sailing.gwt.ui.adminconsole.ExpeditionAllInOneImportPanel;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.WindPanel;
import com.sap.sailing.gwt.ui.adminconsole.WindSourcesToExcludeSelectorPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.CoursePositionsDTO;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class WindPanel
extends FormPanel
implements FilterablePanelProvider<RaceDTO> {
    private static final String URL_SAILINGSERVER_EXPEDITION_IMPORT = "/../../sailingserver/expedition-import";
    private static final String URL_SAILINGSERVER_GRIB_IMPORT = "/../../sailingserver/grib-wind-import";
    private static final String URL_SAILINGSERVER_NMEA_IMPORT = "/../../sailingserver/nmea-wind-import";
    private static final String URL_SAILINGSERVER_ROUTECONVERTER_IMPORT = "/../../sailingserver/routeconverter-wind-import";
    private static final String URL_SAILINGSERVER_BRAVO_IMPORT = "/../../sailingserver/bravo-wind-import";
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final TextColumn<WindDTO> timeColumn;
    private final TextColumn<WindDTO> speedInKnotsColumn;
    private final TextColumn<WindDTO> windDirectionInDegColumn;
    private final TextColumn<WindDTO> positionColumn;
    private final TrackedRacesListComposite trackedRacesListComposite;
    private final RefreshableMultiSelectionModel<RaceDTO> refreshableRaceSelectionModel;
    private final WindSourcesToExcludeSelectorPanel windSourcesToExcludeSelectorPanel;
    private final CheckBox raceIsKnownToStartUpwindBox;
    private final CaptionPanel windCaptionPanel;
    private final Button addWindFixButton;
    private final VerticalPanel windFixesDisplayPanel;
    private final Label windSourceLabel;
    private final ListDataProvider<WindDTO> rawWindFixesDataProvider;
    private final CellTable<WindDTO> rawWindFixesTable;
    private final VerticalPanel windFixPanel;
    private final Predicate<RaceDTO> userPermission;
    private final Displayer<RegattaDTO> regattasDisplayer;
    private final Set<Displayer<RegattaDTO>> containedRegattaDisplayers;
    private CaptionPanel expeditionImportPanel;
    private CaptionPanel gribImportPanel;
    private CaptionPanel nmeaImportPanel;
    private CaptionPanel bravoImportPanel;
    private CaptionPanel igtimiImportPanel;
    private CaptionPanel routeconverterImportPanel;
    private CaptionPanel expeditionAllInOneImporterPanel;

    public WindPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.ensureDebugId("WindPanel");
        this.regattasDisplayer = result -> this.fillRegattas(result);
        this.userPermission = race -> presenter.getUserService().hasPermission((SecuredDTO)race, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE);
        this.sailingServiceWrite = presenter.getSailingService();
        this.userService = presenter.getUserService();
        this.containedRegattaDisplayers = new HashSet();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        this.windSourcesToExcludeSelectorPanel = new WindSourcesToExcludeSelectorPanel(this.sailingServiceWrite, stringMessages, this.errorReporter);
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setSize("100%", "100%");
        this.setWidget((Widget)mainPanel);
        this.trackedRacesListComposite = new TrackedRacesListComposite(null, null, presenter, stringMessages, true, false);
        this.containedRegattaDisplayers.add(this.trackedRacesListComposite.getRegattasDisplayer());
        this.trackedRacesListComposite.ensureDebugId("TrackedRacesListComposite");
        mainPanel.add((Widget)this.trackedRacesListComposite);
        this.refreshableRaceSelectionModel = (RefreshableMultiSelectionModel)this.trackedRacesListComposite.getSelectionModel();
        this.refreshableRaceSelectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.windCaptionPanel = new CaptionPanel(stringMessages.wind());
        this.windCaptionPanel.setVisible(false);
        mainPanel.add((Widget)this.windCaptionPanel);
        TabPanel tabPanel = new TabPanel();
        tabPanel.setAnimationEnabled(true);
        this.windCaptionPanel.add((Widget)tabPanel);
        tabPanel.setWidth("100%");
        this.windFixesDisplayPanel = new VerticalPanel();
        this.addWindFixButton = new Button(String.valueOf(stringMessages.actionAddWindData()) + "...");
        this.addWindFixButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.windFixesDisplayPanel.add((Widget)this.addWindFixButton);
        VerticalPanel windSourcesPanel = new VerticalPanel();
        windSourcesPanel.setSpacing(10);
        tabPanel.add((Widget)windSourcesPanel, stringMessages.windSourcesUsed());
        tabPanel.add((Widget)this.windFixesDisplayPanel, stringMessages.windFixes());
        tabPanel.selectTab(0);
        this.raceIsKnownToStartUpwindBox = new CheckBox(stringMessages.raceIsKnownToStartUpwind());
        windSourcesPanel.add((Widget)this.raceIsKnownToStartUpwindBox);
        windSourcesPanel.add((Widget)this.windSourcesToExcludeSelectorPanel);
        this.raceIsKnownToStartUpwindBox.addValueChangeHandler(event -> this.setRaceIsKnownToStartUpwind());
        this.windFixPanel = new VerticalPanel();
        windSourcesPanel.add((Widget)this.windFixPanel);
        this.windSourceLabel = new Label();
        this.windFixesDisplayPanel.add((Widget)this.windSourceLabel);
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages), (UserService)this.userService, item -> this.trackedRacesListComposite.getRaceByIdentifier((RaceIdentifier)this.getSelectedRace()));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, wind -> {
            ArrayList selectedRaces = new ArrayList(this.refreshableRaceSelectionModel.getSelectedSet());
            RegattaAndRaceIdentifier raceIdentifier = ((RaceDTO)selectedRaces.get(selectedRaces.size() - 1)).getRaceIdentifier();
            this.sailingServiceWrite.removeWind(raceIdentifier, wind, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        });
        this.timeColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.speedInKnotsColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.windDirectionInDegColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.positionColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.timeColumn.setSortable(true);
        this.speedInKnotsColumn.setSortable(true);
        this.windDirectionInDegColumn.setSortable(true);
        AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.rawWindFixesTable = new BaseCelltable(10000, (CellTable.Resources)tableRes);
        this.rawWindFixesTable.addColumn((Column)this.timeColumn, stringMessages.time());
        this.rawWindFixesTable.addColumn((Column)this.speedInKnotsColumn, stringMessages.speedInKnots());
        this.rawWindFixesTable.addColumn((Column)this.windDirectionInDegColumn, stringMessages.fromDeg());
        this.rawWindFixesTable.addColumn((Column)this.positionColumn, stringMessages.position());
        this.rawWindFixesTable.addColumn((Column)actionsColumn, stringMessages.actions());
        this.rawWindFixesDataProvider = new ListDataProvider();
        this.rawWindFixesDataProvider.addDataDisplay((HasData)this.rawWindFixesTable);
        ColumnSortEvent.Handler columnSortHandler = this.getWindTableColumnSortHandler(this.rawWindFixesDataProvider.getList(), this.timeColumn, this.speedInKnotsColumn, this.windDirectionInDegColumn);
        this.rawWindFixesTable.addColumnSortHandler(columnSortHandler);
        this.rawWindFixesTable.getColumnSortList().push((Column)this.timeColumn);
        this.windFixesDisplayPanel.add((Widget)this.rawWindFixesTable);
        this.expeditionImportPanel = this.createExpeditionWindImportPanel();
        this.gribImportPanel = this.createGribWindImportPanel();
        this.nmeaImportPanel = this.createNmeaWindImportPanel();
        this.routeconverterImportPanel = this.createRouteconverterWindImportPanel();
        this.bravoImportPanel = this.createBravoWindImportPanel();
        this.igtimiImportPanel = this.igtimiImportPanel(mainPanel);
        mainPanel.add((Widget)this.expeditionImportPanel);
        mainPanel.add((Widget)this.gribImportPanel);
        mainPanel.add((Widget)this.nmeaImportPanel);
        mainPanel.add((Widget)this.routeconverterImportPanel);
        mainPanel.add((Widget)this.bravoImportPanel);
        mainPanel.add((Widget)this.igtimiImportPanel);
        Util.Pair expeditionAllInOneRootAndImportPanel = this.createExpeditionAllInOneImportPanel(presenter);
        this.expeditionAllInOneImporterPanel = (CaptionPanel)expeditionAllInOneRootAndImportPanel.getA();
        mainPanel.add((Widget)this.expeditionAllInOneImporterPanel);
        this.containedRegattaDisplayers.add(((ExpeditionAllInOneImportPanel)expeditionAllInOneRootAndImportPanel.getB()).getRegattasDisplayer());
        this.updateVisibilityStateForPanels();
        this.userService.addUserStatusEventHandler((UserStatusEventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateVisibilityStateForPanels() {
        Set selectedRaces = this.refreshableRaceSelectionModel.getSelectedSet();
        if (selectedRaces.isEmpty()) {
            this.expeditionImportPanel.setVisible(true);
            this.gribImportPanel.setVisible(true);
            this.nmeaImportPanel.setVisible(true);
            this.bravoImportPanel.setVisible(true);
            this.igtimiImportPanel.setVisible(true);
        } else {
            boolean canUpdateAll = true;
            for (RaceDTO race : this.refreshableRaceSelectionModel.getSelectedSet()) {
                if (this.userPermission.test(race)) continue;
                canUpdateAll = false;
            }
            this.expeditionImportPanel.setVisible(canUpdateAll);
            this.gribImportPanel.setVisible(canUpdateAll);
            this.nmeaImportPanel.setVisible(canUpdateAll);
            this.bravoImportPanel.setVisible(canUpdateAll);
            this.igtimiImportPanel.setVisible(canUpdateAll);
        }
        boolean canCreateEvent = this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.EVENT);
        boolean canCreateRegatta = this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.REGATTA);
        boolean canCreateRace = this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.TRACKED_RACE);
        boolean canCreateLeaderboard = this.userService.hasCurrentUserPermissionToCreateObjectOfType(SecuredDomainType.LEADERBOARD);
        this.expeditionAllInOneImporterPanel.setVisible(canCreateEvent && canCreateLeaderboard && canCreateRace && canCreateRegatta);
    }

    private CaptionPanel igtimiImportPanel(VerticalPanel mainPanel) {
        return this.createIgtimiWindImportPanel(mainPanel);
    }

    private CaptionPanel createIgtimiWindImportPanel(VerticalPanel mainPanel) {
        CaptionPanel igtimiWindImportRootPanel = new CaptionPanel(this.stringMessages.igtimiWindImport());
        VerticalPanel contentPanel = new VerticalPanel();
        igtimiWindImportRootPanel.add((Widget)contentPanel);
        contentPanel.add((Widget)new Label(this.stringMessages.seeIgtimiTabForAccountSettings()));
        CheckBox correctByDeclination = new CheckBox(this.stringMessages.declinationCheckbox());
        correctByDeclination.setValue(Boolean.valueOf(true));
        Button importButton = new Button(this.stringMessages.importWindFromIgtimi());
        importButton.ensureDebugId("ImportWindFromIgtimi");
        HTML resultReport = new HTML();
        resultReport.ensureDebugId("IgtimiImportResultReport");
        importButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        contentPanel.add((Widget)correctByDeclination);
        contentPanel.add((Widget)importButton);
        contentPanel.add((Widget)resultReport);
        return igtimiWindImportRootPanel;
    }

    private WindImportFileUploadForm createWindImportFileUploadForm(String relativeUploadUrl, boolean multi, Optional<String> submitButtonDebugId, Optional<String> uploadFormDebugId, Optional<String> importResultPanelDebugId) {
        FormPanel form = new FormPanel();
        VerticalPanel formContentPanel = new VerticalPanel();
        form.add((Widget)formContentPanel);
        VerticalPanel importResultPanel = new VerticalPanel();
        formContentPanel.add((Widget)importResultPanel);
        importResultPanelDebugId.map(arg_0 -> WindPanel.lambda$5((Panel)importResultPanel, arg_0));
        form.setMethod("post");
        form.setEncoding("multipart/form-data");
        form.setAction(String.valueOf(GWT.getHostPageBaseURL()) + relativeUploadUrl);
        Button submitButton = new Button(this.stringMessages.windImport_Upload(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        submitButton.setEnabled(false);
        submitButtonDebugId.map(id -> {
            submitButton.ensureDebugId(id);
            return null;
        });
        FileUpload fileUpload = new FileUpload();
        fileUpload.setName("upload");
        uploadFormDebugId.map(id -> {
            fileUpload.ensureDebugId(id);
            return null;
        });
        if (multi) {
            fileUpload.getElement().setAttribute("multiple", "multiple");
        }
        Hidden hiddenRacesField = new Hidden("races");
        formContentPanel.add((Widget)hiddenRacesField);
        formContentPanel.add((Widget)fileUpload);
        formContentPanel.add((Widget)submitButton);
        form.addSubmitHandler((FormPanel.SubmitHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addSubmitCompleteHandler((FormPanel.SubmitCompleteHandler)new /* Unavailable Anonymous Inner Class!! */);
        return new WindImportFileUploadForm(form, formContentPanel, fileUpload, submitButton);
    }

    private Util.Pair<CaptionPanel, ExpeditionAllInOneImportPanel> createExpeditionAllInOneImportPanel(AdminConsoleView.Presenter presenter) {
        CaptionPanel rootPanel = new CaptionPanel(this.stringMessages.importFullExpeditionData());
        ExpeditionAllInOneImportPanel expeditionAllInOneImportPanel = new ExpeditionAllInOneImportPanel(this.stringMessages, presenter);
        rootPanel.add((Widget)expeditionAllInOneImportPanel);
        return new Util.Pair((Object)rootPanel, (Object)expeditionAllInOneImportPanel);
    }

    private CaptionPanel createExpeditionWindImportPanel() {
        WindImportFileUploadForm formAndFileUploadAndSubmitButton = this.createWindImportFileUploadForm(URL_SAILINGSERVER_EXPEDITION_IMPORT, true, Optional.empty(), Optional.empty(), Optional.empty());
        CaptionPanel windImportRootPanel = new CaptionPanel(this.stringMessages.windImport_Title());
        VerticalPanel windImportContentPanel = new VerticalPanel();
        windImportRootPanel.add((Widget)windImportContentPanel);
        FormPanel form = formAndFileUploadAndSubmitButton.getFormPanel();
        windImportContentPanel.add((Widget)form);
        VerticalPanel formContentPanel = formAndFileUploadAndSubmitButton.getFormContentPanel();
        HorizontalPanel inputPanel = new HorizontalPanel();
        formContentPanel.add((Widget)inputPanel);
        VerticalPanel importResultPanel = new VerticalPanel();
        windImportContentPanel.add((Widget)importResultPanel);
        TextBox boatIdTextBox = new TextBox();
        boatIdTextBox.setName("boatId");
        Button submitButton = formAndFileUploadAndSubmitButton.getSubmitButton();
        FileUpload fileUpload = formAndFileUploadAndSubmitButton.getFileUpload();
        fileUpload.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Label boatIdLabel = new Label(this.stringMessages.windImport_BoatId());
        inputPanel.add((Widget)boatIdLabel);
        inputPanel.add((Widget)boatIdTextBox);
        boatIdLabel.setWordWrap(false);
        inputPanel.setSpacing(5);
        inputPanel.setCellVerticalAlignment((Widget)fileUpload, HasVerticalAlignment.ALIGN_MIDDLE);
        inputPanel.setCellVerticalAlignment((Widget)boatIdLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        inputPanel.setCellVerticalAlignment((Widget)boatIdTextBox, HasVerticalAlignment.ALIGN_MIDDLE);
        return windImportRootPanel;
    }

    private CaptionPanel createNmeaWindImportPanel() {
        String importServletUrl = URL_SAILINGSERVER_NMEA_IMPORT;
        String title = this.stringMessages.nmeaWindImport_Title();
        return this.createWindImportPanel(title, URL_SAILINGSERVER_NMEA_IMPORT, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private CaptionPanel createRouteconverterWindImportPanel() {
        String importServletUrl = URL_SAILINGSERVER_ROUTECONVERTER_IMPORT;
        String title = this.stringMessages.routeconverterWindImport_Title();
        return this.createWindImportPanel(title, URL_SAILINGSERVER_ROUTECONVERTER_IMPORT, Optional.of("ImportWindFromRouteconverterSubmit"), Optional.of("ImportWindFromRouteconverterUpload"), Optional.of("ImportWindFromRouteconverterResults"));
    }

    private CaptionPanel createGribWindImportPanel() {
        return this.createWindImportPanel(this.stringMessages.gribWindImport_Title(), URL_SAILINGSERVER_GRIB_IMPORT, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private CaptionPanel createBravoWindImportPanel() {
        return this.createWindImportPanel(this.stringMessages.bravoWindImport_Title(), URL_SAILINGSERVER_BRAVO_IMPORT, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private CaptionPanel createWindImportPanel(String title, String importServletUrl, Optional<String> submitButtonDebugId, Optional<String> uploadFormDebugId, Optional<String> importResultPanelDebugId) {
        WindImportFileUploadForm formAndFileUploadAndSubmitButton = this.createWindImportFileUploadForm(importServletUrl, true, submitButtonDebugId, uploadFormDebugId, importResultPanelDebugId);
        CaptionPanel windImportRootPanel = new CaptionPanel(title);
        VerticalPanel windImportContentPanel = new VerticalPanel();
        windImportRootPanel.add((Widget)windImportContentPanel);
        FormPanel form = formAndFileUploadAndSubmitButton.getFormPanel();
        windImportContentPanel.add((Widget)form);
        VerticalPanel formContentPanel = formAndFileUploadAndSubmitButton.getFormContentPanel();
        HorizontalPanel inputPanel = new HorizontalPanel();
        formContentPanel.add((Widget)inputPanel);
        VerticalPanel importResultPanel = new VerticalPanel();
        windImportContentPanel.add((Widget)importResultPanel);
        formAndFileUploadAndSubmitButton.getSubmitButton().setEnabled(true);
        FileUpload fileUpload = formAndFileUploadAndSubmitButton.getFileUpload();
        inputPanel.setSpacing(5);
        inputPanel.setCellVerticalAlignment((Widget)fileUpload, HasVerticalAlignment.ALIGN_MIDDLE);
        return windImportRootPanel;
    }

    private void showWindSettingDialog(RaceDTO race, CoursePositionsDTO course) {
        AddWindFixDialog windSettingDialog = new AddWindFixDialog(race, course, this.stringMessages, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        windSettingDialog.show();
    }

    private void addWindFix(WindDTO wind, RaceDTO race) {
        RegattaAndRaceIdentifier raceIdentifier = this.getSelectedRace();
        this.sailingServiceWrite.setWind(raceIdentifier, wind, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Displayer<RegattaDTO> getRegattasDisplayer() {
        return this.regattasDisplayer;
    }

    public void fillRegattas(Iterable<RegattaDTO> result) {
        for (Displayer containedRegattaDisplayer : this.containedRegattaDisplayers) {
            containedRegattaDisplayer.fill(result);
        }
    }

    public void showWind(RegattaAndRaceIdentifier raceIdentifier, RaceDTO race) {
        this.sailingServiceWrite.getWindSourcesInfo(raceIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateWindSourcesToExclude(WindInfoForRaceDTO result, RegattaAndRaceIdentifier raceIdentifier) {
        this.windSourcesToExcludeSelectorPanel.update(raceIdentifier, result.windTrackInfoByWindSource.keySet(), result.windSourcesToExclude);
    }

    private void udapteRawWindFixes(WindInfoForRaceDTO result) {
        for (Map.Entry e : result.windTrackInfoByWindSource.entrySet()) {
            if (((WindSource)e.getKey()).getType() != WindSourceType.WEB && ((WindSource)e.getKey()).getType() != WindSourceType.EXPEDITION) continue;
            this.windSourceLabel.setText(String.valueOf(this.stringMessages.windSource()) + ": " + e.getKey());
            ((WindSource)e.getKey()).getType();
            this.rawWindFixesDataProvider.getList().clear();
            this.rawWindFixesDataProvider.getList().addAll(((WindTrackInfoDTO)e.getValue()).windFixes);
        }
    }

    private ColumnSortEvent.Handler getWindTableColumnSortHandler(List<WindDTO> list, TextColumn<WindDTO> timeColumn, TextColumn<WindDTO> speedInKnotsColumn, TextColumn<WindDTO> windDirectionInDegColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(list);
        result.setComparator(timeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(speedInKnotsColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(windDirectionInDegColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void setRaceIsKnownToStartUpwind() {
        RegattaAndRaceIdentifier selectedRace = this.getSelectedRace();
        this.sailingServiceWrite.setRaceIsKnownToStartUpwind(selectedRace, this.raceIsKnownToStartUpwindBox.getValue().booleanValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private RegattaAndRaceIdentifier getSelectedRace() {
        Set selectedRaces = this.refreshableRaceSelectionModel.getSelectedSet();
        if (selectedRaces.isEmpty() || selectedRaces.size() > 1) {
            return null;
        }
        return ((RaceDTO)selectedRaces.iterator().next()).getRaceIdentifier();
    }

    private void clearWindSources() {
        Set emptySet = Collections.emptySet();
        this.windSourcesToExcludeSelectorPanel.update(null, emptySet, emptySet);
    }

    private void clearWindFixes() {
    }

    private void showWindFixesList(RegattaAndRaceIdentifier raceIdentifier, RaceDTO race) {
        ArrayList<String> windSourceTypeNames = new ArrayList<String>();
        windSourceTypeNames.add(WindSourceType.COMBINED.name());
        this.addWindFixButton.setVisible(this.userPermission.test(race));
        if (race.startOfRace != null) {
            this.sailingServiceWrite.getAveragedWindInfo(raceIdentifier, race.startOfRace, 30000L, 100, windSourceTypeNames, true, false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateWindDisplay() {
        RaceDTO race;
        RegattaAndRaceIdentifier selectedRace = this.getSelectedRace();
        RaceDTO raceDTO = race = selectedRace != null ? this.trackedRacesListComposite.getRaceByIdentifier((RaceIdentifier)selectedRace) : null;
        if (selectedRace != null && race != null && race.trackedRace != null) {
            this.windCaptionPanel.setVisible(true);
            this.windCaptionPanel.setCaptionText(String.valueOf(this.stringMessages.wind()) + ": " + race.getName());
            this.showWind(selectedRace, race);
            this.showWindFixesList(selectedRace, race);
        } else {
            this.windCaptionPanel.setVisible(false);
            this.windCaptionPanel.setCaptionText(this.stringMessages.wind());
            this.clearWindSources();
            this.clearWindFixes();
        }
    }

    public AbstractFilterablePanel<RaceDTO> getFilterablePanel() {
        return this.trackedRacesListComposite.filterablePanelRaces;
    }

    static /* synthetic */ void access$0(WindPanel windPanel) {
        windPanel.updateWindDisplay();
    }

    static /* synthetic */ void access$1(WindPanel windPanel) {
        windPanel.updateVisibilityStateForPanels();
    }

    static /* synthetic */ RegattaAndRaceIdentifier access$2(WindPanel windPanel) {
        return windPanel.getSelectedRace();
    }

    static /* synthetic */ TrackedRacesListComposite access$3(WindPanel windPanel) {
        return windPanel.trackedRacesListComposite;
    }

    static /* synthetic */ SailingServiceWriteAsync access$4(WindPanel windPanel) {
        return windPanel.sailingServiceWrite;
    }

    static /* synthetic */ void access$5(WindPanel windPanel, RaceDTO raceDTO, CoursePositionsDTO coursePositionsDTO) {
        windPanel.showWindSettingDialog(raceDTO, coursePositionsDTO);
    }

    static /* synthetic */ ListDataProvider access$6(WindPanel windPanel) {
        return windPanel.rawWindFixesDataProvider;
    }

    static /* synthetic */ ErrorReporter access$7(WindPanel windPanel) {
        return windPanel.errorReporter;
    }

    static /* synthetic */ StringMessages access$8(WindPanel windPanel) {
        return windPanel.stringMessages;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$9(WindPanel windPanel) {
        return windPanel.refreshableRaceSelectionModel;
    }

    static /* synthetic */ void access$10(WindPanel windPanel, WindDTO windDTO, RaceDTO raceDTO) {
        windPanel.addWindFix(windDTO, raceDTO);
    }

    static /* synthetic */ void access$11(WindPanel windPanel, WindInfoForRaceDTO windInfoForRaceDTO, RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        windPanel.updateWindSourcesToExclude(windInfoForRaceDTO, regattaAndRaceIdentifier);
    }

    static /* synthetic */ CheckBox access$12(WindPanel windPanel) {
        return windPanel.raceIsKnownToStartUpwindBox;
    }

    static /* synthetic */ Predicate access$13(WindPanel windPanel) {
        return windPanel.userPermission;
    }

    static /* synthetic */ Button access$14(WindPanel windPanel) {
        return windPanel.addWindFixButton;
    }

    static /* synthetic */ WindSourcesToExcludeSelectorPanel access$15(WindPanel windPanel) {
        return windPanel.windSourcesToExcludeSelectorPanel;
    }

    static /* synthetic */ void access$16(WindPanel windPanel, WindInfoForRaceDTO windInfoForRaceDTO) {
        windPanel.udapteRawWindFixes(windInfoForRaceDTO);
    }

    static /* synthetic */ void access$17(WindPanel windPanel) {
        windPanel.clearWindSources();
    }

    static /* synthetic */ void access$18(WindPanel windPanel) {
        windPanel.clearWindFixes();
    }

    static /* synthetic */ VerticalPanel access$19(WindPanel windPanel) {
        return windPanel.windFixPanel;
    }

    private static /* synthetic */ Object lambda$5(Panel panel, String id) {
        panel.ensureDebugId(id);
        return null;
    }
}

