/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.text.client.DateTimeFormatRenderer;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.SwissTimingEventManagementPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.adminconsole.swisstiming.SwissTimingConnectionDialog;
import com.sap.sailing.gwt.ui.adminconsole.swisstiming.SwissTimingConnectionTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingConfigurationWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.SwissTimingRaceRecordDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class SwissTimingEventManagementPanel
extends AbstractEventManagementPanel
implements FilterablePanelProvider<SwissTimingConfigurationWithSecurityDTO> {
    private static final AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final LabeledAbstractFilterablePanel<SwissTimingRaceRecordDTO> filterablePanelEvents;
    private final ListDataProvider<SwissTimingRaceRecordDTO> raceList;
    private final FlushableCellTable<SwissTimingRaceRecordDTO> raceTable;
    private final List<SwissTimingRaceRecordDTO> availableSwissTimingRaces = new ArrayList();
    private final SwissTimingConnectionTableWrapper connectionsTable;

    public SwissTimingEventManagementPanel(AdminConsoleView.Presenter presenter, StringMessages stringConstants, CellTableWithCheckboxResources tableResources) {
        super(presenter, true, stringConstants);
        this.errorReporter = presenter.getErrorReporter();
        VerticalPanel mainPanel = new VerticalPanel();
        this.setWidget((Widget)mainPanel);
        mainPanel.setWidth("100%");
        CaptionPanel captionPanelConnections = new CaptionPanel(stringConstants.connections());
        mainPanel.add((Widget)captionPanelConnections);
        VerticalPanel verticalPanel = new VerticalPanel();
        captionPanelConnections.setContentWidget((Widget)verticalPanel);
        captionPanelConnections.setStyleName("bold");
        this.connectionsTable = new SwissTimingConnectionTableWrapper(presenter.getUserService(), this.sailingServiceWrite, stringConstants, this.errorReporter, true, tableResources, () -> {});
        this.connectionsTable.refreshSwissTimingConnectionList();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(presenter.getUserService(), SecuredDomainType.TRACKED_RACE);
        verticalPanel.add((Widget)buttonPanel);
        verticalPanel.add((IsWidget)this.connectionsTable);
        buttonPanel.addUnsecuredAction(this.stringMessages.refresh(), () -> this.connectionsTable.refreshSwissTimingConnectionList());
        buttonPanel.addCreateAction(this.stringMessages.addSwissTimingConnection(), () -> new SwissTimingConnectionDialog((DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */, presenter.getUserService(), this.errorReporter).show());
        buttonPanel.addRemoveAction(this.stringMessages.remove(), (SetSelectionModel)this.connectionsTable.getSelectionModel(), false, () -> this.sailingServiceWrite.deleteSwissTimingConfigurations((Collection)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
        Button listRacesButton = buttonPanel.addUnsecuredAction(this.stringMessages.listRaces(), () -> this.fillRaces(this.sailingServiceWrite));
        listRacesButton.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> listRacesButton.setEnabled(((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1));
        HorizontalPanel racesSplitPanel = new HorizontalPanel();
        mainPanel.add((Widget)racesSplitPanel);
        CaptionPanel trackableRacesCaptionPanel = new CaptionPanel(stringConstants.trackableRaces());
        racesSplitPanel.add((Widget)trackableRacesCaptionPanel);
        trackableRacesCaptionPanel.setWidth("50%");
        CaptionPanel trackedRacesCaptionPanel = new CaptionPanel(stringConstants.trackedRaces());
        racesSplitPanel.add((Widget)trackedRacesCaptionPanel);
        trackedRacesCaptionPanel.setWidth("50%");
        VerticalPanel trackableRacesPanel = new VerticalPanel();
        trackableRacesCaptionPanel.setContentWidget((Widget)trackableRacesPanel);
        trackableRacesCaptionPanel.setStyleName("bold");
        VerticalPanel trackedRacesPanel = new VerticalPanel();
        trackedRacesPanel.setWidth("100%");
        trackedRacesCaptionPanel.setContentWidget((Widget)trackedRacesPanel);
        trackedRacesCaptionPanel.setStyleName("bold");
        HorizontalPanel regattaPanel = new HorizontalPanel();
        regattaPanel.setSpacing(5);
        Label regattaForTrackingLabel = new Label(this.stringMessages.regattaUsedForTheTrackedRace());
        regattaForTrackingLabel.setWordWrap(false);
        regattaPanel.add((Widget)regattaForTrackingLabel);
        regattaPanel.add((Widget)this.getAvailableRegattasListBox());
        trackableRacesPanel.add((Widget)regattaPanel);
        Label lblTrackSettings = new Label(stringConstants.trackSettings());
        trackableRacesPanel.add((Widget)lblTrackSettings);
        CheckBox trackWindCheckbox = new CheckBox(stringConstants.trackWind());
        trackWindCheckbox.setWordWrap(false);
        trackWindCheckbox.setValue(Boolean.valueOf(true));
        trackableRacesPanel.add((Widget)trackWindCheckbox);
        CheckBox declinationCheckbox = new CheckBox(stringConstants.declinationCheckbox());
        declinationCheckbox.setWordWrap(false);
        declinationCheckbox.setValue(Boolean.valueOf(true));
        trackableRacesPanel.add((Widget)declinationCheckbox);
        CheckBox simulateWithStartTimeNow = new CheckBox(this.stringMessages.simulateAsLiveRace());
        simulateWithStartTimeNow.setWordWrap(false);
        simulateWithStartTimeNow.setValue(Boolean.valueOf(false));
        trackableRacesPanel.add((Widget)simulateWithStartTimeNow);
        CheckBox useInternalMarkPassingAlgorithmCheckbox = new CheckBox(this.stringMessages.useInternalAlgorithm());
        useInternalMarkPassingAlgorithmCheckbox.setWordWrap(false);
        useInternalMarkPassingAlgorithmCheckbox.setValue(Boolean.FALSE);
        trackableRacesPanel.add((Widget)useInternalMarkPassingAlgorithmCheckbox);
        HorizontalPanel filterPanel = new HorizontalPanel();
        filterPanel.setSpacing(5);
        trackableRacesPanel.add((Widget)filterPanel);
        Label lblFilterEvents = new Label(String.valueOf(stringConstants.filterRaces()) + ":");
        filterPanel.add((Widget)lblFilterEvents);
        filterPanel.setCellVerticalAlignment((Widget)lblFilterEvents, HasVerticalAlignment.ALIGN_MIDDLE);
        this.raceTable = new FlushableCellTable(10000, (CellTable.Resources)tableRes);
        this.raceTable.setWidth("300px");
        this.raceList = new ListDataProvider();
        this.filterablePanelEvents = new /* Unavailable Anonymous Inner Class!! */;
        5 entityIdentityComparator = new /* Unavailable Anonymous Inner Class!! */;
        6 raceNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        7 regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        SelectionCheckboxColumn selectionColumn = new SelectionCheckboxColumn(tableRes.cellTableStyle().cellTableCheckboxSelected(), tableRes.cellTableStyle().cellTableCheckboxDeselected(), tableRes.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)entityIdentityComparator, this.raceList, (Flushable)this.raceTable);
        8 seriesNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        9 raceIdColumn = new /* Unavailable Anonymous Inner Class!! */;
        10 boatClassColumn = new /* Unavailable Anonymous Inner Class!! */;
        11 genderColumn = new /* Unavailable Anonymous Inner Class!! */;
        12 raceStatusColumn = new /* Unavailable Anonymous Inner Class!! */;
        13 raceStartTimeColumn = new /* Unavailable Anonymous Inner Class!! */;
        raceNameColumn.setSortable(true);
        raceStartTimeColumn.setSortable(true);
        boatClassColumn.setSortable(true);
        raceIdColumn.setSortable(true);
        genderColumn.setSortable(true);
        raceStatusColumn.setSortable(true);
        regattaNameColumn.setSortable(true);
        seriesNameColumn.setSortable(true);
        this.raceTable.addColumn((Column)selectionColumn, selectionColumn.getHeader());
        this.raceTable.addColumn((Column)regattaNameColumn, stringConstants.regatta());
        this.raceTable.addColumn((Column)seriesNameColumn, stringConstants.series());
        this.raceTable.addColumn((Column)raceNameColumn, stringConstants.name());
        this.raceTable.addColumn((Column)raceStatusColumn, stringConstants.status());
        this.raceTable.addColumn((Column)boatClassColumn, stringConstants.boatClass());
        this.raceTable.addColumn((Column)genderColumn, stringConstants.gender());
        this.raceTable.addColumn((Column)raceStartTimeColumn, stringConstants.startTime());
        this.raceTable.setSelectionModel((SelectionModel)selectionColumn.getSelectionModel(), selectionColumn.getSelectionManager());
        trackableRacesPanel.add((Widget)this.raceTable);
        this.raceList.addDataDisplay((HasData)this.raceTable);
        ColumnSortEvent.ListHandler columnSortHandler = this.getRaceTableColumnSortHandler(this.raceList.getList(), (Column)regattaNameColumn, (Column)seriesNameColumn, (Column)raceNameColumn, (Column)raceStartTimeColumn, (Column)raceIdColumn, (Column)boatClassColumn, (Column)genderColumn, (Column)raceStatusColumn);
        this.raceTable.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        trackedRacesPanel.add((Widget)this.trackedRacesListComposite);
        filterPanel.add((Widget)this.filterablePanelEvents);
        HorizontalPanel racesButtonPanel = new HorizontalPanel();
        trackableRacesPanel.add((Widget)racesButtonPanel);
        Button btnTrack = new Button(stringConstants.startTracking());
        racesButtonPanel.add((Widget)btnTrack);
        racesButtonPanel.setSpacing(10);
        btnTrack.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        btnTrack.setEnabled(false);
        ((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).addSelectionChangeHandler(e -> btnTrack.setEnabled(((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().size() == 1));
    }

    private ColumnSortEvent.ListHandler<SwissTimingRaceRecordDTO> getRaceTableColumnSortHandler(List<SwissTimingRaceRecordDTO> raceRecords, Column<SwissTimingRaceRecordDTO, ?> regattaNameColumn, Column<SwissTimingRaceRecordDTO, ?> seriesNameColumn, Column<SwissTimingRaceRecordDTO, ?> nameColumn, Column<SwissTimingRaceRecordDTO, ?> trackingStartColumn, Column<SwissTimingRaceRecordDTO, ?> raceIdColumn, Column<SwissTimingRaceRecordDTO, ?> boatClassColumn, Column<SwissTimingRaceRecordDTO, ?> genderColumn, Column<SwissTimingRaceRecordDTO, ?> statusColumn) {
        ColumnSortEvent.ListHandler result = new ColumnSortEvent.ListHandler(raceRecords);
        result.setComparator(regattaNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(seriesNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(trackingStartColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(raceIdColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(boatClassColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(genderColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        result.setComparator(statusColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void fillRaces(SailingServiceWriteAsync sailingServiceWrite) {
        SwissTimingConfigurationWithSecurityDTO selectedObject = (SwissTimingConfigurationWithSecurityDTO)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().iterator().next();
        sailingServiceWrite.getRacesOfSwissTimingEvent(selectedObject.getJsonUrl(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void trackSelectedRaces(boolean trackWind, boolean correctWindByDeclination, boolean useInternalMarkPassingAlgorithm) {
        SwissTimingConfigurationWithSecurityDTO selectedObject = (SwissTimingConfigurationWithSecurityDTO)((RefreshableMultiSelectionModel)this.connectionsTable.getSelectionModel()).getSelectedSet().iterator().next();
        String hostname = selectedObject.getHostname();
        Integer port = selectedObject.getPort();
        String updateURL = selectedObject.getUpdateURL();
        String updateUsername = selectedObject.getUpdateUsername();
        String updatePassword = selectedObject.getUpdatePassword();
        ArrayList<SwissTimingRaceRecordDTO> selectedRaces = new ArrayList<SwissTimingRaceRecordDTO>();
        for (SwissTimingRaceRecordDTO race : this.raceList.getList()) {
            if (!this.raceTable.getSelectionModel().isSelected((Object)race)) continue;
            selectedRaces.add(race);
        }
        RegattaDTO selectedRegatta = this.getSelectedRegatta();
        RegattaName regattaIdentifier = null;
        if (selectedRegatta != null) {
            regattaIdentifier = new RegattaName(selectedRegatta.getName());
        }
        if (this.checkBoatClassOK(selectedRegatta, selectedRaces)) {
            this.sailingServiceWrite.trackWithSwissTiming((RegattaIdentifier)regattaIdentifier, selectedRaces, hostname, port == null ? 0 : port, trackWind, correctWindByDeclination, useInternalMarkPassingAlgorithm, updateURL, updateUsername, updatePassword, selectedObject.getName(), selectedObject.getJsonUrl(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public AbstractFilterablePanel<SwissTimingConfigurationWithSecurityDTO> getFilterablePanel() {
        return this.connectionsTable.getFilterField();
    }

    static /* synthetic */ ErrorReporter access$0(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.errorReporter;
    }

    static /* synthetic */ SwissTimingConnectionTableWrapper access$1(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.connectionsTable;
    }

    static /* synthetic */ SailingServiceWriteAsync access$2(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.sailingServiceWrite;
    }

    static /* synthetic */ DateTimeFormatRenderer access$3(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.dateFormatter;
    }

    static /* synthetic */ FlushableCellTable access$4(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.raceTable;
    }

    static /* synthetic */ DateTimeFormatRenderer access$5(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.timeFormatter;
    }

    static /* synthetic */ void access$6(SwissTimingEventManagementPanel swissTimingEventManagementPanel, boolean bl, boolean bl2, boolean bl3) {
        swissTimingEventManagementPanel.trackSelectedRaces(bl, bl2, bl3);
    }

    static /* synthetic */ List access$7(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.availableSwissTimingRaces;
    }

    static /* synthetic */ ListDataProvider access$8(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.raceList;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$9(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.filterablePanelEvents;
    }

    static /* synthetic */ AdminConsoleView.Presenter access$10(SwissTimingEventManagementPanel swissTimingEventManagementPanel) {
        return swissTimingEventManagementPanel.presenter;
    }
}

