/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceColumnInSeriesDTO;
import com.sap.sailing.gwt.ui.adminconsole.DiscardThresholdBoxes;
import com.sap.sailing.gwt.ui.adminconsole.SeriesDescriptor;
import com.sap.sailing.gwt.ui.adminconsole.SeriesEditDialog;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import com.sap.sse.gwt.client.controls.listedit.StringListEditorComposite;
import com.sap.sse.gwt.client.controls.listedit.StringListInlineEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.List;

public class SeriesEditDialog
extends DataEntryDialog<SeriesDescriptor> {
    private TextBox seriesNameTextBox;
    private CheckBox isMedalCheckbox;
    private CheckBox fleetsCanRunInParallelCheckbox;
    private CheckBox startWithZeroScoreCheckbox;
    private CheckBox hasSplitFleetContiguousScoringCheckbox;
    private CheckBox hasCrossFleetMergedRankingCheckbox;
    private CheckBox firstColumnIsNonDiscardableCarryForwardCheckbox;
    private CheckBox oneAlwaysStaysOneCheckbox;
    private IntegerBox maximumNumberOfDiscardsBox;
    private CheckBox useSeriesResultDiscardingThresholdsCheckbox;
    private final StringMessages stringMessages;
    private VerticalPanel additionalWidgetPanel;
    private final SeriesDTO selectedSeries;
    private final RegattaDTO regatta;
    private final DiscardThresholdBoxes discardThresholdBoxes;
    private StringListEditorComposite raceNamesEditor;

    public SeriesEditDialog(RegattaDTO regatta, SeriesDTO selectedSeries, StringMessages stringMessages, DataEntryDialog.DialogCallback<SeriesDescriptor> callback) {
        super(stringMessages.actionEditSeries(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new RaceDialogValidator(regatta, stringMessages), callback);
        this.regatta = regatta;
        this.selectedSeries = selectedSeries;
        this.stringMessages = stringMessages;
        this.discardThresholdBoxes = new DiscardThresholdBoxes((DataEntryDialog)this, selectedSeries.getDiscardThresholds(), stringMessages);
    }

    protected SeriesDescriptor getResult() {
        SeriesDTO selectedSeries = this.getSelectedSeries();
        ArrayList<RaceColumnDTO> races = new ArrayList<RaceColumnDTO>();
        for (String name : this.raceNamesEditor.getValue()) {
            RaceColumnDTO raceColumnDTO = this.findRaceColumnInSeriesByName(selectedSeries, name);
            if (raceColumnDTO == null) {
                raceColumnDTO = new RaceColumnInSeriesDTO(name, selectedSeries.getName(), this.regatta.getName(), selectedSeries.isOneAlwaysStaysOne());
            }
            races.add(raceColumnDTO);
        }
        return new SeriesDescriptor(selectedSeries, this.seriesNameTextBox.getValue(), races, this.isMedalCheckbox.getValue().booleanValue(), this.fleetsCanRunInParallelCheckbox.getValue().booleanValue(), this.useSeriesResultDiscardingThresholdsCheckbox.getValue() != false ? this.discardThresholdBoxes.getDiscardThresholds() : null, this.startWithZeroScoreCheckbox.getValue().booleanValue(), this.firstColumnIsNonDiscardableCarryForwardCheckbox.getValue().booleanValue(), this.hasSplitFleetContiguousScoringCheckbox.getValue().booleanValue(), this.hasCrossFleetMergedRankingCheckbox.getValue().booleanValue(), (Integer)this.maximumNumberOfDiscardsBox.getValue(), this.oneAlwaysStaysOneCheckbox.getValue().booleanValue());
    }

    private RaceColumnDTO findRaceColumnInSeriesByName(SeriesDTO series, String raceColumnName) {
        RaceColumnDTO result = null;
        if (series != null) {
            for (RaceColumnDTO raceColumn : series.getRaceColumns()) {
                if (!raceColumn.getName().equals(raceColumnName)) continue;
                result = raceColumn;
                break;
            }
        }
        return result;
    }

    protected Widget getAdditionalWidget() {
        this.additionalWidgetPanel = new VerticalPanel();
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            this.additionalWidgetPanel.add(additionalWidget);
        }
        HorizontalPanel seriesPanel = new HorizontalPanel();
        seriesPanel.setSpacing(3);
        String seriesName = this.getSelectedSeries().getName();
        seriesPanel.add((Widget)new Label(String.valueOf(this.stringMessages.series()) + ": " + seriesName));
        this.additionalWidgetPanel.add((Widget)seriesPanel);
        this.seriesNameTextBox = this.createTextBox(seriesName);
        this.additionalWidgetPanel.add((Widget)this.seriesNameTextBox);
        this.isMedalCheckbox = this.createCheckbox(this.stringMessages.medalSeries());
        this.isMedalCheckbox.ensureDebugId("MedalSeriesCheckbox");
        this.isMedalCheckbox.setValue(Boolean.valueOf(this.selectedSeries.isMedal()));
        this.additionalWidgetPanel.add((Widget)this.isMedalCheckbox);
        this.fleetsCanRunInParallelCheckbox = this.createCheckbox(this.stringMessages.canFleetsRunInParallel());
        this.fleetsCanRunInParallelCheckbox.ensureDebugId("FleetsCanRaceInParallelSeriesCheckbox");
        this.fleetsCanRunInParallelCheckbox.setValue(Boolean.valueOf(this.selectedSeries.isFleetsCanRunInParallel()));
        this.additionalWidgetPanel.add((Widget)this.fleetsCanRunInParallelCheckbox);
        this.startWithZeroScoreCheckbox = this.createCheckbox(this.stringMessages.startsWithZeroScore());
        this.startWithZeroScoreCheckbox.ensureDebugId("StartsWithZeroScoreCheckbox");
        this.startWithZeroScoreCheckbox.setValue(this.selectedSeries.isStartsWithZeroScore());
        this.additionalWidgetPanel.add((Widget)this.startWithZeroScoreCheckbox);
        this.hasSplitFleetContiguousScoringCheckbox = this.createCheckbox(this.stringMessages.hasSplitFleetContiguousScoring());
        this.hasSplitFleetContiguousScoringCheckbox.ensureDebugId("HasSplitFleetContiguousScoringCheckbox");
        this.hasSplitFleetContiguousScoringCheckbox.setValue(Boolean.valueOf(this.selectedSeries.hasSplitFleetContiguousScoring()));
        this.additionalWidgetPanel.add((Widget)this.hasSplitFleetContiguousScoringCheckbox);
        this.hasCrossFleetMergedRankingCheckbox = this.createCheckbox(this.stringMessages.hasCrossFleetMergedRanking());
        this.hasCrossFleetMergedRankingCheckbox.ensureDebugId("HasCrossFleetMergedRankingCheckbox");
        this.hasCrossFleetMergedRankingCheckbox.setValue(this.selectedSeries.hasCrossFleetMergedRanking());
        this.additionalWidgetPanel.add((Widget)this.hasCrossFleetMergedRankingCheckbox);
        this.firstColumnIsNonDiscardableCarryForwardCheckbox = this.createCheckbox(this.stringMessages.firstRaceIsNonDiscardableCarryForward());
        this.firstColumnIsNonDiscardableCarryForwardCheckbox.ensureDebugId("StartsWithNonDiscardableCarryForwardCheckbox");
        this.firstColumnIsNonDiscardableCarryForwardCheckbox.setValue(Boolean.valueOf(this.selectedSeries.isFirstColumnIsNonDiscardableCarryForward()));
        this.additionalWidgetPanel.add((Widget)this.firstColumnIsNonDiscardableCarryForwardCheckbox);
        this.oneAlwaysStaysOneCheckbox = this.createCheckbox(this.stringMessages.oneAlwaysStaysOne());
        this.oneAlwaysStaysOneCheckbox.ensureDebugId("OneAlwaysStaysOneCheckbox");
        this.oneAlwaysStaysOneCheckbox.setValue(Boolean.valueOf(this.selectedSeries.isOneAlwaysStaysOne()));
        this.additionalWidgetPanel.add((Widget)this.oneAlwaysStaysOneCheckbox);
        HorizontalPanel maximumNumberOfDiscardsPanel = new HorizontalPanel();
        maximumNumberOfDiscardsPanel.add((Widget)new Label(this.stringMessages.maximumNumberOfDiscards()));
        this.maximumNumberOfDiscardsBox = this.createIntegerBox(this.selectedSeries.getMaximumNumberOfDiscards(), 3);
        maximumNumberOfDiscardsPanel.add((Widget)this.maximumNumberOfDiscardsBox);
        this.additionalWidgetPanel.add((Widget)maximumNumberOfDiscardsPanel);
        this.useSeriesResultDiscardingThresholdsCheckbox = this.createCheckbox(this.stringMessages.seriesDefinesResultDiscardingRule());
        this.useSeriesResultDiscardingThresholdsCheckbox.ensureDebugId("DefinesResultDiscardingRulesCheckbox");
        this.useSeriesResultDiscardingThresholdsCheckbox.setValue(Boolean.valueOf(this.selectedSeries.getDiscardThresholds() != null));
        this.useSeriesResultDiscardingThresholdsCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.additionalWidgetPanel.add((Widget)this.useSeriesResultDiscardingThresholdsCheckbox);
        Widget discardThresholdBoxesWidget = this.discardThresholdBoxes.getWidget();
        discardThresholdBoxesWidget.ensureDebugId("");
        discardThresholdBoxesWidget.setVisible(this.useSeriesResultDiscardingThresholdsCheckbox.getValue().booleanValue());
        this.additionalWidgetPanel.add(discardThresholdBoxesWidget);
        this.raceNamesEditor = new StringListInlineEditorComposite((Iterable)this.getExistingRacesOfSeries(), (ListEditorUiStrategy)new RaceNamesEditorUi(this, this.regatta, this.stringMessages, IconResources.INSTANCE.removeIcon(), seriesName));
        this.raceNamesEditor.ensureDebugId("RaceNamesStringListEditorComposite");
        this.raceNamesEditor.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        TabPanel tabPanel = new TabPanel();
        tabPanel.setWidth("100%");
        tabPanel.add((Widget)this.raceNamesEditor, this.stringMessages.races());
        tabPanel.selectTab(0);
        this.additionalWidgetPanel.add((Widget)tabPanel);
        return this.additionalWidgetPanel;
    }

    private List<String> getExistingRacesOfSeries() {
        ArrayList<String> names = new ArrayList<String>();
        SeriesDTO selectedSeries = this.getSelectedSeries();
        if (selectedSeries != null && !selectedSeries.getRaceColumns().isEmpty()) {
            for (RaceColumnDTO raceColumn : selectedSeries.getRaceColumns()) {
                names.add(raceColumn.getName());
            }
        }
        return names;
    }

    private SeriesDTO getSelectedSeries() {
        return this.selectedSeries;
    }

    static /* synthetic */ SeriesDTO access$1(SeriesEditDialog seriesEditDialog) {
        return seriesEditDialog.getSelectedSeries();
    }

    static /* synthetic */ void access$2(SeriesEditDialog seriesEditDialog) {
        seriesEditDialog.validateAndUpdate();
    }

    static /* synthetic */ DiscardThresholdBoxes access$3(SeriesEditDialog seriesEditDialog) {
        return seriesEditDialog.discardThresholdBoxes;
    }
}

