/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardDialog;
import com.sap.sailing.gwt.ui.adminconsole.CompetitorRegistrationsPanel;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptor;
import com.sap.sailing.gwt.ui.adminconsole.LeaderboardDescriptorWithEliminations;
import com.sap.sailing.gwt.ui.adminconsole.RegattaLeaderboardWithEliminationsDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class RegattaLeaderboardWithEliminationsDialog
extends AbstractLeaderboardDialog<LeaderboardDescriptorWithEliminations> {
    protected final ListBox regattaLeaderboardsListBox;
    protected final Collection<RegattaDTO> existingRegattas;
    protected final FlowPanel competitorEliminationPanelHolder;
    protected final SailingServiceWriteAsync sailingServiceWrite;
    protected final UserService userService;
    private final Collection<StrippedLeaderboardDTO> existingLeaderboards;
    protected final ErrorReporter errorReporter;
    protected final StringMessages stringMessages;
    protected Collection<CompetitorDTO> eliminatedCompetitors;

    public RegattaLeaderboardWithEliminationsDialog(SailingServiceWriteAsync sailingServiceWrite, UserService userService, String title, LeaderboardDescriptorWithEliminations leaderboardDTO, Collection<RegattaDTO> existingRegattas, Collection<StrippedLeaderboardDTO> existingLeaderboards, StringMessages stringMessages, ErrorReporter errorReporter, LeaderboardParameterValidator validator, DataEntryDialog.DialogCallback<LeaderboardDescriptorWithEliminations> callback) {
        super(title, (LeaderboardDescriptor)leaderboardDTO, stringMessages, (DataEntryDialog.Validator)validator, callback);
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.existingRegattas = existingRegattas;
        this.existingLeaderboards = existingLeaderboards;
        this.displayNameTextBox = this.createTextBox(null);
        this.displayNameTextBox.ensureDebugId("DisplayNameTextBox");
        this.displayNameTextBox.setVisibleLength(50);
        this.competitorEliminationPanelHolder = new FlowPanel();
        this.regattaLeaderboardsListBox = this.createSortedRegattaLeaderboardsListBox(existingLeaderboards, null);
        this.regattaLeaderboardsListBox.ensureDebugId("RegattaListBox");
        this.regattaLeaderboardsListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createAndFillCompetitorEliminationPanel() {
        CompetitorRegistrationsPanel[] competitorEliminationPanel;
        this.competitorEliminationPanelHolder.clear();
        StrippedLeaderboardDTO selectedRegattaLeaderboard = this.getSelectedLeaderboard();
        competitorEliminationPanel = new CompetitorRegistrationsPanel[]{new CompetitorRegistrationsPanel(this.sailingServiceWrite, this.userService, null, null, this.stringMessages, this.errorReporter, true, this.regattaLeaderboardsListBox.getValue(this.regattaLeaderboardsListBox.getSelectedIndex()), selectedRegattaLeaderboard.canBoatsOfCompetitorsChangePerRace, selectedRegattaLeaderboard.boatClassName, () -> {
            this.eliminatedCompetitors = competitorEliminationPanel[0].getResult();
            Collection collection = this.eliminatedCompetitors;
        }, this.getEliminatedCompetitorsRetriever(), true, new Widget[]{new Label(this.stringMessages.selectCompetitorsToEliminate())})};
        this.competitorEliminationPanelHolder.add((Widget)competitorEliminationPanel[0]);
    }

    protected abstract Consumer<Util.Pair<CompetitorRegistrationsPanel, AsyncCallback<Collection<CompetitorDTO>>>> getEliminatedCompetitorsRetriever();

    protected StrippedLeaderboardDTO getSelectedLeaderboard() {
        String selectedRegattaLeaderboardName = this.regattaLeaderboardsListBox.getSelectedValue();
        for (StrippedLeaderboardDTO l : this.existingLeaderboards) {
            if (!l.getName().equals(selectedRegattaLeaderboardName)) continue;
            return l;
        }
        return null;
    }

    protected LeaderboardDescriptorWithEliminations getResult() {
        LeaderboardDescriptor leaderboard = super.getResult();
        leaderboard.setRegattaName(this.getNameOfSelectedRegattaLeaderboard());
        LeaderboardDescriptorWithEliminations result = new LeaderboardDescriptorWithEliminations(leaderboard, (Set)(this.eliminatedCompetitors == null ? null : new HashSet(this.eliminatedCompetitors)));
        return result;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel mainPanel = new VerticalPanel();
        Grid formGrid = new Grid(4, 3);
        formGrid.setCellSpacing(3);
        formGrid.setWidget(0, 0, (Widget)this.createLabel(this.stringMessages.regattaLeaderboards()));
        formGrid.setWidget(0, 1, (Widget)this.regattaLeaderboardsListBox);
        formGrid.setWidget(1, 0, (Widget)this.createLabel(this.stringMessages.name()));
        formGrid.setWidget(1, 1, (Widget)this.nameTextBox);
        formGrid.setWidget(2, 0, (Widget)this.createLabel(this.stringMessages.displayName()));
        formGrid.setWidget(2, 1, (Widget)this.displayNameTextBox);
        formGrid.setWidget(3, 1, (Widget)this.competitorEliminationPanelHolder);
        mainPanel.add((Widget)formGrid);
        return mainPanel;
    }

    public String getNameOfSelectedRegattaLeaderboard() {
        int selIndex = this.regattaLeaderboardsListBox.getSelectedIndex();
        String result = selIndex > 0 ? this.regattaLeaderboardsListBox.getValue(selIndex) : null;
        return result;
    }

    static /* synthetic */ void access$1(RegattaLeaderboardWithEliminationsDialog regattaLeaderboardWithEliminationsDialog) {
        regattaLeaderboardWithEliminationsDialog.validateAndUpdate();
    }
}

