/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.adminconsole.AbstractLeaderboardConfigPanel;
import com.sap.sailing.gwt.ui.adminconsole.NameBasedStrippedLeaderboardDTOEntityIdentityComparator;
import com.sap.sailing.gwt.ui.adminconsole.RaceSlotSelectionPanel;
import com.sap.sailing.gwt.ui.adminconsole.RaceTableWrapper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Comparator;

public class RaceSlotSelectionPanel
extends HorizontalPanel {
    private final FlushableCellTable<StrippedLeaderboardDTO> leaderboardTable;
    private final RaceTableWrapper<RefreshableSelectionModel<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality>> raceColumnTable;
    private final ListDataProvider<StrippedLeaderboardDTO> filteredLeaderboardList;
    private final RefreshableSingleSelectionModel<StrippedLeaderboardDTO> leaderboardSelectionModel;

    public RaceSlotSelectionPanel(SailingServiceWriteAsync sailingServiceWrite, UserService userService, StringMessages stringMessages, ErrorReporter errorReporter, boolean multiSelection, Iterable<StrippedLeaderboardDTO> availableLeaderboards, AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality preselected) {
        CellTable.Resources tableRes = (CellTable.Resources)GWT.create(AdminConsoleTableResources.class);
        this.leaderboardTable = new FlushableCellTable(10000, tableRes);
        this.filteredLeaderboardList = new ListDataProvider();
        this.leaderboardSelectionModel = new RefreshableSingleSelectionModel((EntityIdentityComparator)new NameBasedStrippedLeaderboardDTOEntityIdentityComparator(), this.filteredLeaderboardList);
        this.leaderboardTable.setSelectionModel((SelectionModel)this.leaderboardSelectionModel);
        Label leaderboardFilterLabel = new Label(stringMessages.filterByLeaderboard());
        1 filterLeaderboardPanel = new /* Unavailable Anonymous Inner Class!! */;
        ColumnSortEvent.ListHandler leaderboardColumnListHandler = new ColumnSortEvent.ListHandler(this.filteredLeaderboardList.getList());
        2 leaderboardNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardNameColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        4 leaderboardDisplayNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        leaderboardDisplayNameColumn.setSortable(true);
        leaderboardColumnListHandler.setComparator((Column)leaderboardDisplayNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.leaderboardTable.addColumnSortHandler((ColumnSortEvent.Handler)leaderboardColumnListHandler);
        this.leaderboardTable.addColumn((Column)leaderboardNameColumn, stringMessages.name());
        this.leaderboardTable.addColumn((Column)leaderboardDisplayNameColumn, stringMessages.displayName());
        filterLeaderboardPanel.getTextBox().ensureDebugId("LeaderboardsFilterInRaceSlotSelectionPanelTextBox");
        filterLeaderboardPanel.setUpdatePermissionFilterForCheckbox(leaderboard -> userService.hasPermission((SecuredDTO)leaderboard, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        filterLeaderboardPanel.filter();
        this.leaderboardTable.ensureDebugId("AvailableLeaderboardsInRaceSlotSelectionPanelTable");
        this.filteredLeaderboardList.addDataDisplay((HasData)this.leaderboardTable);
        this.leaderboardSelectionModel.addSelectionChangeHandler(e -> this.updateRaceColumnTableAfterLeaderboardSelectionChange());
        this.raceColumnTable = new RaceTableWrapper(sailingServiceWrite, stringMessages, errorReporter, multiSelection);
        this.raceColumnTable.asWidget().ensureDebugId("RaceColumnInRaceSlotSelectionPanelTable");
        Grid tableGrid = new Grid(2, 2);
        tableGrid.setWidget(0, 0, (Widget)filterLeaderboardPanel);
        tableGrid.setWidget(1, 0, (Widget)this.leaderboardTable);
        tableGrid.setWidget(1, 1, (Widget)this.raceColumnTable.getTable());
        this.add((Widget)tableGrid);
        if (preselected != null) {
            this.leaderboardTable.getSelectionModel().setSelected(preselected.getC(), true);
            Scheduler.get().scheduleDeferred(() -> {
                this.raceColumnTable.setSelectedLeaderboardName(((StrippedLeaderboardDTO)preselected.getC()).getName());
                this.raceColumnTable.getSelectionModel().setSelected((Object)preselected, true);
            });
        }
    }

    private void updateRaceColumnTableAfterLeaderboardSelectionChange() {
        StrippedLeaderboardDTO selectedLeaderboard = this.getSelectedLeaderboard();
        if (selectedLeaderboard != null) {
            ArrayList<Util.Triple> raceColumnsAndFleets = new ArrayList<Util.Triple>();
            for (RaceColumnDTO raceColumn : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : raceColumn.getFleets()) {
                    raceColumnsAndFleets.add(new Util.Triple((Object)selectedLeaderboard.getName(), (Object)raceColumn.getName(), (Object)fleet.getName()));
                }
            }
            this.raceColumnTable.getDataProvider().getList().clear();
            for (RaceColumnDTO raceColumn : selectedLeaderboard.getRaceList()) {
                for (FleetDTO fleet : raceColumn.getFleets()) {
                    AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality raceColumnDTOAndFleet2 = new AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality(raceColumn, fleet, this.getSelectedLeaderboard());
                    this.raceColumnTable.getDataProvider().getList().add(raceColumnDTOAndFleet2);
                }
            }
            this.raceColumnTable.getTable().setVisible(true);
        } else {
            this.raceColumnTable.getTable().setVisible(false);
        }
    }

    private StrippedLeaderboardDTO getSelectedLeaderboard() {
        return (StrippedLeaderboardDTO)this.leaderboardSelectionModel.getSelectedObject();
    }

    public RefreshableSelectionModel<AbstractLeaderboardConfigPanel.RaceColumnDTOAndFleetDTOWithNameBasedEquality> getSelectionModel() {
        return this.raceColumnTable.getSelectionModel();
    }

    static /* synthetic */ FlushableCellTable access$0(RaceSlotSelectionPanel raceSlotSelectionPanel) {
        return raceSlotSelectionPanel.leaderboardTable;
    }
}

