/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import java.util.Map;
import java.util.function.Function;

public class ORCCertificateDisplayPanel
extends DockPanel {
    public ORCCertificateDisplayPanel(ORCCertificate certificate, StringMessages stringMessages) {
        VerticalPanel panel = new VerticalPanel();
        this.add((Widget)panel, DockPanel.CENTER);
        CaptionPanel headerCaptionPanel = new CaptionPanel();
        Grid headerData = new Grid(10, 2);
        headerCaptionPanel.add((Widget)headerData);
        panel.add((Widget)headerCaptionPanel);
        int row = 0;
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.certificateIssuingDate()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getIssueDate().toString()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.issuingCountry()));
        CountryCode issuingCountry = certificate.getIssuingCountry();
        headerData.setWidget(row++, 1, (Widget)new Label(issuingCountry == null ? stringMessages.empty() : String.valueOf(issuingCountry.getThreeLetterIOCCode()) + " (" + issuingCountry.getName() + ")"));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.orcFileId()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getFileId()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.orcCertificateReferenceNumber()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getReferenceNumber()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.boat()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getBoatName()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.sailID()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getSailNumber()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.boatClass()));
        headerData.setWidget(row++, 1, (Widget)new Label(certificate.getBoatClassName()));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.gph()));
        headerData.setWidget(row++, 1, (Widget)new Label(Util.padPositiveValue((double)certificate.getGPHInSecondsToTheMile(), (int)1, (int)1, (boolean)true)));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.cdl()));
        headerData.setWidget(row++, 1, (Widget)new Label(Util.padPositiveValue((double)certificate.getCDL(), (int)1, (int)3, (boolean)true)));
        headerData.setWidget(row, 0, (Widget)new Label(stringMessages.lengthOverAllInMeters()));
        headerData.setWidget(row++, 1, (Widget)new Label(Util.padPositiveValue((double)certificate.getLengthOverAll().getMeters(), (int)1, (int)3, (boolean)true)));
        CaptionPanel timeAllowancesCaptionPanel = new CaptionPanel(stringMessages.timeAllowances());
        panel.add((Widget)timeAllowancesCaptionPanel);
        Grid timeAllowancesData = new Grid(1 + certificate.getTrueWindAngles().length + 1 + 1 + 4 + 1 + 1, 1 + certificate.getTrueWindSpeeds().length);
        timeAllowancesCaptionPanel.add((Widget)timeAllowancesData);
        row = 0;
        this.fillLine(certificate, stringMessages.windSpeed(), row++, timeAllowancesData, tws -> String.valueOf(Util.padPositiveValue((double)tws.getKnots(), (int)1, (int)1, (boolean)true)) + stringMessages.knotsUnit());
        Map beatAllowances = certificate.getBeatAllowances();
        this.fillLine(certificate, stringMessages.beatVMG(), row++, timeAllowancesData, tws -> Util.padPositiveValue((double)((Duration)beatAllowances.get(tws)).asSeconds(), (int)1, (int)1, (boolean)true));
        Bearing[] bearingArray = certificate.getTrueWindAngles();
        int n = bearingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bearing twa = bearingArray[n2];
            Map allowances = certificate.getVelocityPredictionPerTrueWindSpeedAndAngle();
            this.fillLine(certificate, Util.padPositiveValue((double)twa.getDegrees(), (int)1, (int)1, (boolean)true), row++, timeAllowancesData, tws -> this.getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth((Speed)((Map)allowances.get(tws)).get(twa)));
            ++n2;
        }
        Map runAllowances = certificate.getRunAllowances();
        this.fillLine(certificate, stringMessages.runVMG(), row++, timeAllowancesData, tws -> Util.padPositiveValue((double)((Duration)runAllowances.get(tws)).asSeconds(), (int)1, (int)1, (boolean)true));
        Map windwardLeewardSpeedPrediction = certificate.getWindwardLeewardSpeedPrediction();
        this.fillLine(certificate, "Windward/Leeward", row++, timeAllowancesData, tws -> this.getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth((Speed)windwardLeewardSpeedPrediction.get(tws)));
        Map circularRandomSpeedPrediction = certificate.getCircularRandomSpeedPredictions();
        this.fillLine(certificate, "Circular Random", row++, timeAllowancesData, tws -> this.getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth((Speed)circularRandomSpeedPrediction.get(tws)));
        Map coastalLongDistanceSpeedPrediction = certificate.getLongDistanceSpeedPredictions();
        this.fillLine(certificate, "Coastal / Long Distance", row++, timeAllowancesData, tws -> this.getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth((Speed)coastalLongDistanceSpeedPrediction.get(tws)));
        Map nonSpinnakerSpeedPrediction = certificate.getNonSpinnakerSpeedPredictions();
        this.fillLine(certificate, "Non Spinnaker", row++, timeAllowancesData, tws -> this.getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth((Speed)nonSpinnakerSpeedPrediction.get(tws)));
        Map beatAngles = certificate.getBeatAngles();
        this.fillLine(certificate, stringMessages.beatAngles(), row++, timeAllowancesData, tws -> Util.padPositiveValue((double)((Bearing)beatAngles.get(tws)).getDegrees(), (int)1, (int)1, (boolean)true));
        Map runAngles = certificate.getRunAngles();
        this.fillLine(certificate, stringMessages.runAngles(), row++, timeAllowancesData, tws -> Util.padPositiveValue((double)((Bearing)runAngles.get(tws)).getDegrees(), (int)1, (int)1, (boolean)true));
        Anchor linkToCertificate = new Anchor(new SafeHtmlBuilder().appendEscaped(stringMessages.linkToOrcCertificate()).toSafeHtml(), "https://data.orc.org/public/WPub.dll/CC/" + certificate.getReferenceNumber(), "_blank");
        panel.add((Widget)linkToCertificate);
    }

    private String getVelocityPredictionAsSecondsToTheNauticalMileRoundedToOneTenth(Speed velocityPrediction) {
        return Util.padPositiveValue((double)ORCCertificate.NAUTICAL_MILE.atSpeed(velocityPrediction).asSeconds(), (int)1, (int)1, (boolean)true);
    }

    private void fillLine(ORCCertificate certificate, String lineLabel, int row, Grid grid, Function<Speed, String> twsToValueLabel) {
        int column = 0;
        grid.setWidget(row, column++, (Widget)new Label(lineLabel));
        Speed[] speedArray = certificate.getTrueWindSpeeds();
        int n = speedArray.length;
        int n2 = 0;
        while (n2 < n) {
            Speed trueWindSpeed = speedArray[n2];
            Label valueLabel = new Label(twsToValueLabel.apply(trueWindSpeed));
            valueLabel.setHorizontalAlignment(ALIGN_RIGHT);
            grid.setWidget(row, column++, (Widget)valueLabel);
            ++n2;
        }
    }
}

