/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.adminconsole.FileStorageServiceConnectionTestObservable;
import com.sap.sailing.gwt.ui.adminconsole.ImageDialog;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.adminconsole.URLFieldWithFileUpload;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.controls.listedit.ExpandedUiWithCheckboxes;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUiStrategy;
import com.sap.sse.gwt.client.controls.listedit.StringListInlineEditorComposite;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.ImageResizingTaskDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ImageDialog
extends DataEntryDialog<List<ImageResizingTaskDTO>>
implements FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver {
    private final SailingServiceAsync sailingService;
    protected final StringMessages stringMessages;
    protected final URLFieldWithFileUpload imageURLAndUploadComposite;
    protected final Date creationDate;
    protected Label createdAtLabel;
    protected TextBox titleTextBox;
    protected TextBox subtitleTextBox;
    protected TextBox copyrightTextBox;
    protected final VerticalPanel fileInfoVPanel;
    protected final StringListInlineEditorComposite tagsListEditor;
    protected Image image;
    private final ExpandedUiWithCheckboxes<String> expandedUi;
    private final BusyIndicator busyIndicator;
    private int busyCounter;
    private final HashMap<String, Util.Pair<Integer, Integer>> imageDimensionsMap;

    public ImageDialog(Date creationDate, SailingServiceAsync sailingService, StringMessages stringMessages, FileStorageServiceConnectionTestObservable storageServiceAvailable, DataEntryDialog.DialogCallback<List<ImageResizingTaskDTO>> callback) {
        this(creationDate, sailingService, stringMessages, storageServiceAvailable, new ImageParameterValidator(stringMessages, storageServiceAvailable), callback);
    }

    private ImageDialog(Date creationDate, SailingServiceAsync sailingService, StringMessages stringMessages, FileStorageServiceConnectionTestObservable storageServiceAvailable, ImageParameterValidator validator, DataEntryDialog.DialogCallback<List<ImageResizingTaskDTO>> callback) {
        super(stringMessages.image(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)validator, callback);
        this.stringMessages = stringMessages;
        this.sailingService = sailingService;
        this.creationDate = creationDate;
        this.fileInfoVPanel = new VerticalPanel();
        this.getDialogBox().getWidget().setWidth("730px");
        this.busyIndicator = new SimpleBusyIndicator();
        this.imageURLAndUploadComposite = new URLFieldWithFileUpload((com.sap.sse.gwt.adminconsole.StringMessages)stringMessages, true, true, true, "image/*");
        this.getCancelButton().addClickHandler(clickEvent -> this.imageURLAndUploadComposite.deleteCurrentFile());
        this.imageURLAndUploadComposite.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        storageServiceAvailable.registerObserver((FileStorageServiceConnectionTestObservable.FileStorageServiceConnectionTestObserver)this);
        this.expandedUi = new ExpandedUiWithCheckboxes((com.sap.sse.gwt.client.StringMessages)stringMessages, IconResources.INSTANCE.removeIcon(), MediaTagConstants.imageTagSuggestions, stringMessages.enterTagsForTheImage(), 30, stringMessages.allowResizing());
        this.expandedUi.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        validator.setCheckBoxes(this.expandedUi.getCheckBoxes());
        this.tagsListEditor = new StringListInlineEditorComposite(Collections.emptyList(), (ListEditorUiStrategy)this.expandedUi);
        this.tagsListEditor.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.imageDimensionsMap = new HashMap(4);
    }

    protected List<ImageResizingTaskDTO> getResult() {
        ArrayList<String> tags = new ArrayList<String>();
        for (String tag : this.tagsListEditor.getValue()) {
            tags.add(tag);
        }
        ArrayList<MediaTagConstants> notCheckedMediaTags = new ArrayList<MediaTagConstants>();
        int i = 0;
        while (i < tags.size()) {
            if (Arrays.asList(MediaTagConstants.values()).contains(MediaTagConstants.fromName((String)((String)tags.get(i)))) && !((CheckBox)this.expandedUi.getCheckBoxes().get(i)).getValue().booleanValue()) {
                notCheckedMediaTags.add(MediaTagConstants.fromName((String)((String)tags.get(i))));
            }
            ++i;
        }
        ArrayList<MediaTagConstants> mediaTags = new ArrayList<MediaTagConstants>();
        int i2 = 0;
        while (i2 < tags.size()) {
            if (Arrays.asList(MediaTagConstants.values()).contains(MediaTagConstants.fromName((String)((String)tags.get(i2)))) && ((CheckBox)this.expandedUi.getCheckBoxes().get(i2)).getValue().booleanValue()) {
                mediaTags.add(MediaTagConstants.fromName((String)((String)tags.get(i2))));
            }
            ++i2;
        }
        ArrayList<ImageResizingTaskDTO> results = new ArrayList<ImageResizingTaskDTO>(this.imageURLAndUploadComposite.getUris().size());
        List uris = this.imageURLAndUploadComposite.getUris();
        this.fileInfoVPanel.clear();
        int i3 = 0;
        while (i3 < uris.size()) {
            Label fileInfoText;
            String imageURL = (String)uris.get(i3);
            String fileName = ImageDialog.extractFileName((String)imageURL);
            ImageDTO image = new ImageDTO(imageURL, this.creationDate);
            image.setTitle(this.titleTextBox.getValue());
            image.setSubtitle(this.subtitleTextBox.getValue());
            image.setCopyright(this.copyrightTextBox.getValue());
            Util.Pair dims = (Util.Pair)this.imageDimensionsMap.get(imageURL);
            if (dims != null) {
                image.setSizeInPx((Integer)dims.getA(), (Integer)dims.getB());
                fileInfoText = new Label(String.valueOf(fileName) + " (" + dims.getA() + "x" + dims.getB() + ")");
            } else {
                fileInfoText = new Label(fileName);
            }
            image.setTags(tags);
            ArrayList<MediaTagConstants> resizeTags = new ArrayList<MediaTagConstants>();
            for (MediaTagConstants mediaTag : mediaTags) {
                if (!ImageDialog.imageNeedsResizeForTag((ImageDTO)image, (MediaTagConstants)mediaTag)) continue;
                resizeTags.add(mediaTag);
                fileInfoText.setText(String.valueOf(fileInfoText.getText()) + " - " + this.stringMessages.resize() + " (" + mediaTag.name() + ")");
            }
            for (MediaTagConstants mediaTag : notCheckedMediaTags) {
                if (!ImageDialog.imageNeedsResizeForTag((ImageDTO)image, (MediaTagConstants)mediaTag)) continue;
                fileInfoText.setText(String.valueOf(fileInfoText.getText()) + " - " + this.stringMessages.resize() + " (" + mediaTag.name() + ")");
                fileInfoText.setStyleName("errorLabel");
            }
            this.fileInfoVPanel.add((Widget)fileInfoText);
            results.add(new ImageResizingTaskDTO(image, resizeTags));
            ++i3;
        }
        return results;
    }

    private static String extractFileName(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private static boolean imageNeedsResizeForTag(ImageDTO image, MediaTagConstants mediaTag) {
        boolean heightExceeded;
        boolean widthExceeded = image != null && image.getWidthInPx() != null && image.getWidthInPx() > mediaTag.getMaxWidth();
        boolean bl = heightExceeded = image != null && image.getWidthInPx() != null && image.getHeightInPx() > mediaTag.getMaxHeight();
        return widthExceeded || heightExceeded;
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        Widget additionalWidget = super.getAdditionalWidget();
        if (additionalWidget != null) {
            panel.add(additionalWidget);
        }
        Grid grid = new Grid(10, 2);
        grid.setWidget(0, 0, (Widget)new Label(String.valueOf(this.stringMessages.createdAt()) + ":"));
        grid.setWidget(0, 1, (Widget)this.createdAtLabel);
        grid.setWidget(1, 0, (Widget)new HTML("&nbsp;"));
        grid.setWidget(1, 1, (Widget)this.busyIndicator);
        grid.setWidget(2, 0, (Widget)new Label(String.valueOf(this.stringMessages.imageURL()) + ":"));
        grid.setWidget(2, 1, (Widget)this.imageURLAndUploadComposite);
        grid.setWidget(3, 0, (Widget)new Label(String.valueOf(this.stringMessages.fileUpload()) + ":"));
        grid.setWidget(3, 1, (Widget)this.fileInfoVPanel);
        grid.setWidget(4, 0, (Widget)new HTML("&nbsp;"));
        grid.setWidget(5, 0, (Widget)new Label(String.valueOf(this.stringMessages.title()) + ":"));
        grid.setWidget(5, 1, (Widget)this.titleTextBox);
        grid.setWidget(6, 0, (Widget)new Label(String.valueOf(this.stringMessages.subtitle()) + ":"));
        grid.setWidget(6, 1, (Widget)this.subtitleTextBox);
        grid.setWidget(7, 0, (Widget)new Label(String.valueOf(this.stringMessages.copyright()) + ":"));
        grid.setWidget(7, 1, (Widget)this.copyrightTextBox);
        grid.setWidget(8, 0, (Widget)new HTML("&nbsp;"));
        grid.setWidget(9, 0, (Widget)new Label(String.valueOf(this.stringMessages.tags()) + ":"));
        grid.setWidget(9, 1, (Widget)this.tagsListEditor);
        panel.add((Widget)grid);
        return panel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.imageURLAndUploadComposite.getInitialFocusWidget();
    }

    public void onFileStorageServiceTestPassed() {
        this.imageURLAndUploadComposite.setUploadEnabled(true);
    }

    static /* synthetic */ String access$1(String string) {
        return ImageDialog.extractFileName((String)string);
    }

    static /* synthetic */ BusyIndicator access$2(ImageDialog imageDialog) {
        return imageDialog.busyIndicator;
    }

    static /* synthetic */ void access$3(ImageDialog imageDialog, int n) {
        imageDialog.busyCounter = n;
    }

    static /* synthetic */ HashMap access$4(ImageDialog imageDialog) {
        return imageDialog.imageDimensionsMap;
    }

    static /* synthetic */ int access$5(ImageDialog imageDialog) {
        return imageDialog.busyCounter;
    }

    static /* synthetic */ SailingServiceAsync access$6(ImageDialog imageDialog) {
        return imageDialog.sailingService;
    }

    static /* synthetic */ void access$7(ImageDialog imageDialog) {
        imageDialog.validateAndUpdate();
    }
}

