/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.IgtimiDevicesPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.IgtimiDataAccessWindowWithSecurityDTO;
import com.sap.sailing.gwt.ui.shared.IgtimiDeviceWithSecurityDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.Comparator;

public class IgtimiDevicesPanel
extends FlowPanel
implements FilterablePanelProvider<IgtimiDeviceWithSecurityDTO> {
    private final StringMessages stringMessages;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final LabeledAbstractFilterablePanel<IgtimiDeviceWithSecurityDTO> filterDevicesPanel;
    private final RefreshableMultiSelectionModel<IgtimiDeviceWithSecurityDTO> refreshableDevicesSelectionModel;
    private final LabeledAbstractFilterablePanel<IgtimiDataAccessWindowWithSecurityDTO> filterDataAccessWindowPanel;
    private final RefreshableMultiSelectionModel<IgtimiDataAccessWindowWithSecurityDTO> refreshableDataAccessWindowsSelectionModel;

    public IgtimiDevicesPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.errorReporter = presenter.getErrorReporter();
        this.stringMessages = stringMessages;
        AdminConsoleTableResources tableRes = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        Label igtimiConnectionFactoryParams = new Label();
        Anchor linkToRemoteRiotAdminPanel = new Anchor(stringMessages.configuration(), null, "_blank");
        HorizontalPanel remoteRiotConfig = new HorizontalPanel();
        remoteRiotConfig.setSpacing(5);
        remoteRiotConfig.add((Widget)igtimiConnectionFactoryParams);
        remoteRiotConfig.add((Widget)linkToRemoteRiotAdminPanel);
        this.add((Widget)remoteRiotConfig);
        this.add((Widget)new Label(stringMessages.localServer()));
        this.sailingServiceWrite.getIgtimiConnectionFactoryBaseUrl((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        CaptionPanel devicesCaptionPanel = new CaptionPanel(stringMessages.igtimiDevices());
        VerticalPanel devicesCaptionPanelContents = new VerticalPanel();
        devicesCaptionPanel.add((Widget)devicesCaptionPanelContents);
        FlushableCellTable devicesTable = new FlushableCellTable(50, (CellTable.Resources)tableRes);
        ListDataProvider filteredDevices = new ListDataProvider();
        this.filterDevicesPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.createIgtimiDevicesTable(devicesTable, (CellTableWithCheckboxResources)tableRes, presenter.getUserService(), filteredDevices, this.filterDevicesPanel);
        this.refreshableDevicesSelectionModel = (RefreshableMultiSelectionModel)devicesTable.getSelectionModel();
        HorizontalPanel devicesControlsPanel = new HorizontalPanel();
        this.filterDevicesPanel.setUpdatePermissionFilterForCheckbox(device -> presenter.getUserService().hasPermission((SecuredDTO)device, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        devicesControlsPanel.add((Widget)this.filterDevicesPanel);
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(presenter.getUserService(), SecuredDomainType.IGTIMI_DEVICE);
        devicesControlsPanel.add((Widget)buttonPanel);
        buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.refreshDevices());
        Button removeDeviceButton = buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableDevicesSelectionModel, true, () -> {
            if (this.refreshableDevicesSelectionModel.getSelectedSet().size() > 0 && Window.confirm((String)stringMessages.doYouReallyWantToRemoveTheSelectedIgtimiDevices())) {
                for (IgtimiDeviceWithSecurityDTO device : this.refreshableDevicesSelectionModel.getSelectedSet()) {
                    this.removeDevice(device, filteredDevices);
                }
            }
        });
        removeDeviceButton.setEnabled(false);
        devicesCaptionPanelContents.add((Widget)devicesControlsPanel);
        devicesCaptionPanelContents.add((Widget)devicesTable);
        this.add((Widget)devicesCaptionPanel);
        CaptionPanel dataAccessWindowsCaptionPanel = new CaptionPanel(stringMessages.igtimiDataAccessWindows());
        VerticalPanel dataAccessWindowsCaptionPanelContents = new VerticalPanel();
        dataAccessWindowsCaptionPanel.add((Widget)dataAccessWindowsCaptionPanelContents);
        FlushableCellTable dawTable = new FlushableCellTable(50, (CellTable.Resources)tableRes);
        ListDataProvider filteredDAWs = new ListDataProvider();
        this.filterDataAccessWindowPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.createIgtimiDataAccessWindowsTable(dawTable, (CellTableWithCheckboxResources)tableRes, presenter.getUserService(), filteredDAWs, this.filterDataAccessWindowPanel);
        this.refreshableDataAccessWindowsSelectionModel = (RefreshableMultiSelectionModel)dawTable.getSelectionModel();
        HorizontalPanel dawControlsPanel = new HorizontalPanel();
        this.filterDataAccessWindowPanel.setUpdatePermissionFilterForCheckbox(daw -> presenter.getUserService().hasPermission((SecuredDTO)daw, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
        dawControlsPanel.add((Widget)this.filterDataAccessWindowPanel);
        AccessControlledButtonPanel dawButtonPanel = new AccessControlledButtonPanel(presenter.getUserService(), SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW);
        dawControlsPanel.add((Widget)dawButtonPanel);
        dawButtonPanel.addUnsecuredAction(stringMessages.refresh(), () -> this.refreshDataAccessWindows());
        Button removeDAWButton = dawButtonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.refreshableDataAccessWindowsSelectionModel, true, () -> {
            if (this.refreshableDataAccessWindowsSelectionModel.getSelectedSet().size() > 0 && Window.confirm((String)stringMessages.doYouReallyWantToRemoveTheSelectedIgtimiDataAccessWindows())) {
                for (IgtimiDataAccessWindowWithSecurityDTO daw : this.refreshableDataAccessWindowsSelectionModel.getSelectedSet()) {
                    this.removeDataAccessWindow(daw, filteredDAWs);
                }
            }
        });
        removeDAWButton.setEnabled(false);
        this.refreshableDevicesSelectionModel.addSelectionChangeHandler(arg_0 -> this.lambda$6(removeDeviceButton, dawTable, (Panel)dawControlsPanel, arg_0));
        this.refreshableDataAccessWindowsSelectionModel.addSelectionChangeHandler(e -> removeDAWButton.setEnabled(this.refreshableDataAccessWindowsSelectionModel.getSelectedSet().size() > 0));
        dataAccessWindowsCaptionPanelContents.add((Widget)dawControlsPanel);
        dataAccessWindowsCaptionPanelContents.add((Widget)dawTable);
        this.add((Widget)dataAccessWindowsCaptionPanel);
        Button addDataAccessWindoweButton = dawButtonPanel.addCreateAction(stringMessages.addIgtimiDataAccessWindow(), () -> this.addDataAccessWindow());
        addDataAccessWindoweButton.ensureDebugId("addIgtimiDataAccessWindow");
        dawTable.setVisible(false);
    }

    private FlushableCellTable<IgtimiDeviceWithSecurityDTO> createIgtimiDevicesTable(FlushableCellTable<IgtimiDeviceWithSecurityDTO> table, CellTableWithCheckboxResources tableResources, UserService userService, ListDataProvider<IgtimiDeviceWithSecurityDTO> filteredDevices, LabeledAbstractFilterablePanel<IgtimiDeviceWithSecurityDTO> filterDevicesPanel) {
        filteredDevices.addDataDisplay(table);
        SelectionCheckboxColumn devicesSelectionCheckboxColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, filterDevicesPanel.getAllListDataProvider(), table);
        ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(filteredDevices.getList());
        table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        columnSortHandler.setComparator((Column)devicesSelectionCheckboxColumn, (Comparator)devicesSelectionCheckboxColumn.getComparator());
        AbstractSortableTextColumn deviceIdColumn = new AbstractSortableTextColumn(device -> "" + device.getId(), columnSortHandler);
        AbstractSortableTextColumn deviceNameColumn = new AbstractSortableTextColumn(device -> device.getName(), columnSortHandler);
        AbstractSortableTextColumn deviceSerialNumberColumn = new AbstractSortableTextColumn(device -> device.getSerialNumber(), columnSortHandler);
        AbstractSortableTextColumn lastHeartBeatColumn = new AbstractSortableTextColumn(device -> device.getLastHeartBeat() == null || device.getLastHeartBeat().getA() == null ? "" : ((TimePoint)device.getLastHeartBeat().getA()).toString(), columnSortHandler, (a, b) -> Util.compareToWithNull((Comparable)(a.getLastHeartBeat() == null ? null : (TimePoint)a.getLastHeartBeat().getA()), b.getLastHeartBeat() == null ? null : (TimePoint)b.getLastHeartBeat().getA(), (boolean)true));
        AbstractSortableTextColumn remoteAddressColumn = new AbstractSortableTextColumn(device -> device.getLastHeartBeat() == null ? null : (String)device.getLastHeartBeat().getB(), columnSortHandler);
        SafeHtmlCell lastKnownPositionCell = new SafeHtmlCell();
        5 lastKnownPositionColumn = new /* Unavailable Anonymous Inner Class!! */;
        AbstractSortableTextColumn lastKnownBatteryPercentColumn = new AbstractSortableTextColumn(device -> Double.isNaN(device.getLastKnownBatteryPercent()) ? "?" : NumberFormat.getFormat((String)"0.0").format(device.getLastKnownBatteryPercent()), columnSortHandler);
        HasPermissions type = SecuredDomainType.IGTIMI_DEVICE;
        AccessControlledActionsColumn actionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DevicesImagesBarCell(this.stringMessages), (UserService)userService);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, device -> this.editDevice(device, filteredDevices));
        actionColumn.addAction("ACTION_GPS_OFF", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.sendGPSOff(arg_0));
        actionColumn.addAction("ACTION_GPS_ON", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.sendGPSOn(arg_0));
        actionColumn.addAction("ACTION_RESTART", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.sendRestart(arg_0));
        actionColumn.addAction("ACTION_POWER_OFF", (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, arg_0 -> this.sendPowerOff(arg_0));
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, device -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveIgtimiDevice(device.getSerialNumber()))) {
                this.removeDevice(device, filteredDevices);
            }
        });
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, roleDefinition -> this.refreshDevices(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)config).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, roleDefinition -> this.refreshDevices(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        table.addColumn((Column)devicesSelectionCheckboxColumn, devicesSelectionCheckboxColumn.getHeader());
        table.addColumn((Column)deviceIdColumn, this.stringMessages.id());
        table.addColumn((Column)deviceNameColumn, this.stringMessages.name());
        table.addColumn((Column)deviceSerialNumberColumn, this.stringMessages.serialNumber());
        table.addColumn((Column)lastHeartBeatColumn, this.stringMessages.lastHeartBeat());
        table.addColumn((Column)remoteAddressColumn, this.stringMessages.remoteAddress());
        table.addColumn((Column)lastKnownPositionColumn, this.stringMessages.position());
        table.addColumn((Column)lastKnownBatteryPercentColumn, this.stringMessages.batteryPercent());
        SecuredDTOOwnerColumn.configureOwnerColumns(table, (ColumnSortEvent.ListHandler)columnSortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        table.addColumn((Column)actionColumn, this.stringMessages.actions());
        table.setSelectionModel((SelectionModel)devicesSelectionCheckboxColumn.getSelectionModel(), devicesSelectionCheckboxColumn.getSelectionManager());
        return table;
    }

    private void editDevice(IgtimiDeviceWithSecurityDTO device, ListDataProvider<IgtimiDeviceWithSecurityDTO> filteredDevices) {
        new /* Unavailable Anonymous Inner Class!! */.show();
    }

    private FlushableCellTable<IgtimiDataAccessWindowWithSecurityDTO> createIgtimiDataAccessWindowsTable(FlushableCellTable<IgtimiDataAccessWindowWithSecurityDTO> table, CellTableWithCheckboxResources tableResources, UserService userService, ListDataProvider<IgtimiDataAccessWindowWithSecurityDTO> filteredDAWs, LabeledAbstractFilterablePanel<IgtimiDataAccessWindowWithSecurityDTO> filterDataAccessWindowsPanel) {
        filteredDAWs.addDataDisplay(table);
        SelectionCheckboxColumn dawsSelectionCheckboxColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, filterDataAccessWindowsPanel.getAllListDataProvider(), table);
        ColumnSortEvent.ListHandler columnSortHandler = new ColumnSortEvent.ListHandler(filteredDAWs.getList());
        table.addColumnSortHandler((ColumnSortEvent.Handler)columnSortHandler);
        columnSortHandler.setComparator((Column)dawsSelectionCheckboxColumn, (Comparator)dawsSelectionCheckboxColumn.getComparator());
        AbstractSortableTextColumn dawIdColumn = new AbstractSortableTextColumn(daw -> "" + daw.getId(), columnSortHandler);
        AbstractSortableTextColumn dawSerialNumberColumn = new AbstractSortableTextColumn(daw -> daw.getSerialNumber(), columnSortHandler);
        AbstractSortableTextColumn dawFromColumn = new AbstractSortableTextColumn(daw -> daw.getFrom().toString(), columnSortHandler, (daw1, daw2) -> Util.compareToWithNull((Comparable)daw1.getFrom(), (Comparable)daw2.getFrom(), (boolean)true));
        AbstractSortableTextColumn dawToColumn = new AbstractSortableTextColumn(daw -> daw.getTo().toString(), columnSortHandler, (daw1, daw2) -> Util.compareToWithNull((Comparable)daw1.getTo(), (Comparable)daw2.getTo(), (boolean)false));
        HasPermissions type = SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW;
        AccessControlledActionsColumn actionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, daw -> {
            if (Window.confirm((String)this.stringMessages.doYouReallyWantToRemoveIgtimiDataAccessWindow(daw.getSerialNumber(), daw.getFrom().toString(), daw.getTo().toString()))) {
                this.removeDataAccessWindow(daw, filteredDAWs);
            }
        });
        EditOwnershipDialog.DialogConfig config = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, roleDefinition -> this.refreshDataAccessWindows(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)config).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)type, roleDefinition -> this.refreshDataAccessWindows(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        table.addColumn((Column)dawsSelectionCheckboxColumn, dawsSelectionCheckboxColumn.getHeader());
        table.addColumn((Column)dawIdColumn, this.stringMessages.id());
        table.addColumn((Column)dawSerialNumberColumn, this.stringMessages.serialNumber());
        table.addColumn((Column)dawFromColumn, this.stringMessages.from());
        table.addColumn((Column)dawToColumn, this.stringMessages.to());
        SecuredDTOOwnerColumn.configureOwnerColumns(table, (ColumnSortEvent.ListHandler)columnSortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        table.addColumn((Column)actionColumn, this.stringMessages.actions());
        table.setSelectionModel((SelectionModel)dawsSelectionCheckboxColumn.getSelectionModel(), dawsSelectionCheckboxColumn.getSelectionManager());
        return table;
    }

    public void refreshDevices() {
        this.sailingServiceWrite.getAllIgtimiDevicesWithSecurity((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshDataAccessWindows() {
        this.sailingServiceWrite.getAllIgtimiDataAccessWindowsWithSecurity((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addDataAccessWindow() {
        new AddDataAccessWindowDialog(this, () -> this.refreshDataAccessWindows(), this.sailingServiceWrite, this.stringMessages, this.errorReporter).show();
    }

    private void removeDevice(IgtimiDeviceWithSecurityDTO device, ListDataProvider<IgtimiDeviceWithSecurityDTO> removeFrom) {
        this.sailingServiceWrite.removeIgtimiDevice(device.getSerialNumber(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void removeDataAccessWindow(IgtimiDataAccessWindowWithSecurityDTO daw, ListDataProvider<IgtimiDataAccessWindowWithSecurityDTO> removeFrom) {
        this.sailingServiceWrite.removeIgtimiDataAccessWindow(daw.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public AbstractFilterablePanel<IgtimiDeviceWithSecurityDTO> getFilterablePanel() {
        return this.filterDevicesPanel;
    }

    private void sendGPSOff(IgtimiDeviceWithSecurityDTO device) {
        if (Window.confirm((String)this.stringMessages.reallyTurnGPSOffForIgtimiDevice(device.getSerialNumber()))) {
            this.sailingServiceWrite.sendGPSOffCommandToIgtimiDevice(device.getSerialNumber(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void sendGPSOn(IgtimiDeviceWithSecurityDTO device) {
        if (Window.confirm((String)this.stringMessages.reallyTurnGPSOnForIgtimiDevice(device.getSerialNumber()))) {
            this.sailingServiceWrite.sendGPSOnCommandToIgtimiDevice(device.getSerialNumber(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void sendPowerOff(IgtimiDeviceWithSecurityDTO device) {
        if (Window.confirm((String)this.stringMessages.reallyPowerOffIgtimiDevice(device.getSerialNumber()))) {
            this.sailingServiceWrite.sendPowerOffCommandToIgtimiDevice(device.getSerialNumber(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void sendRestart(IgtimiDeviceWithSecurityDTO device) {
        if (Window.confirm((String)this.stringMessages.reallyRestartIgtimiDevice(device.getSerialNumber()))) {
            this.sailingServiceWrite.sendRestartCommandToIgtimiDevice(device.getSerialNumber(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ StringMessages access$0(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.stringMessages;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$1(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.filterDevicesPanel;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$2(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.refreshableDevicesSelectionModel;
    }

    static /* synthetic */ SailingServiceWriteAsync access$3(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.sailingServiceWrite;
    }

    static /* synthetic */ ErrorReporter access$4(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.errorReporter;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$5(IgtimiDevicesPanel igtimiDevicesPanel) {
        return igtimiDevicesPanel.filterDataAccessWindowPanel;
    }

    private /* synthetic */ void lambda$6(Button button, FlushableCellTable flushableCellTable, Panel panel, SelectionChangeEvent e) {
        button.setEnabled(this.refreshableDevicesSelectionModel.getSelectedSet().size() > 0);
        boolean exactlyOneDeviceSelected = this.refreshableDevicesSelectionModel.getSelectedSet().size() == 1;
        flushableCellTable.setVisible(exactlyOneDeviceSelected);
        panel.setVisible(exactlyOneDeviceSelected);
        if (exactlyOneDeviceSelected) {
            this.filterDataAccessWindowPanel.search(((IgtimiDeviceWithSecurityDTO)this.refreshableDevicesSelectionModel.getSelectedSet().iterator().next()).getSerialNumber());
        }
    }
}

