/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.client.GWTLocaleUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExternalLinksComposite
extends Composite {
    private Map<String, TextBox> sailorsInfoWebsiteURLEntryFields = new HashMap();
    private TextBox officialWebsiteURLEntryField;

    public ExternalLinksComposite(StringMessages stringMessages) {
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        this.officialWebsiteURLEntryField = new TextBox();
        this.officialWebsiteURLEntryField.setVisibleLength(50);
        this.sailorsInfoWebsiteURLEntryFields = this.createTextBoxesForLocalesAndDefault(Collections.emptyMap());
        int rowIndex = 0;
        Grid formGrid = new Grid(GWTLocaleUtil.getLanguageCountWithDefault() + 3, 2);
        formGrid.setWidget(rowIndex, 0, (Widget)new Label(String.valueOf(stringMessages.eventOfficialWebsiteURL()) + ":"));
        formGrid.setWidget(rowIndex++, 1, (Widget)this.officialWebsiteURLEntryField);
        formGrid.setWidget(rowIndex++, 0, (Widget)new Label(stringMessages.eventSailorsInfoWebsiteURL()));
        for (Map.Entry sailorsInfoWebsiteUrlEntry : this.sailorsInfoWebsiteURLEntryFields.entrySet()) {
            String locale = (String)sailorsInfoWebsiteUrlEntry.getKey();
            String suffix = locale == null ? "*" : "[" + locale + "]";
            String text = locale == null ? stringMessages.urlForAllLanguages() : stringMessages.urlForLanguage(LocaleInfo.getLocaleNativeDisplayName((String)locale));
            Label urlLabel = new Label(String.valueOf(text) + " " + suffix + ":");
            urlLabel.getElement().getStyle().setMarginLeft(10.0, Style.Unit.PX);
            formGrid.setWidget(rowIndex, 0, (Widget)urlLabel);
            formGrid.setWidget(rowIndex, 1, (Widget)sailorsInfoWebsiteUrlEntry.getValue());
            ++rowIndex;
        }
        panel.add((Widget)formGrid);
        panel.add((Widget)new Label("[*] " + stringMessages.defaultSailorsInfoLinkInfoText()));
        this.initWidget((Widget)panel);
    }

    public String getOfficialWebsiteURLValue() {
        String value = this.officialWebsiteURLEntryField.getText().trim();
        return value.isEmpty() ? null : value;
    }

    public Map<String, String> getSailorsInfoWebsiteURLs() {
        HashMap<String, String> sailorsInfoWebsiteURLsMap = new HashMap<String, String>();
        for (Map.Entry sailorsInfoWebsiteUrlEntry : this.sailorsInfoWebsiteURLEntryFields.entrySet()) {
            TextBox sailorsInfoWebsiteURLEntryField = (TextBox)sailorsInfoWebsiteUrlEntry.getValue();
            String sailorsInfoWebsiteURL = sailorsInfoWebsiteURLEntryField.getText().trim();
            sailorsInfoWebsiteURLsMap.put((String)sailorsInfoWebsiteUrlEntry.getKey(), sailorsInfoWebsiteURL.isEmpty() ? null : sailorsInfoWebsiteURL);
        }
        return sailorsInfoWebsiteURLsMap;
    }

    public void fillExternalLinks(EventDTO event) {
        Map initialValues = event.getSailorsInfoWebsiteURLs();
        for (String localeName : GWTLocaleUtil.getAvailableLocalesAndDefault()) {
            ((TextBox)this.sailorsInfoWebsiteURLEntryFields.get(localeName)).setValue((Object)((String)initialValues.get(localeName)));
        }
        this.officialWebsiteURLEntryField.setValue((Object)event.getOfficialWebsiteURL());
    }

    private Map<String, TextBox> createTextBoxesForLocalesAndDefault(Map<String, String> initialValues) {
        LinkedHashMap<String, TextBox> result = new LinkedHashMap<String, TextBox>();
        for (String localeName : GWTLocaleUtil.getAvailableLocalesAndDefault()) {
            TextBox sailorsInfoWebsiteURLEntryField = new TextBox();
            sailorsInfoWebsiteURLEntryField.setValue((Object)initialValues.get(localeName));
            sailorsInfoWebsiteURLEntryField.setVisibleLength(50);
            result.put(localeName, sailorsInfoWebsiteURLEntryField);
        }
        return result;
    }
}

