/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AIAgentConfigurationPanel;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.Displayer;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.security.shared.dto.NamedDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.TableWrapperWithMultiSelectionAndFilterForSecuredDTO;
import java.util.HashSet;
import java.util.Set;

public class AIAgentConfigurationPanel
extends SimplePanel {
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final StringMessages stringMessages;
    private final UserService userService;
    private final ErrorReporter errorReporter;
    private final TableWrapperWithMultiSelectionAndFilterForSecuredDTO<EventDTO, StringMessages, AdminConsoleTableResources> eventsTableWrapper;
    private final Set<EventDTO> selectedEvents;
    private final Label hasCredentialsLabel;
    private final CaptionPanel eventsCaptionPanel;
    private boolean selectionUpdatedAfterEventsHaveLoaded;
    private boolean handleSelectionChangeEvents;
    private String languageModelName;

    public AIAgentConfigurationPanel(AdminConsoleView.Presenter presenter, StringMessages stringMessages) {
        this.sailingServiceWrite = presenter.getSailingService();
        this.stringMessages = stringMessages;
        this.userService = presenter.getUserService();
        this.errorReporter = presenter.getErrorReporter();
        this.selectedEvents = new HashSet();
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(this.userService, SecuredDomainType.EVENT);
        AdminConsoleTableResources adminConsoleTableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
        this.hasCredentialsLabel = new Label();
        Label languageModelNameLabel = new Label();
        this.eventsTableWrapper = new /* Unavailable Anonymous Inner Class!! */;
        this.eventsTableWrapper.addColumn(NamedDTO::getName, stringMessages.name());
        SafeHtmlCell descriptionCell = new SafeHtmlCell();
        3 descriptionColumn = new /* Unavailable Anonymous Inner Class!! */;
        descriptionColumn.setCellStyleNames(adminConsoleTableResources.cellTableStyle().cellTableWrapText());
        this.eventsTableWrapper.addColumn((Column)descriptionColumn, stringMessages.description());
        this.eventsTableWrapper.addColumn(e -> e.getVenue().getName(), stringMessages.venue());
        this.eventsTableWrapper.addColumn(e -> e.getId().toString(), stringMessages.id());
        ((RefreshableMultiSelectionModel)this.eventsTableWrapper.getSelectionModel()).addSelectionChangeHandler(selectionChangeEvent -> {
            if (this.handleSelectionChangeEvents) {
                Set newSelection = ((RefreshableMultiSelectionModel)this.eventsTableWrapper.getSelectionModel()).getSelectedSet();
                HashSet addedToSelection = new HashSet(newSelection);
                addedToSelection.removeAll(this.selectedEvents);
                HashSet removedFromSelection = new HashSet(this.selectedEvents);
                removedFromSelection.removeAll(newSelection);
                this.selectedEvents.clear();
                this.selectedEvents.addAll(((RefreshableMultiSelectionModel)this.eventsTableWrapper.getSelectionModel()).getSelectedSet());
                addedToSelection.forEach(e -> this.sailingServiceWrite.startAICommentingOnEvent(e.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
                removedFromSelection.forEach(e -> this.sailingServiceWrite.stopAICommentingOnEvent(e.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
            }
        });
        Button refresh = buttonPanel.addUnsecuredAction(stringMessages.refresh(), () -> presenter.getEventsRefresher().reloadAndCallFillAll());
        refresh.ensureDebugId("RefreshEventsButton");
        this.eventsCaptionPanel = new CaptionPanel(stringMessages.selectEventsForWhichToUseAICommenting());
        this.eventsCaptionPanel.setWidth("100%");
        VerticalPanel contents = new VerticalPanel();
        contents.setWidth("100%");
        contents.add((Widget)buttonPanel);
        TextArea credentialsTextArea = new TextArea();
        credentialsTextArea.getElement().setAttribute("placeholder", stringMessages.placeholderAICoreCredentialsAsJSON());
        credentialsTextArea.setSize("60em", "15em");
        CaptionPanel credentialsCaptionPanel = new CaptionPanel(stringMessages.credentials());
        VerticalPanel credentialsVP = new VerticalPanel();
        credentialsVP.setSpacing(5);
        HorizontalPanel credentialsHP = new HorizontalPanel();
        credentialsHP.setSpacing(5);
        credentialsCaptionPanel.setContentWidget((Widget)credentialsVP);
        credentialsHP.add((Widget)credentialsTextArea);
        Button credentialsUpdateButton = new Button(stringMessages.updateCredentials());
        this.eventsTableWrapper.getTable().setWidth("100%");
        6 hasAIAgentCredentialsCallback = new /* Unavailable Anonymous Inner Class!! */;
        this.sailingServiceWrite.hasAIAgentCredentials((AsyncCallback)hasAIAgentCredentialsCallback);
        credentialsUpdateButton.addClickHandler(arg_0 -> this.lambda$7(credentialsTextArea, (AsyncCallback)hasAIAgentCredentialsCallback, stringMessages, arg_0));
        credentialsHP.add((Widget)credentialsUpdateButton);
        credentialsVP.add((Widget)this.hasCredentialsLabel);
        credentialsVP.add((Widget)credentialsHP);
        mainPanel.add((Widget)credentialsCaptionPanel);
        mainPanel.add((Widget)languageModelNameLabel);
        mainPanel.add((Widget)this.eventsCaptionPanel);
        this.setWidget((Widget)mainPanel);
    }

    public Displayer<EventDTO> getEventsDisplayer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void updateHasCredentialsLabelAndSetEventsCaptionVisibility(boolean hasCredentials) {
        this.hasCredentialsLabel.setText(hasCredentials ? this.stringMessages.hasAIAgentCredentials() : this.stringMessages.hasNoAIAgentCredentials());
        this.eventsCaptionPanel.setVisible(hasCredentials);
    }

    static /* synthetic */ void access$0(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl) {
        aIAgentConfigurationPanel.updateHasCredentialsLabelAndSetEventsCaptionVisibility(bl);
    }

    static /* synthetic */ SailingServiceWriteAsync access$1(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.sailingServiceWrite;
    }

    static /* synthetic */ void access$2(AIAgentConfigurationPanel aIAgentConfigurationPanel, String string) {
        aIAgentConfigurationPanel.languageModelName = string;
    }

    static /* synthetic */ TableWrapperWithMultiSelectionAndFilterForSecuredDTO access$3(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.eventsTableWrapper;
    }

    static /* synthetic */ CaptionPanel access$4(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.eventsCaptionPanel;
    }

    static /* synthetic */ boolean access$5(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.selectionUpdatedAfterEventsHaveLoaded;
    }

    static /* synthetic */ void access$6(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl) {
        aIAgentConfigurationPanel.handleSelectionChangeEvents = bl;
    }

    static /* synthetic */ String access$7(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.languageModelName;
    }

    static /* synthetic */ void access$8(AIAgentConfigurationPanel aIAgentConfigurationPanel, boolean bl) {
        aIAgentConfigurationPanel.selectionUpdatedAfterEventsHaveLoaded = bl;
    }

    static /* synthetic */ StringMessages access$9(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.stringMessages;
    }

    static /* synthetic */ Set access$10(AIAgentConfigurationPanel aIAgentConfigurationPanel) {
        return aIAgentConfigurationPanel.selectedEvents;
    }

    private /* synthetic */ void lambda$7(TextArea textArea, AsyncCallback asyncCallback, StringMessages stringMessages, ClickEvent e) {
        this.sailingServiceWrite.setAIAgentCredentials(textArea.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

