/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.server;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventSeriesDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListViewDTO;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.util.EventUtil;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class EventListDataCalculator
implements HomeServiceUtil.EventVisitor {
    private final Map<UUID, EventListEventDTO> lastestEventPerSeries = new HashMap();
    private final Map<UUID, Integer> numberOfEventsPerSeries = new HashMap();
    private final Map<UUID, String> seriesNames = new HashMap();
    private final EventListViewDTO result = new EventListViewDTO();
    private final RacingEventService service;

    public EventListDataCalculator(RacingEventService service) {
        this.service = service;
    }

    public void visit(EventBase event, boolean onRemoteServer, URL baseURL) {
        if (event.getStartDate() != null) {
            EventListEventDTO eventDTO = HomeServiceUtil.convertToEventListDTO((EventBase)event, (URL)baseURL, (boolean)onRemoteServer, (RacingEventService)this.service);
            if (HomeServiceUtil.calculateEventState((EventBase)event) != EventState.UPCOMING && EventUtil.isFakeSeries((EventBase)event)) {
                EventListEventDTO latestEvent;
                LeaderboardGroupBase seriesLeaderboardGroup = (LeaderboardGroupBase)event.getLeaderboardGroups().iterator().next();
                UUID seriesLeaderboardGroupId = seriesLeaderboardGroup.getId();
                if (!this.seriesNames.containsKey(seriesLeaderboardGroupId)) {
                    this.seriesNames.put(seriesLeaderboardGroupId, HomeServiceUtil.getLeaderboardDisplayName((LeaderboardGroupBase)seriesLeaderboardGroup));
                }
                if ((latestEvent = (EventListEventDTO)this.lastestEventPerSeries.get(seriesLeaderboardGroupId)) == null || latestEvent.getStartDate().before(eventDTO.getStartDate())) {
                    this.lastestEventPerSeries.put(seriesLeaderboardGroupId, eventDTO);
                }
                this.increaseNumberOfEvents(seriesLeaderboardGroupId);
            } else {
                this.addEventToResults(eventDTO);
            }
        }
    }

    private void increaseNumberOfEvents(UUID seriesLeaderboardGroupId) {
        Integer currentValue = (Integer)this.numberOfEventsPerSeries.get(seriesLeaderboardGroupId);
        currentValue = currentValue == null ? 0 : currentValue;
        currentValue = currentValue + 1;
        this.numberOfEventsPerSeries.put(seriesLeaderboardGroupId, currentValue);
    }

    public EventListViewDTO getResult() {
        for (Map.Entry latestEventInSeries : this.lastestEventPerSeries.entrySet()) {
            UUID seriesLeaderboardGroupId = (UUID)latestEventInSeries.getKey();
            EventListEventDTO latestEvent = (EventListEventDTO)latestEventInSeries.getValue();
            latestEvent.setEventSeries(new EventListEventSeriesDTO((String)this.seriesNames.get(seriesLeaderboardGroupId), seriesLeaderboardGroupId));
            latestEvent.getEventSeries().setEventsCount(((Integer)this.numberOfEventsPerSeries.get(seriesLeaderboardGroupId)).intValue());
            this.addEventToResults(latestEvent);
        }
        this.result.addStatistics(this.service.getOverallStatisticsByYear());
        return this.result;
    }

    private void addEventToResults(EventListEventDTO eventDTO) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(eventDTO.getStartDate());
        this.result.addEvent(eventDTO, cal.get(1));
    }
}

