/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.regattaoverview.client;

import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.CalendarUtil;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.gwt.regattaoverview.client.RaceStateFlagsInterpreter;
import com.sap.sailing.gwt.regattaoverview.client.RegattaRaceStatesComponent;
import com.sap.sailing.gwt.regattaoverview.client.RegattaRaceStatesSettingsDialogComponent;
import com.sap.sailing.gwt.regattaoverview.client.RegattaRaceStatesTableResources;
import com.sap.sailing.gwt.settings.client.EntryPointWithSettingsLinkFactory;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.settings.client.regattaoverview.RegattaRaceStatesSettings;
import com.sap.sailing.gwt.ui.client.AnchorCell;
import com.sap.sailing.gwt.ui.client.EntryPointLinkFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sailing.gwt.ui.shared.RaceCourseDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupDTO;
import com.sap.sailing.gwt.ui.shared.RaceGroupSeriesDTO;
import com.sap.sailing.gwt.ui.shared.RaceInfoDTO;
import com.sap.sailing.gwt.ui.shared.RegattaOverviewEntryDTO;
import com.sap.sailing.gwt.ui.shared.WaypointDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.gwt.client.DateTimeUtil;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.celltable.BaseCelltable;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractCompositeComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;

public class RegattaRaceStatesComponent
extends AbstractCompositeComponent<RegattaRaceStatesSettings> {
    private List<RegattaOverviewEntryDTO> allEntries;
    private ListDataProvider<RegattaOverviewEntryDTO> regattaOverviewDataProvider;
    private final VerticalPanel mainPanel;
    private final DateTimeFormat timeFormatter = DateTimeFormat.getFormat((String)"HH:mm:ss");
    private final DateTimeFormat dateFormatter = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT);
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final UUID eventId;
    private EventDTO eventDTO;
    private List<RaceGroupDTO> raceGroupDTOs;
    private TextColumn<RegattaOverviewEntryDTO> seriesNameColumn;
    private TextColumn<RegattaOverviewEntryDTO> fleetNameColumn;
    private final RegattaRaceStatesSettings settings;
    private final RaceStateFlagsInterpreter flagInterpreter;
    private final Timer timerToSynchronize;
    private static RegattaRaceStatesTableResources tableRes = (RegattaRaceStatesTableResources)GWT.create(RegattaRaceStatesTableResources.class);
    private EntryHandler entryClickedHandler;
    private TextColumn<RegattaOverviewEntryDTO> courseAreaColumn;
    private Column<RegattaOverviewEntryDTO, Anchor> regattaNameColumn;
    private FlowPanel repeatedInfoLabel;
    private Column<RegattaOverviewEntryDTO, SafeHtml> raceCourseColumn;
    private TextColumn<RegattaOverviewEntryDTO> boatClass;
    private TextColumn<RegattaOverviewEntryDTO> startTimeColumn;
    private TextColumn<RegattaOverviewEntryDTO> finishingTimeColumn;
    private TextColumn<RegattaOverviewEntryDTO> finishedTimeColumn;
    private SimplePanel tableHolder = new SimplePanel();
    private final long _1_HOUR = 3600L;
    private final long HIDE_COL_TIME_THRESHOLD = 3600L;
    private TextColumn<RegattaOverviewEntryDTO> lastUpdateColumn;
    private TextColumn<RegattaOverviewEntryDTO> endOfProtestTime;
    private TextColumn<RegattaOverviewEntryDTO> raceAdditionalInformationColumn;
    private Column<RegattaOverviewEntryDTO, SafeHtml> flagColumn;
    private Column<RegattaOverviewEntryDTO, SafeHtml> raceStatusColumn;
    private Column<RegattaOverviewEntryDTO, Anchor> raceNameColumn;
    private ColumnSortEvent.ListHandler<RegattaOverviewEntryDTO> regattaOverviewListHandler;
    private CellTable<RegattaOverviewEntryDTO> table;
    boolean hasAnyRaceGroupASeries = false;
    boolean hasAnyRaceGroupAFleet = false;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$PassingInstruction;

    public void setEntryClickedHandler(EntryHandler handler) {
        this.entryClickedHandler = handler;
    }

    public RegattaRaceStatesComponent(Component<?> parent, ComponentContext<?> componentContext, SailingServiceAsync sailingService, ErrorReporter errorReporter, StringMessages stringMessages, UUID eventId, EventDTO eventDTO, List<RaceGroupDTO> raceGroupDTOs, RegattaRaceStatesSettings settings, Timer timerToSynchronize) {
        super(parent, componentContext);
        this.eventId = eventId;
        this.sailingService = sailingService;
        this.stringMessages = stringMessages;
        this.allEntries = new ArrayList();
        this.timerToSynchronize = timerToSynchronize;
        this.eventDTO = null;
        this.raceGroupDTOs = null;
        this.flagInterpreter = new RaceStateFlagsInterpreter(stringMessages);
        this.settings = new RegattaRaceStatesSettings();
        this.mainPanel = new VerticalPanel();
        this.mainPanel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.regattaOverviewDataProvider = new ListDataProvider();
        this.createColumns();
        this.mainPanel.add((Widget)this.tableHolder);
        this.initWidget((Widget)this.mainPanel);
        this.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.eventDTO = eventDTO;
        this.setRaceGroups(raceGroupDTOs);
        this.updateSettings(settings);
    }

    public void onUpdateServer() {
        this.loadAndUpdateEventLog();
    }

    private void updateTable(List<RegattaOverviewEntryDTO> newEntries) {
        this.allEntries = newEntries;
        String firstCourseAreaName = null;
        String firstRegattaName = null;
        String firstCourseName = null;
        RaceInfoDTO firstCourseRegattaOverviewEntry = null;
        RegattaOverviewEntryDTO firstRegattaNameEntry = null;
        String lastBoatClass = null;
        boolean canRemoveCourseArea = true;
        boolean canRemoveCourse = true;
        boolean canRemoveRegatta = true;
        boolean canRemoveBoatClass = true;
        boolean canRemoveLastUpdate = true;
        boolean canRemoveProtestTime = true;
        boolean canRemoveFinishingTime = true;
        boolean canRemoveFinishedTime = true;
        boolean first = true;
        for (RegattaOverviewEntryDTO loopEntryDTO : this.allEntries) {
            RaceInfoDTO loopRaceInfo = loopEntryDTO.raceInfo;
            if (canRemoveLastUpdate && this.timePassedInSeconds(loopRaceInfo.lastUpdateTime) <= 3600L) {
                canRemoveLastUpdate = false;
            }
            if (canRemoveFinishingTime && loopRaceInfo.finishingTime != null && this.timePassedInSeconds(loopRaceInfo.finishingTime) <= 3600L) {
                canRemoveFinishingTime = false;
                canRemoveFinishedTime = false;
            }
            if (canRemoveFinishedTime && loopRaceInfo.finishedTime != null) {
                canRemoveFinishedTime = false;
            }
            if (canRemoveProtestTime && loopRaceInfo.protestFinishTime != null && this.timePassedInSeconds(loopRaceInfo.protestFinishTime) <= 3600L) {
                canRemoveProtestTime = false;
            }
            if (first) {
                firstRegattaName = loopEntryDTO.regattaDisplayName;
                firstRegattaNameEntry = loopEntryDTO;
                firstCourseAreaName = loopEntryDTO.courseAreaName;
                firstCourseName = loopRaceInfo.lastCourseName;
                firstCourseRegattaOverviewEntry = loopRaceInfo;
                lastBoatClass = loopEntryDTO.boatClassName;
            } else {
                if (canRemoveRegatta && !Util.equalsWithNull((Object)firstRegattaName, (Object)loopEntryDTO.regattaDisplayName)) {
                    canRemoveRegatta = false;
                }
                if (canRemoveCourseArea && !Util.equalsWithNull((Object)firstCourseAreaName, (Object)loopEntryDTO.courseAreaName)) {
                    canRemoveCourseArea = false;
                }
                if (!(!canRemoveCourse || Util.equalsWithNull(firstCourseName, (Object)loopRaceInfo.lastCourseName) && Util.equalsWithNull((Object)firstCourseRegattaOverviewEntry.lastCourseDesign, (Object)loopRaceInfo.lastCourseDesign))) {
                    canRemoveCourse = false;
                }
                if (canRemoveBoatClass && !Util.equalsWithNull(lastBoatClass, (Object)loopEntryDTO.boatClassName)) {
                    canRemoveBoatClass = false;
                }
            }
            first = false;
        }
        this.repeatedInfoLabel.clear();
        boolean isAppending = false;
        RegattaOverviewEntryDTO finalFirstRegattaNameEntry = firstRegattaNameEntry;
        isAppending |= this.collectRepeatedInfos(this.stringMessages.regatta(), firstRegattaName, canRemoveRegatta, this.repeatedInfoLabel, isAppending, (Command)new /* Unavailable Anonymous Inner Class!! */);
        isAppending |= this.collectRepeatedInfos(this.stringMessages.courseArea(), firstCourseAreaName, canRemoveCourseArea, this.repeatedInfoLabel, isAppending, null);
        RaceInfoDTO _lastCourseEntry = firstCourseRegattaOverviewEntry;
        isAppending |= this.collectRepeatedInfos(this.stringMessages.course(), firstCourseName, canRemoveCourse, this.repeatedInfoLabel, isAppending, (Command)new /* Unavailable Anonymous Inner Class!! */);
        isAppending |= this.collectRepeatedInfos(this.stringMessages.boatClass(), lastBoatClass, canRemoveBoatClass, this.repeatedInfoLabel, isAppending, null);
        LinkedList<ColumnSortList.ColumnSortInfo> sortInfos = new LinkedList<ColumnSortList.ColumnSortInfo>();
        if (this.table != null) {
            ColumnSortList columnSortList = this.table.getColumnSortList();
            int i = 0;
            while (i < columnSortList.size()) {
                sortInfos.addFirst(columnSortList.get(i));
                ++i;
            }
            this.table.removeFromParent();
            while (this.table.getColumnCount() > 0) {
                this.table.removeColumn(0);
            }
            this.regattaOverviewDataProvider.removeDataDisplay((HasData)this.table);
        } else {
            sortInfos.add(new ColumnSortList.ColumnSortInfo((Column)this.lastUpdateColumn, false));
        }
        this.table = new BaseCelltable(10000, (CellTable.Resources)tableRes);
        this.tableHolder.setWidget((Widget)this.table);
        this.regattaOverviewDataProvider.getList().clear();
        this.regattaOverviewDataProvider.addDataDisplay((HasData)this.table);
        this.table.setWidth("100%");
        if (!canRemoveRegatta) {
            this.table.addColumn(this.regattaNameColumn, this.stringMessages.regatta());
        }
        if (!canRemoveCourseArea) {
            this.table.addColumn((Column)this.courseAreaColumn, this.stringMessages.courseArea());
        }
        if (!canRemoveCourse) {
            this.table.addColumn(this.raceCourseColumn, this.stringMessages.course());
        }
        this.table.addColumn(this.raceNameColumn, this.stringMessages.race());
        if (!canRemoveBoatClass) {
            this.table.addColumn((Column)this.boatClass, this.stringMessages.boatClass());
        }
        if (this.hasAnyRaceGroupAFleet) {
            this.table.addColumn((Column)this.fleetNameColumn, this.stringMessages.fleet());
            this.table.setColumnWidth((Column)this.fleetNameColumn, 115.0, Style.Unit.PX);
        }
        this.table.addColumn((Column)this.seriesNameColumn, this.stringMessages.series());
        this.table.addColumn(this.flagColumn, this.stringMessages.flags());
        this.table.setColumnWidth(this.flagColumn, 95.0, Style.Unit.PX);
        this.table.addColumn(this.raceStatusColumn, this.stringMessages.status());
        if (!canRemoveLastUpdate) {
            this.table.addColumn((Column)this.lastUpdateColumn, this.stringMessages.lastUpdate());
        }
        this.table.addColumn((Column)this.startTimeColumn, this.stringMessages.startTime());
        if (!canRemoveFinishingTime) {
            this.table.addColumn((Column)this.finishingTimeColumn, this.stringMessages.finishingTime());
        }
        this.table.addColumn((Column)this.finishedTimeColumn, this.stringMessages.finishTimeString());
        if (!canRemoveProtestTime) {
            this.table.addColumn((Column)this.endOfProtestTime, this.stringMessages.protestTime());
        }
        this.table.addColumn((Column)this.raceAdditionalInformationColumn, this.stringMessages.additionalInformation());
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)this.regattaOverviewListHandler);
        this.regattaOverviewDataProvider.getList().clear();
        this.regattaOverviewDataProvider.getList().addAll(this.allEntries);
        if (this.entryClickedHandler != null) {
            for (RegattaOverviewEntryDTO entry : this.allEntries) {
                this.entryClickedHandler.onEntryUpdated(entry);
            }
        }
        boolean isSortedOk = false;
        if (sortInfos.size() > 0) {
            GWT.log((String)"Using existing sort info");
            for (ColumnSortList.ColumnSortInfo columnSortInfo : sortInfos) {
                if (this.table.getColumnIndex(columnSortInfo.getColumn()) < 0) continue;
                GWT.log((String)("Pushed: " + this.table.getHeader(this.table.getColumnIndex(columnSortInfo.getColumn())).getValue() + ", " + (columnSortInfo.isAscending() ? "ascending" : "descending")));
                this.table.getColumnSortList().push(columnSortInfo);
                isSortedOk = true;
            }
        }
        if (!isSortedOk) {
            ColumnSortList.ColumnSortInfo initialSortinfo = new ColumnSortList.ColumnSortInfo((Column)this.courseAreaColumn, false);
            this.table.getColumnSortList().push(initialSortinfo);
        }
        ColumnSortEvent.fire((HasHandlers)this.table, (ColumnSortList)this.table.getColumnSortList());
    }

    private boolean collectRepeatedInfos(String label, String info, boolean canRemove, FlowPanel panel, boolean append, Command linkAction) {
        if (canRemove && info != null && !info.isEmpty()) {
            if (append) {
                panel.add((Widget)new InlineLabel(", "));
            }
            if (linkAction == null) {
                panel.add((Widget)new InlineLabel(label + ": " + info));
            } else {
                panel.add((Widget)new InlineLabel(label + ": "));
                Anchor anchor = new Anchor(info);
                anchor.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                panel.add((Widget)anchor);
            }
            return true;
        }
        return append;
    }

    protected void loadAndUpdateEventLog() {
        if (this.eventDTO == null || this.raceGroupDTOs == null) {
            return;
        }
        long clientTimeWhenRequestWasSent = System.currentTimeMillis();
        Duration clientTimeZoneOffset = DateTimeUtil.getClientTimezoneOffsetFromUTC();
        this.sailingService.getRaceStateEntriesForRaceGroup(this.eventId, Util.asList((Iterable)this.settings.getVisibleCourseAreas()), Util.asList((Iterable)this.settings.getVisibleRegattas()), this.settings.isShowOnlyCurrentlyRunningRaces(), this.settings.isShowOnlyRacesOfSameDay(), clientTimeZoneOffset, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private String formatTime(Date time) {
        String result = "-";
        if (time != null) {
            result = "";
            if (!CalendarUtil.isSameDate((Date)time, (Date)new Date())) {
                result = String.valueOf(result) + this.dateFormatter.format(time) + " ";
            }
            result = String.valueOf(result) + this.timeFormatter.format(time);
        }
        return result;
    }

    private void createColumns() {
        this.regattaOverviewListHandler = new ColumnSortEvent.ListHandler(this.regattaOverviewDataProvider.getList());
        this.courseAreaColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.courseAreaColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.courseAreaColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        AnchorCell leaderboardAnchorCell = new AnchorCell();
        this.regattaNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.regattaNameColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator(this.regattaNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.seriesNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.seriesNameColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.seriesNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.fleetNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.fleetNameColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.fleetNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        AnchorCell raceCell = new AnchorCell();
        this.raceNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.raceNameColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator(this.raceNameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.startTimeColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.startTimeColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.startTimeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.finishingTimeColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.finishingTimeColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.finishingTimeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.finishedTimeColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.finishedTimeColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.finishedTimeColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.raceStatusColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.raceStatusColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.raceStatusColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator(this.raceStatusColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.raceCourseColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.raceCourseColumn.setSortable(true);
        this.raceCourseColumn.setFieldUpdater((FieldUpdater)new /* Unavailable Anonymous Inner Class!! */);
        this.regattaOverviewListHandler.setComparator(this.raceCourseColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        SafeHtmlCell flagsCell = new SafeHtmlCell();
        this.flagColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.flagColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator(this.flagColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.flagColumn.setCellStyleNames(tableRes.cellTableStyle().flagColumn());
        this.boatClass = new /* Unavailable Anonymous Inner Class!! */;
        this.boatClass.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.boatClass, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.lastUpdateColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.lastUpdateColumn.setDefaultSortAscending(false);
        this.lastUpdateColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.lastUpdateColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.raceAdditionalInformationColumn = new /* Unavailable Anonymous Inner Class!! */;
        this.raceAdditionalInformationColumn.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.raceAdditionalInformationColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.endOfProtestTime = new /* Unavailable Anonymous Inner Class!! */;
        this.endOfProtestTime.setSortable(true);
        this.regattaOverviewListHandler.setComparator((Column)this.endOfProtestTime, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean hasSettings() {
        return true;
    }

    public SettingsDialogComponent<RegattaRaceStatesSettings> getSettingsDialogComponent(RegattaRaceStatesSettings settings) {
        return new RegattaRaceStatesSettingsDialogComponent(settings, this.stringMessages, Collections.unmodifiableList(this.eventDTO.getVenue().getCourseAreas()), Collections.unmodifiableList(this.raceGroupDTOs));
    }

    public void updateSettings(RegattaRaceStatesSettings newSettings) {
        this.setDefaultCourseAreas();
        this.settings.setVisibleCourseAreas(newSettings.getVisibleCourseAreas());
        this.setDefaultRegattas();
        this.settings.setVisibleRegattas(newSettings.getVisibleRegattas());
        this.settings.setShowOnlyRaceOfSameDay(newSettings.isShowOnlyRacesOfSameDay());
        this.settings.setShowOnlyCurrentlyRunningRaces(newSettings.isShowOnlyCurrentlyRunningRaces());
        this.refreshTableWithNewSettings();
    }

    public RegattaRaceStatesSettings getSettings() {
        return this.settings;
    }

    private void refreshTableWithNewSettings() {
        if (this.eventDTO != null && this.raceGroupDTOs != null) {
            this.loadAndUpdateEventLog();
        }
    }

    private void setDefaultRegattas() {
        this.settings.setDefaultRegattas((Iterable)this.raceGroupDTOs);
    }

    private void setDefaultCourseAreas() {
        if (this.eventDTO != null) {
            this.settings.setDefaultCourseAreas((Iterable)this.eventDTO.getVenue().getCourseAreas());
        }
    }

    public String getLocalizedShortName() {
        return this.stringMessages.regattaOverview();
    }

    public Widget getEntryWidget() {
        return this;
    }

    private void setRaceGroups(List<RaceGroupDTO> raceGroups) {
        this.raceGroupDTOs = raceGroups;
        GWT.log((String)"onRaceGroupsUpdated");
        if (this.raceGroupDTOs != null) {
            block0: for (RaceGroupDTO raceGroup : this.raceGroupDTOs) {
                for (RaceGroupSeriesDTO series : raceGroup.getSeries()) {
                    if (!series.getName().equals("Default")) {
                        this.hasAnyRaceGroupASeries = true;
                    }
                    if (!this.hasAnyRaceGroupAFleet) {
                        for (FleetDTO fleet : series.getFleets()) {
                            if (fleet.getName().equals("Default")) continue;
                            this.hasAnyRaceGroupAFleet = true;
                            break;
                        }
                    }
                    if (this.hasAnyRaceGroupASeries && this.hasAnyRaceGroupAFleet) break block0;
                }
            }
        }
    }

    private DialogBox createCourseViewDialogBox(RaceInfoDTO raceInfoDTO) {
        DialogBox dialogBox = new DialogBox();
        dialogBox.setText(this.stringMessages.courseLayout());
        VerticalPanel dialogContents = new VerticalPanel();
        dialogContents.setSpacing(4);
        dialogBox.setWidget((Widget)dialogContents);
        Label courseNameLabel = new Label(raceInfoDTO.lastCourseName);
        dialogContents.add((Widget)courseNameLabel);
        Grid waypointGrid = new Grid(raceInfoDTO.lastCourseDesign.waypoints.size(), 1);
        dialogContents.add((Widget)waypointGrid);
        int i = 0;
        while (i < raceInfoDTO.lastCourseDesign.waypoints.size()) {
            WaypointDTO waypoint = (WaypointDTO)raceInfoDTO.lastCourseDesign.waypoints.get(i);
            waypointGrid.setText(i, 0, this.getWaypointNameLabel(waypoint));
            ++i;
        }
        Button closeButton = new Button(this.stringMessages.ok());
        closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        dialogContents.add((Widget)closeButton);
        dialogContents.setCellHorizontalAlignment((Widget)closeButton, HasHorizontalAlignment.ALIGN_CENTER);
        return dialogBox;
    }

    private String getWaypointNameLabel(WaypointDTO waypointDTO) {
        String result = waypointDTO.getName();
        result = String.valueOf(result) + (waypointDTO.passingInstructions == null ? "" : "," + this.getPassingInstructionsAsText(waypointDTO.passingInstructions));
        return result;
    }

    private void raceCourseClicked(RaceInfoDTO raceInfo) {
        RaceCourseDTO courseDTO = raceInfo.lastCourseDesign;
        if (courseDTO != null && courseDTO.waypoints.size() > 0) {
            DialogBox courseViewDialogBox = this.createCourseViewDialogBox(raceInfo);
            courseViewDialogBox.center();
            courseViewDialogBox.setGlassEnabled(true);
            courseViewDialogBox.setAnimationEnabled(true);
            courseViewDialogBox.show();
        }
    }

    /*
     * Exception decompiling
     */
    private String getPassingInstructionsAsText(PassingInstruction passingInstructions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final long timePassedInSeconds(Date dateTime) {
        if (dateTime == null) {
            return 0L;
        }
        return (new Date().getTime() - dateTime.getTime()) / 1000L;
    }

    private String formatDuration(Duration duration) {
        long seconds = Math.round(duration.asSeconds());
        long days = seconds / (long)Duration.ONE_DAY.asSeconds();
        long hours = (seconds %= 86400L) / (long)Duration.ONE_HOUR.asSeconds();
        long minutes = (seconds %= 3600L) / (long)Duration.ONE_MINUTE.asSeconds();
        seconds %= 60L;
        StringJoiner sj = new StringJoiner(":");
        if (days > 0L) {
            sj.add(String.valueOf(days));
        }
        if (days > 0L && hours < 10L) {
            sj.add("0" + String.valueOf(hours));
        } else {
            sj.add(String.valueOf(hours));
        }
        if (minutes < 10L) {
            sj.add("0" + String.valueOf(minutes));
        } else {
            sj.add(String.valueOf(minutes));
        }
        if (seconds < 10L) {
            sj.add("0" + String.valueOf(seconds));
        } else {
            sj.add(String.valueOf(seconds));
        }
        return sj.toString();
    }

    public String getDependentCssClassName() {
        return "regattaRaceStates";
    }

    private String createRaceLink(RegattaOverviewEntryDTO entryDTO) {
        if (entryDTO.raceInfo.raceIdentifier != null && entryDTO.raceInfo.isTracked) {
            RaceboardContextDefinition raceboardContext = new RaceboardContextDefinition(entryDTO.raceInfo.raceIdentifier.getRegattaName(), entryDTO.raceInfo.raceIdentifier.getRaceName(), entryDTO.leaderboardName, null, null, null, null);
            RaceBoardPerspectiveOwnSettings perspectiveOwnSettings = RaceBoardPerspectiveOwnSettings.createDefaultWithCanReplayDuringLiveRaces((boolean)true);
            PerspectiveCompositeSettings settings = new PerspectiveCompositeSettings((Settings)perspectiveOwnSettings, Collections.emptyMap());
            return EntryPointWithSettingsLinkFactory.createRaceBoardLink((RaceboardContextDefinition)raceboardContext, (PerspectiveCompositeSettings)settings);
        }
        return null;
    }

    private String createRegattaLink(RegattaOverviewEntryDTO entryDTO) {
        String leaderboardLink = EntryPointLinkFactory.createLeaderboardTabLink((String)this.eventId.toString(), (String)entryDTO.leaderboardName);
        return leaderboardLink;
    }

    public void setRepeatedInfoLabel(FlowPanel repeatedInfoLabel) {
        this.repeatedInfoLabel = repeatedInfoLabel;
    }

    public String getId() {
        return "rrs";
    }

    static /* synthetic */ String access$3(RegattaRaceStatesComponent regattaRaceStatesComponent, RegattaOverviewEntryDTO regattaOverviewEntryDTO) {
        return regattaRaceStatesComponent.createRegattaLink(regattaOverviewEntryDTO);
    }

    static /* synthetic */ void access$4(RegattaRaceStatesComponent regattaRaceStatesComponent, RaceInfoDTO raceInfoDTO) {
        regattaRaceStatesComponent.raceCourseClicked(raceInfoDTO);
    }

    static /* synthetic */ void access$5(RegattaRaceStatesComponent regattaRaceStatesComponent, List list) {
        regattaRaceStatesComponent.updateTable(list);
    }

    static /* synthetic */ Timer access$6(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.timerToSynchronize;
    }

    static /* synthetic */ String access$7(RegattaRaceStatesComponent regattaRaceStatesComponent, RegattaOverviewEntryDTO regattaOverviewEntryDTO) {
        return regattaRaceStatesComponent.createRaceLink(regattaOverviewEntryDTO);
    }

    static /* synthetic */ String access$8(RegattaRaceStatesComponent regattaRaceStatesComponent, Date date) {
        return regattaRaceStatesComponent.formatTime(date);
    }

    static /* synthetic */ RaceStateFlagsInterpreter access$9(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.flagInterpreter;
    }

    static /* synthetic */ EntryHandler access$10(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.entryClickedHandler;
    }

    static /* synthetic */ StringMessages access$11(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.stringMessages;
    }

    static /* synthetic */ long access$12(RegattaRaceStatesComponent regattaRaceStatesComponent, Date date) {
        return regattaRaceStatesComponent.timePassedInSeconds(date);
    }

    static /* synthetic */ DateTimeFormat access$13(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.timeFormatter;
    }

    static /* synthetic */ String access$14(RegattaRaceStatesComponent regattaRaceStatesComponent, Duration duration) {
        return regattaRaceStatesComponent.formatDuration(duration);
    }

    static /* synthetic */ TextColumn access$15(RegattaRaceStatesComponent regattaRaceStatesComponent) {
        return regattaRaceStatesComponent.raceAdditionalInformationColumn;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sap$sailing$domain$common$PassingInstruction() {
        if ($SWITCH_TABLE$com$sap$sailing$domain$common$PassingInstruction != null) {
            return $SWITCH_TABLE$com$sap$sailing$domain$common$PassingInstruction;
        }
        int[] nArray = new int[PassingInstruction.values().length];
        try {
            nArray[PassingInstruction.FixedBearing.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Gate.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Line.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.None.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Offset.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Port.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Single_Unknown.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PassingInstruction.Starboard.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sap$sailing$domain$common$PassingInstruction = nArray;
        return nArray;
    }
}

