/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.shared.refresh;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchSystem;
import com.sap.sailing.gwt.home.shared.refresh.ActionProvider;
import com.sap.sailing.gwt.home.shared.refresh.RefreshManager;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import com.sap.sse.gwt.dispatch.shared.commands.DTO;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RefreshManager {
    private static final Logger LOG = Logger.getLogger(RefreshManager.class.getName());
    private static final long PAUSE_ON_ERROR = Duration.ONE_SECOND.times(30L).asMillis();
    private List<RefreshHolder<DTO, SailingAction<ResultWithTTL<DTO>>>> refreshables = new ArrayList();
    private boolean scheduled;
    private final Timer timer = new /* Unavailable Anonymous Inner Class!! */;
    private final SailingDispatchSystem actionExecutor;
    boolean started = false;

    public RefreshManager(SailingDispatchSystem actionExecutor) {
        this.actionExecutor = actionExecutor;
    }

    protected void start() {
        LOG.log(Level.FINE, "Starting auto refresh");
        this.started = true;
        this.reschedule();
    }

    protected void cancel() {
        LOG.log(Level.FINE, "Cancelling auto refresh");
        this.started = false;
        this.timer.cancel();
    }

    protected abstract boolean canExecute();

    protected void onSuccessfulUpdate() {
    }

    protected void onFailedUpdate(Throwable errorCause) {
    }

    private void update() {
        for (RefreshHolder refreshable : this.refreshables) {
            if (!RefreshHolder.access$0((RefreshHolder)refreshable).isActive() || RefreshHolder.access$1((RefreshHolder)refreshable) || RefreshHolder.access$2((RefreshHolder)refreshable) >= System.currentTimeMillis() + ResultWithTTL.MAX_TIME_TO_LOAD_EARLIER.asMillis()) continue;
            RefreshHolder.access$3((RefreshHolder)refreshable, (boolean)true);
            SailingAction action = RefreshHolder.access$0((RefreshHolder)refreshable).getAction();
            this.actionExecutor.execute((Action)action, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void reschedule() {
        if (!this.scheduled) {
            this.scheduled = true;
            Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void forceReschedule() {
        this.scheduled = false;
        this.timer.cancel();
        this.reschedule();
    }

    public <D extends DTO, A extends SailingAction<ResultWithTTL<D>>> void add(RefreshableWidget<? super D> widget, ActionProvider<A> provider) {
        this.refreshables.add(new RefreshHolder(widget, provider));
        this.reschedule();
    }

    public <D extends DTO, A extends SailingAction<ResultWithTTL<D>>> void add(RefreshableWidget<? super D> widget, A action) {
        this.add(widget, (ActionProvider)new ActionProvider.DefaultActionProvider(action));
    }

    public SailingDispatchSystem getDispatchSystem() {
        return this.actionExecutor;
    }

    static /* synthetic */ void access$0(RefreshManager refreshManager) {
        refreshManager.update();
    }

    static /* synthetic */ Logger access$1() {
        return LOG;
    }

    static /* synthetic */ long access$2() {
        return PAUSE_ON_ERROR;
    }

    static /* synthetic */ void access$3(RefreshManager refreshManager) {
        refreshManager.reschedule();
    }

    static /* synthetic */ void access$4(RefreshManager refreshManager, boolean bl) {
        refreshManager.scheduled = bl;
    }

    static /* synthetic */ List access$5(RefreshManager refreshManager) {
        return refreshManager.refreshables;
    }

    static /* synthetic */ Timer access$6(RefreshManager refreshManager) {
        return refreshManager.timer;
    }
}

