/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.RaceContext;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;

@GwtIncompatible
public final class RaceRefreshCalculator
implements EventActionUtil.RaceCallback {
    private long ttl = Duration.ONE_MINUTE.times(3L).asMillis();

    public void doForRace(RaceContext rc) {
        SimpleRaceMetadataDTO.RaceViewState state = rc.getLiveRaceViewState();
        if (state == SimpleRaceMetadataDTO.RaceViewState.RUNNING) {
            this.ttl = Math.min(this.ttl, Duration.ONE_SECOND.times(30L).asMillis());
        } else if (state == SimpleRaceMetadataDTO.RaceViewState.SCHEDULED) {
            int timeTillRace = (int)MillisecondsTimePoint.now().until(rc.getStartTime()).asMillis();
            this.ttl = Math.min(this.ttl, Math.min(Duration.ONE_MINUTE.asMillis(), (long)timeTillRace));
        } else if (state == SimpleRaceMetadataDTO.RaceViewState.POSTPONED || state == SimpleRaceMetadataDTO.RaceViewState.ABANDONED) {
            this.ttl = Math.min(this.ttl, Duration.ONE_MINUTE.asMillis());
        }
    }

    public Duration getTTL() {
        return new MillisecondsDurationImpl(this.ttl);
    }
}

