/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbortingFlagFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.tracking.RaceWindCalculator;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindSummary;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.LiveRaceDTO;
import com.sap.sailing.gwt.home.communication.event.RaceListRaceDTO;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.FlagStateDTO;
import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.RaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.RaceProgressDTO;
import com.sap.sailing.gwt.home.communication.race.SimpleRaceMetadataDTO;
import com.sap.sailing.gwt.home.communication.race.wind.AbstractWindDTO;
import com.sap.sailing.gwt.home.communication.race.wind.SimpleWindDTO;
import com.sap.sailing.gwt.home.communication.race.wind.WindStatisticsDTO;
import com.sap.sailing.gwt.home.server.LeaderboardContext;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaType;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.server.SecurityDTOUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtIncompatible
public class RaceContext {
    private static final Logger logger = Logger.getLogger(RaceContext.class.getName());
    private static final Duration TIME_BEFORE_START_TO_SHOW_RACES_AS_LIVE = Duration.ONE_HOUR;
    private static final Duration TIME_TO_SHOW_CANCELED_RACES_AS_LIVE = Duration.ONE_MINUTE.times(5L);
    private final TimePoint now = MillisecondsTimePoint.now();
    private final LeaderboardContext leaderboardContext;
    private final Leaderboard leaderboard;
    private final RaceColumn raceColumn;
    private final Fleet fleet;
    private final RaceDefinition raceDefinition;
    private final TrackedRace trackedRace;
    private final RaceLog raceLog;
    private final ReadonlyRaceState state;
    private final Event event;
    private final RacingEventService service;
    private TimePoint startTime;
    private boolean startTimeCalculated = false;
    private TimePoint finishTime;
    private boolean finishTimeCalculated = false;
    private SimpleRaceMetadataDTO.RaceViewState raceViewState;

    public RaceContext(RacingEventService service, Event event, LeaderboardContext leaderboardContext, RaceColumn raceColumn, Fleet fleet, RaceLogResolver raceLogResolver) {
        this.service = service;
        this.event = event;
        this.leaderboardContext = leaderboardContext;
        this.leaderboard = leaderboardContext.getLeaderboard();
        this.raceColumn = raceColumn;
        this.raceDefinition = raceColumn.getRaceDefinition(fleet);
        this.fleet = fleet;
        this.trackedRace = raceColumn.getTrackedRace(fleet);
        this.raceLog = raceColumn.getRaceLog(fleet);
        this.state = this.raceLog == null ? null : ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)raceLogResolver, (RaceLog)this.raceLog);
    }

    private boolean isShowFleetData() {
        return !"Default".equals(this.fleet.getName());
    }

    public String getLeaderboardName() {
        return this.leaderboard.getName();
    }

    public String getRegattaName() {
        Regatta regatta = this.getRegatta();
        String result = regatta != null ? regatta.getName() : this.leaderboard.getName();
        return result;
    }

    public Regatta getRegatta() {
        Regatta result = this.leaderboard instanceof RegattaLeaderboard ? ((RegattaLeaderboard)this.leaderboard).getRegatta() : null;
        return result;
    }

    private String getRegattaDisplayName() {
        String displayName = this.leaderboard.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            return displayName;
        }
        return this.leaderboard.getName();
    }

    private FleetMetadataDTO getFleetMetadataOrNull() {
        if (!this.isShowFleetData()) {
            return null;
        }
        return this.getFleetMetadata();
    }

    public FleetMetadataDTO getFleetMetadata() {
        return new FleetMetadataDTO(this.fleet.getName(), this.fleet.getColor() == null ? null : this.fleet.getColor().getAsHtml(), this.fleet.getOrdering());
    }

    private SimpleWindDTO getWindOrNull() {
        Wind wind;
        TimePoint toTimePoint;
        WindWithConfidence averagedWindWithConfidence;
        SimpleWindDTO result = this.trackedRace != null ? ((averagedWindWithConfidence = new RaceWindCalculator().getWindFromTrackedRace(toTimePoint = this.getWindToTimePoint(), this.trackedRace)) != null ? new SimpleWindDTO(Double.valueOf(((Wind)averagedWindWithConfidence.getObject()).getFrom().getDegrees()), Double.valueOf(((Wind)averagedWindWithConfidence.getObject()).getKnots())) : null) : ((wind = new RaceWindCalculator().checkForLatestWindFixFromRaceLog(this.raceLog)) != null ? new SimpleWindDTO(Double.valueOf(wind.getFrom().getDegrees()), Double.valueOf(wind.getKnots())) : null);
        return result;
    }

    private TimePoint getWindToTimePoint() {
        TimePoint newestEvent;
        TimePoint toTimePoint;
        TimePoint finishTime = this.getFinishTime();
        TimePoint timePoint = toTimePoint = finishTime == null ? this.getLiveTimePoint() : finishTime;
        if (this.trackedRace != null && (newestEvent = this.trackedRace.getTimePointOfNewestEvent()) != null && newestEvent.before(toTimePoint)) {
            toTimePoint = newestEvent;
        }
        return toTimePoint;
    }

    private FlagStateDTO getFlagStateOrNull() {
        AbortingFlagFinder abortingFlagFinder;
        RaceLogFlagEvent abortingFlagEvent;
        RaceLogRaceStatus status;
        if (this.raceLog == null) {
            return null;
        }
        TimePoint startTime = this.state.getStartTime();
        Flags lastUpperFlag = null;
        Flags lastLowerFlag = null;
        boolean lastFlagsAreDisplayed = false;
        boolean lastFlagsDisplayedStateChanged = false;
        if (startTime != null) {
            FlagPoleState activeFlagState = this.state.getRacingProcedure().getActiveFlags(startTime, this.now);
            List activeFlags = activeFlagState.getCurrentState();
            FlagPoleState previousFlagState = activeFlagState.getPreviousState(this.state.getRacingProcedure(), startTime);
            List previousFlags = previousFlagState.getCurrentState();
            FlagPole mostInterestingFlagPole = FlagPoleState.getMostInterestingFlagPole((List)previousFlags, (List)activeFlags);
            if (mostInterestingFlagPole != null) {
                lastUpperFlag = mostInterestingFlagPole.getUpperFlag();
                lastLowerFlag = mostInterestingFlagPole.getLowerFlag();
                lastFlagsAreDisplayed = mostInterestingFlagPole.isDisplayed();
                lastFlagsDisplayedStateChanged = previousFlagState.hasPoleChanged(mostInterestingFlagPole);
            }
        }
        if ((status = this.state.getStatus()) == RaceLogRaceStatus.FINISHED) {
            TimeRange protestTime = this.state.getProtestTime();
            if (protestTime != null) {
                lastUpperFlag = Flags.BRAVO;
                lastLowerFlag = Flags.NONE;
                lastFlagsAreDisplayed = true;
                lastFlagsDisplayedStateChanged = true;
            }
        } else if (this.state.getStatus().isAbortingFlagFromPreviousPassValid() && (abortingFlagEvent = (RaceLogFlagEvent)(abortingFlagFinder = new AbortingFlagFinder(this.raceLog)).analyze()) != null) {
            lastUpperFlag = abortingFlagEvent.getUpperFlag();
            lastLowerFlag = abortingFlagEvent.getLowerFlag();
            lastFlagsAreDisplayed = abortingFlagEvent.isDisplayed();
            lastFlagsDisplayedStateChanged = true;
        }
        FlagStateDTO result = lastUpperFlag != null || lastLowerFlag != null ? new FlagStateDTO(lastUpperFlag, lastLowerFlag, lastFlagsAreDisplayed, lastFlagsDisplayedStateChanged) : null;
        return result;
    }

    private String getCourseAreaOrNull() {
        return HomeServiceUtil.getCourseAreaNameForRegattaIfThereIsMoreThanOne((EventBase)this.event, (Leaderboard)this.leaderboard);
    }

    private RaceProgressDTO getProgressOrNull() {
        RaceProgressDTO raceProgress = null;
        if (this.raceDefinition != null && this.raceDefinition.getCourse() != null && this.trackedRace != null) {
            int totalLegsCount = this.raceDefinition.getCourse().getLegs().size();
            int currentLegNo = this.trackedRace.getLastLegStarted(MillisecondsTimePoint.now());
            if (currentLegNo > 0 && totalLegsCount > 0) {
                raceProgress = new RaceProgressDTO(Integer.valueOf(currentLegNo), Integer.valueOf(totalLegsCount));
            }
        }
        return raceProgress;
    }

    private String getCourseNameOrNull() {
        if (this.state == null) {
            return null;
        }
        CourseBase lastCourse = this.state.getCourseDesign();
        if (lastCourse != null) {
            return lastCourse.getName();
        }
        return null;
    }

    public Date getStartTimeAsDate() {
        TimePoint startTime = this.getStartTime();
        return startTime == null ? null : startTime.asDate();
    }

    public TimePoint getStartTime() {
        if (!this.startTimeCalculated) {
            if (this.state != null) {
                this.startTime = this.state.getStartTime();
            }
            if (this.startTime == null && this.trackedRace != null) {
                this.startTime = this.trackedRace.getStartOfRace();
            }
            this.startTimeCalculated = true;
        }
        return this.startTime;
    }

    private TimePoint getFinishTime() {
        if (!this.finishTimeCalculated) {
            if (this.state != null) {
                this.finishTime = this.state.getFinishedTime();
            }
            if (this.finishTime == null && this.trackedRace != null) {
                this.finishTime = this.trackedRace.getEndOfRace();
            }
            this.finishTimeCalculated = true;
        }
        return this.finishTime;
    }

    public LiveRaceDTO getLiveRaceOrNull() {
        if (this.isLiveOrOfPublicInterest()) {
            LiveRaceDTO liveRaceDTO = new LiveRaceDTO(this.getLeaderboardName(), this.getRaceIdentifierOrNull(), this.getRaceName());
            this.fillRaceMetadata((RaceMetadataDTO)liveRaceDTO);
            liveRaceDTO.setFlagState(this.getFlagStateOrNull());
            liveRaceDTO.setProgress(this.getProgressOrNull());
            liveRaceDTO.setWind((AbstractWindDTO)this.getWindOrNull());
            if (this.getRaceIdentifierOrNull() != null) {
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.service.getSecurityService(), (SecuredDTO)liveRaceDTO);
            }
            return liveRaceDTO;
        }
        return null;
    }

    public RaceListRaceDTO getFinishedRaceOrNull() {
        if (this.getLiveRaceViewState() == SimpleRaceMetadataDTO.RaceViewState.FINISHED && !this.isLiveOrOfPublicInterest()) {
            RaceListRaceDTO raceListRaceDTO = new RaceListRaceDTO(this.getLeaderboardName(), this.getRaceIdentifierOrNull(), this.getRaceName());
            this.fillRaceMetadata((RaceMetadataDTO)raceListRaceDTO);
            raceListRaceDTO.setDuration(this.getDurationOrNull());
            raceListRaceDTO.setWinner(this.getWinnerOrNull());
            raceListRaceDTO.setWindSourcesCount(this.getWindSourceCount());
            raceListRaceDTO.setVideoCount(this.getVideoCount());
            raceListRaceDTO.setAudioCount(this.getAudioCount());
            WindSummary windSummary = new RaceWindCalculator().getWindSummary(this.trackedRace, this.raceLog);
            WindStatisticsDTO windStatsDTO = windSummary != null ? new WindStatisticsDTO(Double.valueOf(windSummary.getTrueWindDirection().getDegrees()), Double.valueOf(windSummary.getTrueLowerboundWind().getKnots()), Double.valueOf(windSummary.getTrueUpperboundWind().getKnots())) : null;
            raceListRaceDTO.setWind(windStatsDTO);
            if (this.getRaceIdentifierOrNull() != null) {
                SecurityDTOUtil.addSecurityInformation((SecurityService)this.service.getSecurityService(), (SecuredDTO)raceListRaceDTO);
            }
            return raceListRaceDTO;
        }
        return null;
    }

    public SimpleRaceMetadataDTO getRaceCompetitionFormat() {
        SimpleRaceMetadataDTO raceDTO = new SimpleRaceMetadataDTO(this.getLeaderboardName(), this.getRaceIdentifierOrNull(), this.getRaceName());
        this.fillSimpleRaceMetadata(raceDTO);
        if (this.getRaceIdentifierOrNull() != null) {
            SecurityDTOUtil.addSecurityInformation((SecurityService)this.service.getSecurityService(), (SecuredDTO)raceDTO);
        }
        return raceDTO;
    }

    private int getAudioCount() {
        return this.getMediaCount(MediaType.audio);
    }

    private int getVideoCount() {
        return this.getMediaCount(MediaType.video);
    }

    private int getMediaCount(MediaType mediaType) {
        int mediaCount = 0;
        if (this.trackedRace != null) {
            for (MediaTrack mediaTrack : this.service.getMediaTracksForRace(this.trackedRace.getRaceIdentifier())) {
                if (mediaTrack.mimeType == null || mediaTrack.mimeType.mediaType != mediaType) continue;
                ++mediaCount;
            }
        }
        return mediaCount;
    }

    private int getWindSourceCount() {
        if (this.trackedRace != null) {
            return Util.size((Iterable)this.trackedRace.getWindSources(WindSourceType.EXPEDITION));
        }
        return 0;
    }

    TimePoint getLiveTimePoint() {
        TimePoint liveTimePoint;
        if (this.trackedRace != null) {
            liveTimePoint = MillisecondsTimePoint.now().minus(this.trackedRace.getDelayToLiveInMillis());
        } else {
            Long liveDelay = this.leaderboard.getDelayToLiveInMillis();
            long liveTimePointInMillis = System.currentTimeMillis() - (liveDelay == null ? 0L : liveDelay);
            liveTimePoint = new MillisecondsTimePoint(liveTimePointInMillis);
        }
        return liveTimePoint;
    }

    private SimpleCompetitorDTO getWinnerOrNull() {
        Iterable competitors;
        block6: {
            if (this.getLiveRaceViewState() != SimpleRaceMetadataDTO.RaceViewState.FINISHED) {
                return null;
            }
            TimePoint finishTime = this.getLiveTimePoint();
            competitors = this.leaderboard.getCompetitorsFromBestToWorst(this.raceColumn, finishTime);
            if (competitors != null && !Util.isEmpty((Iterable)competitors)) break block6;
            return null;
        }
        try {
            if (Util.size((Iterable)this.raceColumn.getFleets()) == 1) {
                return new SimpleCompetitorDTO((Competitor)competitors.iterator().next());
            }
            for (Competitor competitor : competitors) {
                if (!this.isCompetitorInFleet(competitor)) continue;
                return new SimpleCompetitorDTO(competitor);
            }
        }
        catch (NoWindException e) {
            logger.log(Level.WARNING, "Error while calculating winner for race.", e);
        }
        return null;
    }

    private Duration getDurationOrNull() {
        TimePoint startTime = this.getStartTime();
        TimePoint finishTime = this.getFinishTime();
        if (startTime != null && finishTime != null) {
            return startTime.until(finishTime);
        }
        return null;
    }

    private void fillSimpleRaceMetadata(SimpleRaceMetadataDTO dto) {
        Iterable leaderboardGroupNames = this.leaderboardContext.getLeaderboardGroupNames();
        dto.setLeaderboardGroupName(leaderboardGroupNames == null || Util.isEmpty((Iterable)leaderboardGroupNames) ? null : (String)leaderboardGroupNames.iterator().next());
        Iterable leaderboardGroupIds = this.leaderboardContext.getLeaderboardGroupIds();
        dto.setLeaderboardGroupId(leaderboardGroupIds == null || Util.isEmpty((Iterable)leaderboardGroupIds) ? null : (UUID)leaderboardGroupIds.iterator().next());
        dto.setStart(this.getStartTimeAsDate());
        dto.setViewState(this.getLiveRaceViewState());
        dto.setTrackingState(this.getRaceTrackingState());
        dto.setCompetitors(this.getCompetitors());
    }

    private void fillRaceMetadata(RaceMetadataDTO<?> dto) {
        this.fillSimpleRaceMetadata(dto);
        dto.setRegattaDisplayName(this.getRegattaDisplayName());
        dto.setFleet(this.getFleetMetadataOrNull());
        dto.setBoatClass(HomeServiceUtil.getBoatClassName((Leaderboard)this.leaderboard));
        dto.setCourseArea(this.getCourseAreaOrNull());
        dto.setCourse(this.getCourseNameOrNull());
    }

    public boolean isLiveOrOfPublicInterest() {
        if (HomeServiceUtil.calculateEventState((EventBase)this.event) == EventState.FINISHED) {
            return false;
        }
        boolean isLive = false;
        boolean isOfPublicInterest = false;
        if (this.trackedRace != null) {
            isLive = this.trackedRace.isLive(this.now);
        }
        if (!isLive) {
            TimePoint abortingTimeInPassBefore;
            RaceLogFlagEvent abortingFlagEvent;
            TimePoint startTime = this.getStartTime();
            if (startTime != null) {
                TimePoint endOfLivePeriod;
                TimePoint finishTime = this.getFinishTime();
                TimePoint startOfLivePeriod = startTime.minus(TIME_BEFORE_START_TO_SHOW_RACES_AS_LIVE);
                TimePoint timePoint = endOfLivePeriod = finishTime != null ? finishTime.plus(180000L) : null;
                if (this.now.after(startOfLivePeriod) && (endOfLivePeriod == null || this.now.before(endOfLivePeriod))) {
                    isOfPublicInterest = true;
                }
            } else if (this.raceLog != null && (abortingFlagEvent = this.checkForAbortFlagEvent()) != null && (abortingTimeInPassBefore = abortingFlagEvent.getLogicalTimePoint()).until(this.now).compareTo((Object)TIME_TO_SHOW_CANCELED_RACES_AS_LIVE) < 0) {
                isOfPublicInterest = true;
            }
        }
        return isLive || isOfPublicInterest;
    }

    public SimpleRaceMetadataDTO.RaceTrackingState getRaceTrackingState() {
        SimpleRaceMetadataDTO.RaceTrackingState trackingState = SimpleRaceMetadataDTO.RaceTrackingState.NOT_TRACKED;
        if (this.trackedRace != null) {
            trackingState = SimpleRaceMetadataDTO.RaceTrackingState.TRACKED_NO_VALID_DATA;
            if (this.trackedRace.hasGPSData()) {
                trackingState = SimpleRaceMetadataDTO.RaceTrackingState.TRACKED_VALID_DATA;
            }
        }
        return trackingState;
    }

    public SimpleRaceMetadataDTO.RaceViewState getLiveRaceViewState() {
        if (this.raceViewState == null) {
            this.raceViewState = this.calculateRaceViewState();
        }
        return this.raceViewState;
    }

    private SimpleRaceMetadataDTO.RaceViewState calculateRaceViewState() {
        RaceLogFlagEvent abortingFlagEvent;
        TimePoint startTime = this.getStartTime();
        TimePoint finishTime = this.getFinishTime();
        if (startTime != null && this.now.before(startTime)) {
            return SimpleRaceMetadataDTO.RaceViewState.SCHEDULED;
        }
        if (this.state != null && this.state.getStatus() == RaceLogRaceStatus.FINISHING) {
            return SimpleRaceMetadataDTO.RaceViewState.FINISHING;
        }
        if (finishTime != null && this.now.after(finishTime)) {
            return SimpleRaceMetadataDTO.RaceViewState.FINISHED;
        }
        if (this.raceLog != null && (abortingFlagEvent = this.checkForAbortFlagEvent()) != null) {
            Flags upperFlag = abortingFlagEvent.getUpperFlag();
            if (upperFlag.equals((Object)Flags.AP)) {
                return SimpleRaceMetadataDTO.RaceViewState.POSTPONED;
            }
            if (upperFlag.equals((Object)Flags.NOVEMBER)) {
                return SimpleRaceMetadataDTO.RaceViewState.ABANDONED;
            }
            if (upperFlag.equals((Object)Flags.FIRSTSUBSTITUTE)) {
                return SimpleRaceMetadataDTO.RaceViewState.ABANDONED;
            }
        }
        SettableScoreCorrection scoreCorrection = this.leaderboard.getScoreCorrection();
        if (this.trackedRace == null && scoreCorrection != null && scoreCorrection.hasCorrectionForNonTrackedFleet(this.raceColumn)) {
            return SimpleRaceMetadataDTO.RaceViewState.FINISHED;
        }
        if (startTime != null) {
            return SimpleRaceMetadataDTO.RaceViewState.RUNNING;
        }
        return SimpleRaceMetadataDTO.RaceViewState.PLANNED;
    }

    private RaceLogFlagEvent checkForAbortFlagEvent() {
        RaceLogRaceStatus lastStatus;
        AbortingFlagFinder abortingFlagFinder;
        RaceLogFlagEvent abortingFlagEvent;
        RaceLogFlagEvent result = null;
        if (this.raceLog != null && (abortingFlagEvent = (RaceLogFlagEvent)(abortingFlagFinder = new AbortingFlagFinder(this.raceLog)).analyze()) != null && (lastStatus = this.state.getStatus()).isAbortingFlagFromPreviousPassValid()) {
            result = abortingFlagEvent;
        }
        return result;
    }

    public String getStageText() {
        return String.valueOf(this.getRegattaDisplayName()) + " - " + this.raceColumn.getName();
    }

    public RegattaAndRaceIdentifier getRaceIdentifierOrNull() {
        return this.trackedRace == null ? null : this.trackedRace.getRaceIdentifier();
    }

    public String getSeriesName() {
        if (this.raceColumn instanceof RaceColumnInSeries) {
            return ((RaceColumnInSeries)this.raceColumn).getSeries().getName();
        }
        return "";
    }

    public String getRaceName() {
        return this.raceColumn.getName();
    }

    public String getFleetName() {
        return this.fleet.getName();
    }

    public boolean isFinished() {
        return this.getLiveRaceViewState() == SimpleRaceMetadataDTO.RaceViewState.FINISHED;
    }

    public boolean isLive() {
        return this.getLiveRaceViewState() == SimpleRaceMetadataDTO.RaceViewState.RUNNING || this.getLiveRaceViewState() == SimpleRaceMetadataDTO.RaceViewState.FINISHING;
    }

    public Collection<SimpleCompetitorDTO> getCompetitors() {
        HashSet<SimpleCompetitorDTO> compotitorDTOs = new HashSet<SimpleCompetitorDTO>();
        if (this.leaderboardContext.hasMultipleFleets()) {
            boolean isFleetRacing = Util.size((Iterable)this.raceColumn.getFleets()) > 1;
            for (Competitor competitor : this.leaderboard.getCompetitors()) {
                if (isFleetRacing && !this.isCompetitorInFleet(competitor)) continue;
                compotitorDTOs.add(new SimpleCompetitorDTO(competitor));
            }
        }
        return compotitorDTOs;
    }

    private boolean isCompetitorInFleet(Competitor competitor) {
        Fleet fleetOfCompetitor = this.raceColumn.getFleetOfCompetitor(competitor);
        return fleetOfCompetitor != null && Util.equalsWithNull((Object)this.fleet.getName(), (Object)fleetOfCompetitor.getName());
    }

    public RegattaMetadataDTO.RaceDataInfo getRaceDataInfo() {
        boolean hasGPSData = this.getRaceTrackingState() == SimpleRaceMetadataDTO.RaceTrackingState.TRACKED_VALID_DATA;
        boolean hasWindData = this.getWindSourceCount() > 0;
        boolean hasVideo = this.getVideoCount() > 0;
        boolean hasAudioData = this.getAudioCount() > 0;
        return new RegattaMetadataDTO.RaceDataInfo(hasGPSData, hasWindData, hasVideo, hasAudioData);
    }
}

