/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.server;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.LeaderboardContext;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.util.EventUtil;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.dispatch.shared.commands.DTO;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtIncompatible
public final class EventActionUtil {
    private static final Logger logger = Logger.getLogger(LeaderboardCallback.class.getName());

    private EventActionUtil() {
    }

    public static LeaderboardContext getOverallLeaderboardContext(SailingDispatchContext context, UUID eventId) {
        RacingEventService service = context.getRacingEventService();
        Event event = service.getEvent((Serializable)eventId);
        if (!EventUtil.isFakeSeries((EventBase)event)) {
            throw new DispatchException("The given event is not a series event.");
        }
        Leaderboard overallLeaderboard = null;
        for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
            overallLeaderboard = leaderboardGroup.getOverallLeaderboard();
            if (overallLeaderboard != null) break;
        }
        return new LeaderboardContext(context, event, event.getLeaderboardGroups(), overallLeaderboard);
    }

    public static LeaderboardContext getLeaderboardContextWithReadPermissions(SailingDispatchContext context, UUID eventId, String leaderboardId) {
        RacingEventService service = context.getRacingEventService();
        Event event = service.getEvent((Serializable)eventId);
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        LinkedHashSet<LeaderboardGroup> leaderboardGroups = new LinkedHashSet<LeaderboardGroup>();
        Leaderboard leaderboard = null;
        for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
            if (!context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup)) continue;
            for (Leaderboard l : leaderboardGroup.getLeaderboards()) {
                if (!context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)l) || !l.getName().equals(leaderboardId)) continue;
                leaderboardGroups.add(leaderboardGroup);
                leaderboard = l;
            }
        }
        if (leaderboardGroups.isEmpty()) {
            throw new DispatchException("The leaderboard '" + leaderboardId + "' is not part of the given event '" + eventId + "'.");
        }
        return new LeaderboardContext(context, event, leaderboardGroups, leaderboard);
    }

    public static Duration getEventStateDependentTTL(SailingDispatchContext context, UUID eventId, Duration liveTTL) {
        Event event = context.getRacingEventService().getEvent((Serializable)eventId);
        return EventActionUtil.getEventStateDependentTTL((Event)event, (Duration)liveTTL);
    }

    private static Duration getEventStateDependentTTL(Event event, Duration liveTTL) {
        EventState eventState = HomeServiceUtil.calculateEventState((EventBase)event);
        if (eventState == EventState.RUNNING) {
            return liveTTL;
        }
        return EventActionUtil.calculateTtlForNonLiveEvent((Event)event, (EventState)eventState);
    }

    public static <T extends DTO> ResultWithTTL<T> withLiveRaceOrDefaultScheduleWithReadPermissions(SailingDispatchContext context, UUID eventId, CalculationWithEvent<T> callback) {
        return EventActionUtil.withLiveRaceOrDefaultScheduleWithReadPermissions((SailingDispatchContext)context, (UUID)eventId, callback, null);
    }

    public static <T extends DTO> ResultWithTTL<T> withLiveRaceOrDefaultScheduleWithReadPermissions(SailingDispatchContext context, UUID eventId, CalculationWithEvent<T> callback, T defaultResult) {
        Event event = context.getRacingEventService().getEvent((Serializable)eventId);
        if (event == null) {
            logger.warning("Event with ID " + eventId + " not found.");
            return new ResultWithTTL(Duration.FOREVER, defaultResult);
        }
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)event);
        EventState eventState = HomeServiceUtil.calculateEventState((EventBase)event);
        if (eventState == EventState.FINISHED) {
            return new ResultWithTTL(EventActionUtil.calculateTtlForNonLiveEvent((Event)event, (EventState)eventState), defaultResult);
        }
        return callback.calculateWithEvent(event);
    }

    public static Duration calculateTtlForNonLiveEvent(Event event, EventState eventState) {
        if (eventState == EventState.UPCOMING || eventState == EventState.PLANNED) {
            long ttl = Duration.ONE_HOUR.asMillis();
            TimePoint startDate = event.getStartDate();
            if (startDate != null) {
                Duration tillStart = MillisecondsTimePoint.now().until(startDate);
                double hoursTillStart = tillStart.asHours();
                if (hoursTillStart < 36.0) {
                    ttl = Duration.ONE_MINUTE.times(30L).asMillis();
                }
                if (hoursTillStart < 3.0) {
                    ttl = Duration.ONE_MINUTE.times(15L).asMillis();
                }
                ttl = Math.min(ttl, tillStart.asMillis());
            }
            return new MillisecondsDurationImpl(ttl);
        }
        if (eventState == EventState.FINISHED) {
            return Duration.ONE_HOUR.times(12L);
        }
        return Duration.NULL;
    }

    public static void forLeaderboardsOfEventWithReadPermissions(SailingDispatchContext context, UUID eventId, LeaderboardCallback callback) {
        RacingEventService service = context.getRacingEventService();
        Event event = service.getEvent((Serializable)eventId);
        if (event == null) {
            throw new RuntimeException("Event not found");
        }
        EventActionUtil.forLeaderboardsOfEventWithReadPermissions((SailingDispatchContext)context, (Event)event, (LeaderboardCallback)callback);
    }

    public static void forLeaderboardsOfEventWithReadPermissions(SailingDispatchContext context, Event event, LeaderboardCallback callback) {
        HashMap<Leaderboard, LinkedHashSet<LeaderboardGroup>> leaderboardGroupsForLeaderboard = new HashMap<Leaderboard, LinkedHashSet<LeaderboardGroup>>();
        for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
            if (!context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup)) continue;
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (leaderboard instanceof RegattaLeaderboard && !context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)leaderboard).getRegatta()) || !context.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) continue;
                LinkedHashSet<LeaderboardGroup> set = (LinkedHashSet<LeaderboardGroup>)leaderboardGroupsForLeaderboard.get(leaderboard);
                if (set == null) {
                    set = new LinkedHashSet<LeaderboardGroup>();
                    leaderboardGroupsForLeaderboard.put(leaderboard, set);
                }
                set.add(leaderboardGroup);
            }
        }
        for (Map.Entry entry : leaderboardGroupsForLeaderboard.entrySet()) {
            LeaderboardGroup singleLeaderboardGroup;
            Set leaderboardGroupsForRegatta = (Set)entry.getValue();
            LeaderboardContext leaderboardContext = new LeaderboardContext(context, event, (Iterable)entry.getValue(), (Leaderboard)entry.getKey());
            if (leaderboardGroupsForRegatta.size() == 1 && (singleLeaderboardGroup = (LeaderboardGroup)leaderboardGroupsForRegatta.iterator().next()).hasOverallLeaderboard() && !leaderboardContext.isPartOfEvent()) continue;
            callback.doForLeaderboard(leaderboardContext);
        }
    }

    public static void forRacesOfEventWithReadPermissions(SailingDispatchContext context, UUID eventId, RaceCallback callback) {
        EventActionUtil.forLeaderboardsOfEventWithReadPermissions((SailingDispatchContext)context, (UUID)eventId, (LeaderboardCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static void forRacesOfRegattaWithReadPermissions(SailingDispatchContext context, UUID eventId, String regattaName, RaceCallback callback) {
        EventActionUtil.getLeaderboardContextWithReadPermissions((SailingDispatchContext)context, (UUID)eventId, (String)regattaName).forRacesWithReadPermissions(callback);
    }
}

