/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.series;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasAttachHandlers;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.GetSeriesStatisticsAction;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniOverallLeaderbordAction;
import com.sap.sailing.gwt.home.communication.fakeseries.EventSeriesViewDTO;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBox;
import com.sap.sailing.gwt.home.mobile.partials.quickfinder.Quickfinder;
import com.sap.sailing.gwt.home.mobile.partials.recents.EventsOverviewRecentYearEvent;
import com.sap.sailing.gwt.home.mobile.partials.seriesheader.SeriesHeader;
import com.sap.sailing.gwt.home.mobile.partials.statisticsBox.MobileStatisticsBoxView;
import com.sap.sailing.gwt.home.mobile.places.QuickfinderPresenter;
import com.sap.sailing.gwt.home.mobile.places.SeriesLeaderboardNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.series.SeriesView;
import com.sap.sailing.gwt.home.mobile.places.series.SeriesViewImpl;
import com.sap.sailing.gwt.home.shared.partials.statistics.EventStatisticsBox;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.home.shared.refresh.LifecycleRefreshManager;
import com.sap.sailing.gwt.home.shared.refresh.RefreshManager;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.Collection;

public class SeriesViewImpl
extends Composite
implements SeriesView {
    private static final StringMessages MSG = StringMessages.INSTANCE;
    private static StartPageViewUiBinder uiBinder = (StartPageViewUiBinder)GWT.create(StartPageViewUiBinder.class);
    @UiField(provided=true)
    SeriesHeader eventHeaderUi;
    @UiField
    Quickfinder quickFinderUi;
    @UiField(provided=true)
    MinileaderboardBox leaderboardUi;
    @UiField
    FlowPanel eventsUi;
    @UiField(provided=true)
    EventStatisticsBox statisticsBoxUi;
    private final SeriesView.Presenter currentPresenter;
    private final RefreshManager refreshManager;

    public SeriesViewImpl(SeriesView.Presenter presenter, FlagImageResolver flagImageResolver) {
        this.currentPresenter = presenter;
        this.refreshManager = new LifecycleRefreshManager((HasAttachHandlers)this, this.currentPresenter.getDispatch());
        EventSeriesViewDTO series = this.currentPresenter.getSeriesDTO();
        this.eventHeaderUi = new SeriesHeader(this.currentPresenter.getCtx(), series);
        this.setupStatisticsBox(series);
        this.leaderboardUi = new MinileaderboardBox(true, flagImageResolver);
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setupListContent(series);
        this.setupEventListContent(series);
    }

    private void setupEventListContent(EventSeriesViewDTO series) {
        boolean first = true;
        for (EventMetadataDTO eventOfSeries : series.getEventsDescending()) {
            if (eventOfSeries.getState() == EventState.PLANNED) continue;
            boolean teaser = first || eventOfSeries.getState() == EventState.UPCOMING || eventOfSeries.getState() == EventState.RUNNING;
            EventsOverviewRecentYearEvent eventTeaser = new EventsOverviewRecentYearEvent(this.currentPresenter.getEventNavigation(eventOfSeries.getId().toString()), eventOfSeries, eventOfSeries.getState().getStateMarker(), teaser);
            this.eventsUi.add((Widget)eventTeaser);
            first = false;
        }
    }

    public void setQuickFinderValues(String seriesName, Collection<EventAndLeaderboardReferenceWithStateDTO> eventsOfSeries) {
        QuickfinderPresenter.getForSeriesLeaderboards((Quickfinder)this.quickFinderUi, (String)seriesName, (SeriesLeaderboardNavigationProvider)this.currentPresenter, eventsOfSeries);
    }

    private void setupListContent(EventSeriesViewDTO event) {
        this.leaderboardUi.setAction(MSG.showAll(), this.currentPresenter.getMiniOverallLeaderboardNavigation());
        this.refreshManager.add((RefreshableWidget)this.leaderboardUi, (SailingAction)new GetMiniOverallLeaderbordAction(event.getLeaderboardGroupUUID(), event.getLeaderboardId(), 3));
    }

    private void setupStatisticsBox(EventSeriesViewDTO series) {
        this.statisticsBoxUi = new EventStatisticsBox(true, (StatisticsBoxView)new MobileStatisticsBoxView());
        this.refreshManager.add((RefreshableWidget)this.statisticsBoxUi, (SailingAction)new GetSeriesStatisticsAction(series.getLeaderboardGroupUUID()));
    }
}

