/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.event.overview.regatta;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.GetLiveRacesForRegattaAction;
import com.sap.sailing.gwt.home.communication.event.GetRegattaWithProgressAction;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderboardDTO;
import com.sap.sailing.gwt.home.communication.event.minileaderboard.GetMiniLeaderbordAction;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.mobile.partials.eventsteps.EventSteps;
import com.sap.sailing.gwt.home.mobile.partials.liveraces.RegattaLiveRaces;
import com.sap.sailing.gwt.home.mobile.partials.minileaderboard.MinileaderboardBox;
import com.sap.sailing.gwt.home.mobile.partials.quickfinder.Quickfinder;
import com.sap.sailing.gwt.home.mobile.places.QuickfinderPresenter;
import com.sap.sailing.gwt.home.mobile.places.RegattaOverviewNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.SeriesEventLeaderboardOverviewNavigationProvider;
import com.sap.sailing.gwt.home.mobile.places.event.EventViewBase;
import com.sap.sailing.gwt.home.mobile.places.event.overview.AbstractEventOverview;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RegattaOverviewImpl
extends AbstractEventOverview {
    private static final StringMessages MSG = StringMessages.INSTANCE;
    private EventSteps eventStepsUi;
    private RegattaLiveRaces liveRacesUi;
    private final FlagImageResolver flagImageResolver;

    public RegattaOverviewImpl(EventViewBase.Presenter presenter, FlagImageResolver flagImageResolver) {
        super(presenter, presenter.isMultiRegattaEvent(), presenter.isMultiRegattaEvent());
        this.flagImageResolver = flagImageResolver;
        FlowPanel container = new FlowPanel();
        if (presenter.getRegatta() != null) {
            this.setupProgress((Panel)container);
            this.setupLiveRaces((Panel)container);
        }
        this.setupMiniLeaderboard((Panel)container);
        this.initRacesNavigation((Panel)container);
        if (!this.isMultiRegattaEvent()) {
            this.setupOverviewStage((Panel)container);
            this.setupEventDescription((Panel)container);
        }
        if (!this.isMultiRegattaEvent()) {
            this.setupUpdateBox((Panel)container);
            this.setupImpressions((Panel)container);
        }
        this.setupStatisticsBox((Panel)container, true);
        this.setViewContent((Widget)container);
    }

    private void setupProgress(Panel container) {
        Function<String, PlaceNavigation> racesNavigationFactory = prefSeriesName -> this.currentPresenter.getRegattaRacesNavigation(this.getRegattaId(), prefSeriesName);
        this.eventStepsUi = new EventSteps(this.currentPresenter.getRegatta(), racesNavigationFactory);
        this.refreshManager.add((RefreshableWidget)this.eventStepsUi, (SailingAction)new GetRegattaWithProgressAction(this.getEventId(), this.getRegattaId()));
        container.add((Widget)this.eventStepsUi);
    }

    private void setupLiveRaces(Panel container) {
        this.liveRacesUi = new RegattaLiveRaces(this.currentPresenter);
        this.refreshManager.add((RefreshableWidget)this.liveRacesUi, (SailingAction)new GetLiveRacesForRegattaAction(this.getEventId(), this.getRegattaId()));
        container.add((Widget)this.liveRacesUi);
    }

    private void setupMiniLeaderboard(Panel container) {
        MinileaderboardBox miniLeaderboard = new MinileaderboardBox(false, this.flagImageResolver);
        miniLeaderboard.setAction(MSG.showAll(), this.currentPresenter.getRegattaMiniLeaderboardNavigation(this.getRegattaId()));
        if (this.currentPresenter.getRegatta() != null) {
            this.refreshManager.add((RefreshableWidget)miniLeaderboard, (SailingAction)new GetMiniLeaderbordAction(this.getEventId(), this.getRegattaId(), 3));
        } else {
            miniLeaderboard.setData(new GetMiniLeaderboardDTO());
        }
        container.add((Widget)miniLeaderboard);
    }

    protected void setQuickFinderValues(Quickfinder quickfinder, Map<String, Set<RegattaMetadataDTO>> regattasByLeaderboardGroupName) {
        QuickfinderPresenter.getForRegattaOverview((Quickfinder)quickfinder, (RegattaOverviewNavigationProvider)this.currentPresenter, regattasByLeaderboardGroupName);
    }

    protected void setQuickFinderValues(Quickfinder quickfinder, String seriesName, Collection<EventAndLeaderboardReferenceWithStateDTO> eventsOfSeries) {
        QuickfinderPresenter.getForSeriesEventOverview((Quickfinder)quickfinder, (String)seriesName, (SeriesEventLeaderboardOverviewNavigationProvider)this.currentPresenter, eventsOfSeries);
    }
}

