/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.event.overview;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.event.EventState;
import com.sap.sailing.gwt.home.communication.event.GetRegattaStatisticsAction;
import com.sap.sailing.gwt.home.communication.event.eventoverview.GetEventOverviewStageAction;
import com.sap.sailing.gwt.home.communication.event.news.GetEventOverviewNewsAction;
import com.sap.sailing.gwt.home.communication.event.statistics.GetEventStatisticsAction;
import com.sap.sailing.gwt.home.communication.media.SailingImageDTO;
import com.sap.sailing.gwt.home.mobile.partials.eventdescription.EventDescription;
import com.sap.sailing.gwt.home.mobile.partials.impressions.Impressions;
import com.sap.sailing.gwt.home.mobile.partials.statisticsBox.MobileStatisticsBoxView;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.NewsItemLinkProvider;
import com.sap.sailing.gwt.home.mobile.partials.updatesBox.UpdatesBox;
import com.sap.sailing.gwt.home.mobile.places.event.AbstractEventView;
import com.sap.sailing.gwt.home.mobile.places.event.EventViewBase;
import com.sap.sailing.gwt.home.mobile.places.event.overview.EventOverviewStage;
import com.sap.sailing.gwt.home.shared.partials.statistics.EventStatisticsBox;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.home.shared.refresh.RefreshableWidget;
import java.util.Collection;
import java.util.LinkedHashSet;

public abstract class AbstractEventOverview
extends AbstractEventView<EventViewBase.Presenter> {
    private EventOverviewStage overviewStageUi;
    private UpdatesBox updatesBoxUi;
    private Impressions impressionsUi;
    private EventStatisticsBox statisticsBoxUi;

    public AbstractEventOverview(EventViewBase.Presenter presenter, boolean showRegattaName, boolean enableLogoNavigation) {
        super(presenter, showRegattaName, enableLogoNavigation);
    }

    protected void setupOverviewStage(Panel container) {
        this.overviewStageUi = new EventOverviewStage(this.currentPresenter);
        this.refreshManager.add((RefreshableWidget)this.overviewStageUi, (SailingAction)new GetEventOverviewStageAction(this.getEventId(), true));
        container.add((Widget)this.overviewStageUi);
    }

    protected void setupUpdateBox(Panel container) {
        this.updatesBoxUi = new UpdatesBox((NewsItemLinkProvider)this.currentPresenter, this.refreshManager);
        if (this.currentPresenter.getEventDTO().getState() == EventState.RUNNING) {
            this.refreshManager.add((RefreshableWidget)this.updatesBoxUi, (SailingAction)new GetEventOverviewNewsAction(this.getEventId(), 2));
            container.add((Widget)this.updatesBoxUi);
        }
    }

    protected void setupImpressions(Panel container) {
        this.impressionsUi = new Impressions();
        this.impressionsUi.getElement().getStyle().setDisplay(Style.Display.NONE);
        container.add((Widget)this.impressionsUi);
    }

    protected void setupStatisticsBox(Panel container, boolean forRegattaOnly) {
        this.statisticsBoxUi = new EventStatisticsBox(!forRegattaOnly, (StatisticsBoxView)new MobileStatisticsBoxView());
        this.refreshManager.add((RefreshableWidget)this.statisticsBoxUi, (SailingAction)(forRegattaOnly ? new GetRegattaStatisticsAction(this.getEventId(), this.getRegattaId()) : new GetEventStatisticsAction(this.getEventId())));
        container.add((Widget)this.statisticsBoxUi);
    }

    public void setMediaForImpressions(int nrOfImages, int nrOfVideos, Collection<SailingImageDTO> images) {
        this.impressionsUi.getElement().getStyle().setDisplay(Style.Display.BLOCK);
        this.impressionsUi.setStatistis(nrOfImages, nrOfVideos);
        this.impressionsUi.addImages(new LinkedHashSet<SailingImageDTO>(images));
        this.impressionsUi.setClickDestinaton(this.currentPresenter.getMediaPageNavigation());
    }

    protected void setupEventDescription(Panel container) {
        String description = this.currentPresenter.getEventDTO().getDescription();
        if (description != null) {
            container.add((Widget)new EventDescription(description));
        }
    }
}

