/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.places.event.media;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.media.MediaDTO;
import com.sap.sailing.gwt.home.desktop.partials.media.MediaPageResources;
import com.sap.sailing.gwt.home.mobile.partials.imagegallery.ImageGallery;
import com.sap.sailing.gwt.home.mobile.partials.uploadpopup.MobileMediaUploadPopup;
import com.sap.sailing.gwt.home.mobile.partials.videogallery.VideoGallery;
import com.sap.sailing.gwt.home.mobile.places.event.AbstractEventView;
import com.sap.sailing.gwt.home.mobile.places.event.EventViewBase;
import com.sap.sailing.gwt.home.mobile.places.event.media.MediaView;
import com.sap.sailing.gwt.home.mobile.places.event.media.MediaViewImpl;
import com.sap.sailing.gwt.home.mobile.places.event.media.MediaViewResources;
import com.sap.sailing.gwt.ui.client.SailingServiceHelper;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.ManageMediaModel;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.Collection;
import java.util.logging.Logger;

public class MediaViewImpl
extends AbstractEventView<MediaView.Presenter>
implements MediaView {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private static MediaViewImplUiBinder uiBinder = (MediaViewImplUiBinder)GWT.create(MediaViewImplUiBinder.class);
    @UiField
    Label noContentInfoUi;
    @UiField
    VideoGallery videoGalleryUi;
    @UiField
    ImageGallery imageGalleryUi;
    @UiField
    Button addMediaButtonUi;
    private MobileMediaUploadPopup mobileMediaUploadPopup;
    private final SailingServiceWriteAsync sailingServiceWrite = SailingServiceHelper.createSailingServiceWriteInstance();
    private final UserService userService;
    private final ManageMediaModel manageMediaModel;

    public MediaViewImpl(MediaView.Presenter presenter) {
        super((EventViewBase.Presenter)presenter, false, true, false);
        this.userService = presenter.getUserService();
        StringMessages stringMessages = StringMessages.INSTANCE;
        this.manageMediaModel = new ManageMediaModel(this.sailingServiceWrite, this.userService, presenter.getEventDTO(), stringMessages);
        MediaViewResources.INSTANCE.css().ensureInjected();
        this.setViewContent((Widget)uiBinder.createAndBindUi((Object)this));
        MediaPageResources.INSTANCE.css().ensureInjected();
        this.mobileMediaUploadPopup = new MobileMediaUploadPopup((images, videos) -> this.manageMediaModel.addImagesAndVideos(images, videos, eventDto -> this.updateMedia()));
        this.addMediaButtonUi.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.userService.addUserStatusEventHandler((userDTO, preAuthenticated) -> {
            this.logger.info(userDTO == null ? "Sign out" : "Signed in as " + userDTO.getName());
            this.setMediaManaged(this.manageMediaModel.hasPermissions());
        });
        this.setMediaManaged(this.manageMediaModel.hasPermissions());
    }

    public void setMedia(MediaDTO media) {
        this.manageMediaModel.setMedia(media);
        this.updateMedia();
    }

    public void updateMedia() {
        this.setMediaManaged(this.manageMediaModel.hasPermissions());
        Collection images = this.manageMediaModel.getImages();
        Collection videos = this.manageMediaModel.getVideos();
        this.noContentInfoUi.setVisible(videos.isEmpty() && images.isEmpty());
        this.videoGalleryUi.setVideos(videos, video -> this.deleteVideo(video));
        this.videoGalleryUi.setVisible(!videos.isEmpty());
        this.imageGalleryUi.setImages(images, image -> this.deleteImage(image));
        this.imageGalleryUi.setVisible(!images.isEmpty());
        this.imageGalleryUi.setMediaManaged(false);
        this.videoGalleryUi.setMediaManaged(false);
    }

    private void setMediaManaged(boolean managed) {
        this.logger.info("Set manage media to: " + managed);
        this.addMediaButtonUi.setVisible(managed);
        this.videoGalleryUi.setManageButtonsVisible(managed);
        this.imageGalleryUi.setManageButtonsVisible(managed);
        if (!managed) {
            this.videoGalleryUi.setMediaManaged(managed);
            this.imageGalleryUi.setMediaManaged(managed);
        }
    }

    private void deleteImage(ImageDTO imageDto) {
        this.manageMediaModel.deleteImage(imageDto, eventDto -> this.updateMedia());
    }

    private void deleteVideo(VideoDTO videoDto) {
        this.manageMediaModel.deleteVideo(videoDto, eventDto -> this.updateMedia());
    }

    static /* synthetic */ MobileMediaUploadPopup access$0(MediaViewImpl mediaViewImpl) {
        return mediaViewImpl.mobileMediaUploadPopup;
    }
}

