/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.videogallery;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.mobile.partials.videogallery.VideoGalleryVideo;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.home.shared.partials.videoplayer.VideoPlayer;
import com.sap.sse.gwt.client.DateAndTimeFormatterUtil;
import com.sap.sse.gwt.client.media.VideoDTO;
import java.util.Date;
import java.util.function.Consumer;

public class VideoGalleryVideo
extends Composite {
    private static VideoGalleryVideoUiBinder uiBinder = (VideoGalleryVideoUiBinder)GWT.create(VideoGalleryVideoUiBinder.class);
    private boolean managed;
    private final String videoUrl;
    private final Date videoCreateDate;
    @UiField(provided=true)
    VideoPlayer videoPlayerUi = new VideoPlayer(true, false);
    @UiField
    DivElement videoTitleUi;
    @UiField
    DivElement videoCreateDateUi;
    @UiField
    DivElement overlayUi;
    @UiField
    Button editButtonUi;
    @UiField
    Button deleteButtonUi;

    public VideoGalleryVideo(VideoDTO video, Consumer<VideoDTO> updateVideo) {
        this.videoUrl = video.getSourceRef();
        this.videoCreateDate = video.getCreatedAtDate();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        SharedHomeResources.INSTANCE.sharedHomeCss().ensureInjected();
        this.videoPlayerUi.setVideo(video);
        this.setTextOrRemove(this.videoTitleUi, video.getTitle());
        this.setTextOrRemove(this.videoCreateDateUi, DateAndTimeFormatterUtil.formatDateAndTime((Date)video.getCreatedAtDate()));
        this.overlayUi.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.editButtonUi.setVisible(false);
        this.deleteButtonUi.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setTextOrRemove(DivElement element, String text) {
        if (text == null || text.isEmpty()) {
            element.removeFromParent();
        } else {
            element.setInnerText(text);
        }
    }

    public void manageMedia(boolean manage) {
        this.managed = manage;
        if (this.managed) {
            this.overlayUi.getStyle().setVisibility(Style.Visibility.VISIBLE);
        } else {
            this.overlayUi.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
    }

    public boolean contains(VideoDTO video) {
        return video != null && this.videoUrl.equals(video.getSourceRef()) && this.videoCreateDate.equals(video.getCreatedAtDate());
    }
}

