/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.seriesheader;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.EventAndLeaderboardReferenceWithStateDTO;
import com.sap.sailing.gwt.home.communication.event.HasLogo;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.fakeseries.EventSeriesViewDTO;
import com.sap.sailing.gwt.home.mobile.partials.seriesheader.SeriesHeader;
import com.sap.sailing.gwt.home.mobile.partials.seriesheader.SeriesHeaderResources;
import com.sap.sailing.gwt.home.mobile.partials.sharing.SharingButtons;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.partials.shared.SharingMetadataProvider;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.home.shared.utils.LogoUtil;

public class SeriesHeader
extends Composite {
    private static MyUiBinder uiBinder = (MyUiBinder)GWT.create(MyUiBinder.class);
    @UiField
    SpanElement eventNameUi;
    @UiField
    DivElement eventStateUi;
    @UiField
    AnchorElement eventLogoUi;
    @UiField
    DivElement locationsUi;
    @UiField
    SharingButtons sharingButtons;

    public SeriesHeader(SeriesContext seriesContext, EventSeriesViewDTO series) {
        this(seriesContext, series, null);
    }

    public SeriesHeader(SeriesContext seriesContext, EventSeriesViewDTO series, PlaceNavigation<?> logoNavigation) {
        SeriesHeaderResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.setUiFieldValues(series, logoNavigation);
        this.setupSharing(seriesContext, series);
    }

    private void setUiFieldValues(EventSeriesViewDTO series, PlaceNavigation<?> logoNavigation) {
        LogoUtil.setEventLogo((Element)this.eventLogoUi, (HasLogo)series);
        if (logoNavigation != null) {
            logoNavigation.configureAnchorElement(this.eventLogoUi);
        }
        this.eventNameUi.setInnerText(series.getDisplayName());
        LabelTypeUtil.renderLabelType((Element)this.eventStateUi, (LabelType)series.getState().getStateMarker());
        StringBuilder locationsBuilder = new StringBuilder();
        boolean first = true;
        for (EventAndLeaderboardReferenceWithStateDTO eventOfSeries : series.getEventsAndRegattasOfSeriesAscending()) {
            String location;
            if (!first) {
                locationsBuilder.append(", ");
            }
            if ((location = eventOfSeries.getDisplayName()) == null || location.isEmpty()) continue;
            locationsBuilder.append(location);
            first = false;
        }
        this.locationsUi.setInnerText(locationsBuilder.toString());
    }

    private void setupSharing(SeriesContext seriesContext, EventSeriesViewDTO series) {
        this.sharingButtons.setUp((SharingMetadataProvider)new /* Unavailable Anonymous Inner Class!! */);
    }
}

