/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.mobile.partials.impressions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.mobile.partials.imagegallery.MobileFullscreenGallery;
import com.sap.sailing.gwt.home.mobile.partials.impressions.Impressions;
import com.sap.sailing.gwt.home.mobile.partials.section.MobileSection;
import com.sap.sailing.gwt.home.mobile.partials.sectionHeader.SectionHeaderContent;
import com.sap.sailing.gwt.home.mobile.partials.statisticsBox.StatisticsBoxResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sse.gwt.client.controls.carousel.ImageCarousel;
import com.sap.sse.gwt.client.media.ImageDTO;
import java.util.Collection;

public class Impressions
extends Composite {
    private static MyBinder uiBinder = (MyBinder)GWT.create(MyBinder.class);
    @UiField
    MobileSection mobileSectionUi;
    @UiField
    SectionHeaderContent headerUi;
    @UiField
    StringMessages i18n;

    public Impressions() {
        StatisticsBoxResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void setClickDestinaton(PlaceNavigation<?> placeNavigation) {
        this.headerUi.setClickAction(placeNavigation);
    }

    public void setStatistis(int nrOfImages, int nrOfVideos) {
        StringBuilder sb = new StringBuilder();
        if (nrOfImages > 0) {
            sb.append(this.i18n.photosCount(nrOfImages));
            if (nrOfVideos > 0) {
                sb.append(" | ");
            }
        }
        if (nrOfVideos > 0) {
            sb.append(this.i18n.videosCount(nrOfVideos));
        }
        this.headerUi.setSubtitle(sb.toString());
    }

    public void addImages(Collection<ImageDTO> images) {
        if (images.isEmpty()) {
            return;
        }
        GWT.log((String)("Got " + images.size() + " images"));
        ImageCarousel imageCarousel = new ImageCarousel();
        imageCarousel.registerFullscreenViewer((ImageCarousel.FullscreenViewer)new MobileFullscreenGallery());
        int count = this.addImages(imageCarousel, images);
        if (count > 1) {
            this.mobileSectionUi.clearContent();
            if (count == 2) {
                this.addImages(imageCarousel, images);
            }
            this.mobileSectionUi.addContent((Widget)imageCarousel);
        }
    }

    private int addImages(ImageCarousel<ImageDTO> imageCarousel, Collection<ImageDTO> images) {
        int count = 0;
        for (ImageDTO imageDTO : images) {
            if (imageDTO.getHeightInPx() == null || imageDTO.getWidthInPx() == null) {
                GWT.log((String)"Ignore image without size ");
                continue;
            }
            GWT.log((String)("Adding " + imageDTO.getSourceRef()));
            ++count;
            imageCarousel.addImage(imageDTO);
        }
        return count;
    }
}

