/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.old.competitorcharts;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.home.desktop.partials.old.EventRegattaLeaderboardResources;
import com.sap.sailing.gwt.home.desktop.partials.old.competitorcharts.CompetitorChartsDelegate;
import com.sap.sailing.gwt.home.desktop.partials.old.competitorcharts.OldCompetitorCharts;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiCompetitorLeaderboardChartSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.charts.MultiCompetitorLeaderboardChart;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;

public class OldCompetitorCharts
extends Composite {
    private static OldCompetitorChartsUiBinder uiBinder = (OldCompetitorChartsUiBinder)GWT.create(OldCompetitorChartsUiBinder.class);
    @UiField
    HTMLPanel oldCompetitorChartsPanel;
    @UiField
    ListBox chartTypeSelectionListBox;
    @UiField
    Anchor fullscreenAnchor;
    @UiField
    DivElement competitorSelectionStateUi;
    private final List<DetailType> availableDetailsTypes = new ArrayList();
    private final CompetitorChartsDelegate delegate;
    private MultiCompetitorLeaderboardChart multiCompetitorChart = null;

    public OldCompetitorCharts(CompetitorChartsDelegate delegate) {
        EventRegattaLeaderboardResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.fullscreenAnchor.setTitle(StringMessages.INSTANCE.openFullscreenView());
        this.delegate = delegate;
        this.setupFullscreenDelegate();
    }

    private void setupFullscreenDelegate() {
        if (this.delegate == null) {
            this.fullscreenAnchor.removeFromParent();
            return;
        }
        this.delegate.addCloseHandler((CloseHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.delegate.getChartTypeSelectionControl().addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void synchronizeChartTypeSelection(ListBox from, ListBox to) {
        int selectedIndex = from.getSelectedIndex();
        to.setSelectedIndex(selectedIndex);
    }

    public void setChart(MultiCompetitorLeaderboardChart multiCompetitorChart, List<DetailType> availableDetailsTypes, DetailType initialDetailType) {
        this.multiCompetitorChart = multiCompetitorChart;
        this.availableDetailsTypes.clear();
        this.availableDetailsTypes.addAll(availableDetailsTypes);
        this.fillChartTypeSelectionBox(initialDetailType);
        this.oldCompetitorChartsPanel.add((Widget)multiCompetitorChart);
    }

    private void fillChartTypeSelectionBox(DetailType initialDetailType) {
        this.chartTypeSelectionListBox.clear();
        if (this.delegate != null) {
            this.delegate.getChartTypeSelectionControl().clear();
        }
        int i = 0;
        for (DetailType detailType : this.availableDetailsTypes) {
            String formattedDetailType = DetailTypeFormatter.format((DetailType)detailType);
            this.chartTypeSelectionListBox.addItem(formattedDetailType, detailType.name());
            if (this.delegate != null) {
                this.delegate.getChartTypeSelectionControl().addItem(formattedDetailType, detailType.name());
            }
            if (detailType == initialDetailType) {
                this.chartTypeSelectionListBox.setSelectedIndex(i);
                if (this.delegate != null) {
                    this.delegate.getChartTypeSelectionControl().setSelectedIndex(i);
                }
            }
            ++i;
        }
    }

    @UiHandler(value={"chartTypeSelectionListBox"})
    void chartTypeSelectionChanged(ChangeEvent event) {
        if (this.delegate != null) {
            this.synchronizeChartTypeSelection(this.chartTypeSelectionListBox, this.delegate.getChartTypeSelectionControl());
        }
        this.updateChartType();
    }

    private void updateChartType() {
        DetailType selectedChartDetailType = this.getSelectedChartDetailType();
        this.multiCompetitorChart.updateSettings(new MultiCompetitorLeaderboardChartSettings(selectedChartDetailType));
    }

    @UiHandler(value={"fullscreenAnchor"})
    void fullscreenClicked(ClickEvent event) {
        if (this.multiCompetitorChart != null && this.delegate != null) {
            this.multiCompetitorChart.removeFromParent();
            this.delegate.setCompetitorChart(this.multiCompetitorChart);
        }
    }

    public DetailType getSelectedChartDetailType() {
        DetailType result = null;
        int selectedIndex = this.chartTypeSelectionListBox.getSelectedIndex();
        String selectedDetailType = this.chartTypeSelectionListBox.getValue(selectedIndex);
        for (DetailType detailType : this.availableDetailsTypes) {
            if (!detailType.name().equals(selectedDetailType)) continue;
            result = detailType;
            break;
        }
        return result;
    }

    public void updateSelectionState(CompetitorSelectionProvider competitorSelectionProvider) {
        int selectedCompetitorsCount = Util.size((Iterable)competitorSelectionProvider.getSelectedCompetitors());
        if (selectedCompetitorsCount > 0) {
            int competitorsCount = Util.size((Iterable)competitorSelectionProvider.getAllCompetitors());
            this.competitorSelectionStateUi.getStyle().setVisibility(Style.Visibility.VISIBLE);
            this.competitorSelectionStateUi.setInnerText(String.valueOf(selectedCompetitorsCount) + "/" + competitorsCount + " competitors selected.");
        } else {
            this.competitorSelectionStateUi.getStyle().setVisibility(Style.Visibility.HIDDEN);
        }
    }

    static /* synthetic */ MultiCompetitorLeaderboardChart access$0(OldCompetitorCharts oldCompetitorCharts) {
        return oldCompetitorCharts.multiCompetitorChart;
    }

    static /* synthetic */ CompetitorChartsDelegate access$1(OldCompetitorCharts oldCompetitorCharts) {
        return oldCompetitorCharts.delegate;
    }

    static /* synthetic */ void access$2(OldCompetitorCharts oldCompetitorCharts, ListBox listBox, ListBox listBox2) {
        oldCompetitorCharts.synchronizeChartTypeSelection(listBox, listBox2);
    }

    static /* synthetic */ void access$3(OldCompetitorCharts oldCompetitorCharts) {
        oldCompetitorCharts.updateChartType();
    }
}

