/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.eventsrecent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventSeriesDTO;
import com.sap.sailing.gwt.home.communication.eventlist.EventListYearDTO;
import com.sap.sailing.gwt.home.desktop.app.DesktopPlacesNavigator;
import com.sap.sailing.gwt.home.desktop.partials.eventsrecent.EventsOverviewRecentResources;
import com.sap.sailing.gwt.home.desktop.partials.eventsrecent.EventsOverviewRecentYear;
import com.sap.sailing.gwt.home.desktop.partials.eventsrecent.RecentEventTeaser;
import com.sap.sailing.gwt.home.desktop.partials.statistics.DesktopStatisticsBoxView;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.partials.statistics.StatisticsBoxView;
import com.sap.sailing.gwt.home.shared.partials.statistics.YearStatisticsBox;
import com.sap.sailing.gwt.home.shared.places.fakeseries.SeriesContext;
import com.sap.sailing.gwt.home.shared.utils.CollapseAnimation;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.List;
import java.util.UUID;

public class EventsOverviewRecentYear
extends Composite {
    private static EventsOverviewUiBinder uiBinder = (EventsOverviewUiBinder)GWT.create(EventsOverviewUiBinder.class);
    @UiField
    SpanElement year;
    @UiField
    SpanElement eventsCount;
    @UiField
    FlowPanel recentEventsTeaserPanel;
    @UiField
    DivElement contentDiv;
    @UiField
    HTMLPanel headerDiv;
    @UiField
    StringMessages i18n;
    private boolean isContentVisible;
    private final CollapseAnimation animation;

    public EventsOverviewRecentYear(EventListYearDTO yearDTO, DesktopPlacesNavigator navigator, boolean showInitial) {
        List events = yearDTO.getEvents();
        EventsOverviewRecentResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.year.setInnerText(String.valueOf(yearDTO.getYear()));
        this.eventsCount.setInnerText(this.i18n.eventsCount(yearDTO.getEventCount()));
        for (EventListEventDTO eventDTO : events) {
            PlaceNavigation eventNavigation = navigator.getEventNavigation(eventDTO.getId().toString(), eventDTO.getBaseURL(), eventDTO.isOnRemoteServer());
            RecentEventTeaser recentEvent = new RecentEventTeaser(eventNavigation, (EventMetadataDTO)eventDTO, eventDTO.getState().getListStateMarker());
            EventListEventSeriesDTO eventSeriesData = eventDTO.getEventSeries();
            if (eventSeriesData != null) {
                SeriesContext ctx = SeriesContext.createWithLeaderboardGroupId((UUID)eventSeriesData.getSeriesLeaderboardGroupId());
                String baseUrl = eventDTO.getBaseURL();
                PlaceNavigation seriesNavigation = navigator.getEventSeriesNavigation(ctx, baseUrl, eventDTO.isOnRemoteServer());
                recentEvent.setSeriesInformation(seriesNavigation, eventDTO.getEventSeries());
            }
            this.recentEventsTeaserPanel.add((Widget)recentEvent);
        }
        this.recentEventsTeaserPanel.add((Widget)new YearStatisticsBox((StatisticsBoxView)new DesktopStatisticsBoxView(true, StringMessages.INSTANCE.statisticsFor(Integer.toString(yearDTO.getYear()))), yearDTO));
        this.headerDiv.addDomHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ClickEvent.getType());
        this.isContentVisible = showInitial;
        this.animation = new CollapseAnimation((Element)this.contentDiv, showInitial);
        this.updateAccordionState();
    }

    private void onHeaderCicked() {
        this.isContentVisible = !this.isContentVisible;
        this.updateContentVisibility();
    }

    private void updateContentVisibility() {
        this.animation.animate(this.isContentVisible);
        this.updateAccordionState();
    }

    private void updateAccordionState() {
        if (this.isContentVisible) {
            this.getElement().removeClassName(EventsOverviewRecentResources.INSTANCE.css().accordioncollapsed());
        } else {
            this.getElement().addClassName(EventsOverviewRecentResources.INSTANCE.css().accordioncollapsed());
        }
    }

    static /* synthetic */ void access$0(EventsOverviewRecentYear eventsOverviewRecentYear) {
        eventsOverviewRecentYear.onHeaderCicked();
    }
}

