/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.desktop.partials.event;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.communication.event.EventMetadataDTO;
import com.sap.sailing.gwt.home.communication.event.LabelType;
import com.sap.sailing.gwt.home.communication.eventlist.EventListEventSeriesDTO;
import com.sap.sailing.gwt.home.desktop.partials.event.EventTeaser;
import com.sap.sailing.gwt.home.desktop.partials.event.EventTeaserResources;
import com.sap.sailing.gwt.home.desktop.partials.event.EventTeaserSeriesInfoCorner;
import com.sap.sailing.gwt.home.desktop.utils.LongNamesUtil;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.home.shared.app.PlaceNavigation;
import com.sap.sailing.gwt.home.shared.utils.EventDatesFormatterUtil;
import com.sap.sailing.gwt.home.shared.utils.LabelTypeUtil;
import com.sap.sailing.gwt.ui.client.StringMessages;
import java.util.Date;

public class EventTeaser
extends Composite {
    @UiField
    SpanElement eventName;
    @UiField
    SpanElement venue;
    @UiField
    SpanElement eventDate;
    @UiField
    AnchorElement eventLink;
    @UiField
    DivElement eventImage;
    @UiField
    DivElement eventState;
    private final EventMetadataDTO event;
    private static EventTeaserUiBinder uiBinder = (EventTeaserUiBinder)GWT.create(EventTeaserUiBinder.class);
    private final LabelType labelType;

    public EventTeaser(PlaceNavigation<?> placeNavigation, EventMetadataDTO event, LabelType labelType) {
        this.event = event;
        this.labelType = labelType;
        EventTeaserResources.INSTANCE.css().ensureInjected();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.eventLink.setHref(placeNavigation.getTargetUrl());
        this.ensureDebugId("eventTeaser-" + event.getId());
        Event.sinkEvents((Element)this.eventLink, (int)1);
        Event.setEventListener((Element)this.eventLink, (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateUI();
    }

    private void updateUI() {
        this.eventName.setInnerSafeHtml(LongNamesUtil.breakLongName((String)this.event.getDisplayName()));
        if (this.labelType.isRendered()) {
            LabelTypeUtil.renderLabelType((Element)this.eventState, (LabelType)this.labelType);
        } else {
            this.eventState.removeFromParent();
        }
        this.venue.setInnerText(this.event.getLocationOrVenue());
        this.eventDate.setInnerText(EventDatesFormatterUtil.formatDateRangeWithoutYear((Date)this.event.getStartDate(), (Date)this.event.getEndDate()));
        StringBuilder thumbnailUrlBuilder = new StringBuilder("url('");
        String thumbnailImageUrl = this.event.getThumbnailImageURL();
        if (thumbnailImageUrl == null || thumbnailImageUrl.isEmpty()) {
            thumbnailUrlBuilder.append(SharedHomeResources.INSTANCE.defaultEventPhotoImage().getSafeUri().asString());
        } else {
            thumbnailUrlBuilder.append(UriUtils.fromString((String)thumbnailImageUrl).asString());
        }
        thumbnailUrlBuilder.append("')");
        this.eventImage.getStyle().setBackgroundImage(thumbnailUrlBuilder.toString());
    }

    public void setSeriesInformation(PlaceNavigation<?> seriesNavigation, EventListEventSeriesDTO eventSeries) {
        this.eventImage.appendChild((Node)new EventTeaserSeriesInfoCorner(seriesNavigation, eventSeries).getElement());
        this.eventName.setInnerSafeHtml(LongNamesUtil.breakLongName((String)eventSeries.getSeriesDisplayName()));
        this.venue.setInnerText(StringMessages.INSTANCE.lastEvent(this.event.getLocationOrVenue()));
        this.eventImage.setTitle(StringMessages.INSTANCE.teaserOverallLinkToolTip());
    }

    public void hideImage(boolean hide) {
        if (hide) {
            this.eventImage.getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.eventImage.getStyle().setDisplay(Style.Display.BLOCK);
        }
    }
}

