/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.user.profile.sailorprofile;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.gwt.home.communication.event.SimpleCompetitorWithIdDTO;
import com.sap.sailing.gwt.home.communication.user.profile.domain.SailorProfileDTO;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.preferences.SailorProfilePreference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface SailorProfileConverter {
    @GwtIncompatible
    default public SailorProfileDTO convertSailorProfilePreferenceToDto(SailorProfilePreference pref, CompetitorAndBoatStore store, RacingEventService racingEventService) {
        SailorProfileDTO result = pref == null ? new SailorProfileDTO(true) : new SailorProfileDTO(pref.getUuid(), pref.getName(), (Iterable)this.convertCompetitorsToDTOs(pref.getCompetitors()), new ArrayList(), (Iterable)this.getCorrespondingBoatClassesDTOs(pref.getCompetitors(), store, racingEventService));
        return result;
    }

    @GwtIncompatible
    default public List<SimpleCompetitorWithIdDTO> convertCompetitorsToDTOs(Iterable<Competitor> comps) {
        return StreamSupport.stream(comps.spliterator(), false).filter(c -> c != null).map(c -> new SimpleCompetitorWithIdDTO(c)).collect(Collectors.toList());
    }

    @GwtIncompatible
    default public Set<BoatClassDTO> getCorrespondingBoatClassesDTOs(Iterable<Competitor> comps, CompetitorAndBoatStore store, RacingEventService racingEventService) {
        HashSet<BoatClassDTO> boatclasses = new HashSet<BoatClassDTO>();
        for (Competitor c : comps) {
            if (c == null) continue;
            CompetitorWithBoat cwd = store.getExistingCompetitorWithBoatById(c.getId());
            if (cwd != null && cwd.hasBoat() && cwd.getBoat().getBoatClass() != null) {
                BoatClassDTO dto = this.convertBoatClassToDTO(cwd.getBoat().getBoatClass());
                boatclasses.add(dto);
                continue;
            }
            BoatClass boatclass = this.getBoatClassForCompetitorWithoutBoatClass(racingEventService, c);
            if (boatclass == null) continue;
            boatclasses.add(this.convertBoatClassToDTO(boatclass));
        }
        return boatclasses;
    }

    @GwtIncompatible
    default public BoatClass getBoatClassForCompetitorWithoutBoatClass(RacingEventService racingEventService, Competitor c) {
        for (Event event : racingEventService.getAllEvents()) {
            for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    for (Competitor competitor : leaderboard.getCompetitors()) {
                        if (!competitor.getId().equals(c.getId()) || leaderboard.getBoatClass() == null) continue;
                        return leaderboard.getBoatClass();
                    }
                }
            }
        }
        return null;
    }

    @GwtIncompatible
    default public BoatClassDTO convertBoatClassToDTO(BoatClass bc) {
        return new BoatClassDTO(bc.getName(), bc.getHullLength(), bc.getHullBeam());
    }
}

