/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.search;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.gwt.home.communication.search.SearchResultEventInfoDTO;
import com.sap.sse.gwt.dispatch.shared.commands.DTO;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class SearchResultDTO
implements DTO {
    private String displayName;
    private String leaderboardName;
    private String baseUrl;
    private boolean isOnRemoteServer;
    private TreeSet<SearchResultEventInfoDTO> events = new TreeSet();

    private SearchResultDTO() {
    }

    @GwtIncompatible
    public SearchResultDTO(LeaderboardSearchResultBase hit, URL baseUrl, boolean isOnRemoteServer, Boolean include, Set<UUID> eventIds) {
        this.leaderboardName = hit.getLeaderboard().getName();
        this.displayName = hit.getLeaderboard().getDisplayName() != null ? hit.getLeaderboard().getDisplayName() : (hit.getRegattaName() != null ? hit.getRegattaName() : this.leaderboardName);
        this.baseUrl = baseUrl.toString();
        this.isOnRemoteServer = isOnRemoteServer;
        for (EventBase event : hit.getEvents()) {
            SearchResultEventInfoDTO eventDTO = new SearchResultEventInfoDTO(event);
            if (include == null) {
                this.events.add(eventDTO);
                continue;
            }
            if (eventIds == null) continue;
            if (include.booleanValue() && eventIds.contains((UUID)event.getId())) {
                this.events.add(eventDTO);
                continue;
            }
            if (include.booleanValue() || eventIds.contains((UUID)event.getId())) continue;
            this.events.add(eventDTO);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLeaderboardName() {
        return this.leaderboardName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isOnRemoteServer() {
        return this.isOnRemoteServer;
    }

    public Set<SearchResultEventInfoDTO> getEvents() {
        return this.events;
    }
}

