/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.regatta;

import com.sap.sailing.gwt.home.communication.race.FleetMetadataDTO;
import com.sap.sailing.gwt.home.communication.regatta.RegattaProgressFleetDTO;
import com.sap.sse.gwt.dispatch.shared.commands.DTO;
import java.util.Map;
import java.util.TreeMap;

public class RegattaProgressSeriesDTO
implements DTO {
    private String name;
    private int totalRaceCount;
    private int maxRacesPerFleet;
    private TreeMap<FleetMetadataDTO, RegattaProgressFleetDTO> fleetState = new TreeMap();

    private RegattaProgressSeriesDTO() {
    }

    public RegattaProgressSeriesDTO(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalRaceCount() {
        return this.totalRaceCount;
    }

    public int getMaxRacesPerFleet() {
        return this.maxRacesPerFleet;
    }

    public Map<FleetMetadataDTO, RegattaProgressFleetDTO> getFleetState() {
        return this.fleetState;
    }

    public void addFleet(FleetMetadataDTO fleet, RegattaProgressFleetDTO stats) {
        this.fleetState.put(fleet, stats);
        this.totalRaceCount += stats.getRaceCount();
        this.maxRacesPerFleet = Math.max(this.maxRacesPerFleet, stats.getRaceCount());
    }

    public String[] getFleetNames() {
        String[] fleetNames = new String[this.fleetState.size()];
        int i = 0;
        for (FleetMetadataDTO fleet : this.fleetState.keySet()) {
            fleetNames[i++] = fleet.getFleetName();
        }
        return fleetNames;
    }

    public boolean isCompleted() {
        for (RegattaProgressFleetDTO stats : this.fleetState.values()) {
            if (stats.getRaceCount() == stats.getFinishedRaceCount()) continue;
            return false;
        }
        return !this.fleetState.isEmpty();
    }

    public int getProgressRaceCount() {
        int progressRaceCount = 0;
        for (RegattaProgressFleetDTO stats : this.fleetState.values()) {
            progressRaceCount += stats.getFinishedRaceCount();
        }
        return progressRaceCount;
    }
}

