/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.media;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.EventLinkDTO;
import com.sap.sailing.gwt.home.communication.event.EventReferenceDTO;
import com.sap.sailing.gwt.home.communication.media.MediaDTO;
import com.sap.sailing.gwt.home.communication.media.SailingImageDTO;
import com.sap.sailing.gwt.home.communication.media.SailingVideoDTO;
import com.sap.sailing.gwt.server.HomeServiceUtil;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.exceptions.DispatchException;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import java.io.Serializable;
import java.net.URL;
import java.util.UUID;

public class GetMediaForEventAction
implements SailingAction<MediaDTO>,
IsClientCacheable {
    private UUID eventId;

    private GetMediaForEventAction() {
    }

    public GetMediaForEventAction(UUID eventId) {
        this.eventId = eventId;
    }

    @GwtIncompatible
    public MediaDTO execute(SailingDispatchContext ctx) throws DispatchException {
        Event event = ctx.getRacingEventService().getEvent((Serializable)this.eventId);
        EventLinkDTO eventLink = HomeServiceUtil.convertToEventLinkDTO((EventBase)event, (URL)event.getBaseURL(), (boolean)false, (RacingEventService)ctx.getRacingEventService());
        EventReferenceDTO eventRef = new EventReferenceDTO((EventBase)event);
        String eventName = event.getName();
        MediaDTO media = new MediaDTO();
        for (ImageDescriptor image : HomeServiceUtil.getPhotoGalleryImages((EventBase)event)) {
            SailingImageDTO imageDTO = new SailingImageDTO(eventLink, image.getURL().toString(), image.getCreatedAtDate().asDate());
            imageDTO.setSizeInPx(image.getWidthInPx(), image.getHeightInPx());
            imageDTO.setTitle(image.getTitle() != null ? image.getTitle() : eventName);
            imageDTO.setSubtitle(image.getSubtitle());
            imageDTO.setTags(image.getTags());
            imageDTO.setCopyright(image.getCopyright());
            imageDTO.setLocale(image.getLocale() != null ? image.getLocale().toString() : null);
            media.addPhoto(imageDTO);
        }
        for (VideoDescriptor video : event.getVideos()) {
            MimeType type = video.getMimeType();
            if (!MediaTagConstants.SUPPORTED_VIDEO_TYPES.contains(type)) continue;
            SailingVideoDTO videoDTO = HomeServiceUtil.toSailingVideoDTO((EventReferenceDTO)eventRef, (VideoDescriptor)video);
            media.addVideo(videoDTO);
        }
        return media;
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.eventId);
    }
}

