/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.home.communication.event;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.gwt.home.communication.SailingAction;
import com.sap.sailing.gwt.home.communication.SailingDispatchContext;
import com.sap.sailing.gwt.home.communication.event.LiveRaceDTO;
import com.sap.sailing.gwt.home.communication.event.RegattasAndLiveRacesDTO;
import com.sap.sailing.gwt.home.communication.eventview.RegattaMetadataDTO;
import com.sap.sailing.gwt.home.server.EventActionUtil;
import com.sap.sailing.gwt.home.server.RaceContext;
import com.sap.sailing.gwt.home.server.RaceRefreshCalculator;
import com.sap.sse.gwt.dispatch.shared.caching.IsClientCacheable;
import com.sap.sse.gwt.dispatch.shared.commands.DTO;
import com.sap.sse.gwt.dispatch.shared.commands.ResultWithTTL;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;

public class GetRegattasAndLiveRacesForEventAction
implements SailingAction<ResultWithTTL<RegattasAndLiveRacesDTO>>,
IsClientCacheable {
    private UUID eventId;

    private GetRegattasAndLiveRacesForEventAction() {
    }

    public GetRegattasAndLiveRacesForEventAction(UUID eventId) {
        this.eventId = eventId;
    }

    @GwtIncompatible
    public ResultWithTTL<RegattasAndLiveRacesDTO> execute(SailingDispatchContext context) {
        context.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)context.getRacingEventService().getEvent((Serializable)this.eventId));
        Map regattas = this.mapRegattas(context);
        TreeMap regattasWithRaces = new TreeMap();
        TreeSet regattasWithoutRaces = new TreeSet();
        RaceRefreshCalculator refreshCalculator = new RaceRefreshCalculator();
        EventActionUtil.forRacesOfEventWithReadPermissions((SailingDispatchContext)context, (UUID)this.eventId, raceContent -> {
            Optional<LiveRaceDTO> liveRace = Optional.ofNullable(raceContent.getLiveRaceOrNull());
            liveRace.ifPresent(r -> {
                boolean bl = this.ensureRegatta(raceContent, regattas, (Map)regattasWithRaces).add(r);
            });
            refreshCalculator.doForRace(raceContent);
        });
        regattas.values().stream().filter(regatta -> !regattasWithRaces.containsKey(regatta)).forEach(regattasWithoutRaces::add);
        RegattasAndLiveRacesDTO dto = new RegattasAndLiveRacesDTO(regattasWithRaces, regattasWithoutRaces);
        ResultWithTTL result = new ResultWithTTL(refreshCalculator.getTTL(), (DTO)dto);
        return EventActionUtil.withLiveRaceOrDefaultScheduleWithReadPermissions((SailingDispatchContext)context, (UUID)this.eventId, event -> result, (DTO)dto);
    }

    @GwtIncompatible
    private Map<String, RegattaMetadataDTO> mapRegattas(SailingDispatchContext context) {
        HashMap<String, RegattaMetadataDTO> result = new HashMap<String, RegattaMetadataDTO>();
        EventActionUtil.forLeaderboardsOfEventWithReadPermissions((SailingDispatchContext)context, (UUID)this.eventId, (EventActionUtil.LeaderboardCallback)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    @GwtIncompatible
    protected Set<LiveRaceDTO> ensureRegatta(RaceContext context, Map<String, RegattaMetadataDTO> regattas, Map<RegattaMetadataDTO, TreeSet<LiveRaceDTO>> regattasWithRaces) {
        String regattaName = context.getRegattaName();
        RegattaMetadataDTO regatta = regattas.get(regattaName);
        TreeSet<Object> races = regattasWithRaces.get(regatta);
        if (races == null) {
            races = new TreeSet();
            regattasWithRaces.put(regatta, races);
        }
        return races;
    }

    public void cacheInstanceKey(StringBuilder key) {
        key.append(this.eventId);
    }
}

