/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.preevent;

import com.google.gwt.place.shared.Place;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayClientFactory;
import com.sap.sailing.gwt.autoplay.client.app.AutoPlayPresenterConfigured;
import com.sap.sailing.gwt.autoplay.client.places.screens.preevent.IdlePreEventNextView;
import com.sap.sailing.gwt.autoplay.client.places.screens.preevent.IdlePreEventPlace;
import com.sap.sailing.gwt.home.shared.utils.Countdown;
import com.sap.sailing.gwt.ui.shared.EventDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.gwt.client.media.ImageDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class IdlePreEventPresenterImpl
extends AutoPlayPresenterConfigured<IdlePreEventPlace>
implements IdlePreEventNextView.IdlePreEventNextPresenter,
Countdown.CountdownListener {
    private static final int IMAGE_SWITCH_DELAY = 10000;
    private final IdlePreEventNextView view;
    private Timer updateImage;
    private Timer updateText;
    private Countdown countdown;
    private Date currentStartTime;

    public IdlePreEventPresenterImpl(IdlePreEventPlace place, AutoPlayClientFactory clientFactory, IdlePreEventNextView slide2ViewImpl) {
        super((Place)place, clientFactory);
        this.view = slide2ViewImpl;
    }

    public void startConfigured(AcceptsOneWidget panel) {
        this.updateEventImage();
        this.view.startingWith((IdlePreEventNextView.IdlePreEventNextPresenter)this, panel);
        this.updateImage = new /* Unavailable Anonymous Inner Class!! */;
        this.updateImage.scheduleRepeating(10000);
        this.updateText = new /* Unavailable Anonymous Inner Class!! */;
        this.updateText.scheduleRepeating(1000);
    }

    protected void updateCountdown() {
        EventDTO event = this.getSlideCtx().getEvent();
        if (event.startDate != null) {
            if (!event.startDate.equals(this.currentStartTime)) {
                this.currentStartTime = event.startDate;
                if (this.countdown != null) {
                    this.countdown.cancel();
                }
                this.countdown = new Countdown((TimePoint)new MillisecondsTimePoint(this.currentStartTime), (Countdown.CountdownListener)this);
            }
        } else {
            this.view.setStartIn(null);
        }
    }

    public void onStop() {
        super.onStop();
        this.updateImage.cancel();
        this.updateText.cancel();
        this.countdown.cancel();
    }

    protected void updateEventImage() {
        ArrayList<ImageDTO> teaserHighlight = new ArrayList<ImageDTO>();
        ArrayList<ImageDTO> bigScreenImages = new ArrayList<ImageDTO>();
        for (ImageDTO imageDTO : this.getSlideCtx().getEvent().getImages()) {
            if (imageDTO.getTags().contains(MediaTagConstants.BIGSCREEN.getName())) {
                bigScreenImages.add(imageDTO);
                continue;
            }
            if (imageDTO.getTags().contains(MediaTagConstants.TEASER.getName())) {
                teaserHighlight.add(imageDTO);
                continue;
            }
            if (!imageDTO.getTags().contains(MediaTagConstants.HIGHLIGHT.getName())) continue;
            teaserHighlight.add(imageDTO);
        }
        List<Object> usedImages = bigScreenImages.isEmpty() ? (teaserHighlight.isEmpty() ? this.getSlideCtx().getEvent().getImages() : teaserHighlight) : bigScreenImages;
        if (!usedImages.isEmpty()) {
            ImageDTO imageToUseDTO;
            int selected = 0;
            if (usedImages.size() > 1) {
                Random r = new Random();
                selected = r.nextInt(usedImages.size());
            }
            if ((imageToUseDTO = (ImageDTO)usedImages.get(selected)) != null) {
                StringBuilder thumbnailUrlBuilder = new StringBuilder("url('");
                thumbnailUrlBuilder.append(UriUtils.fromString((String)imageToUseDTO.getSourceRef()).asString());
                thumbnailUrlBuilder.append("')");
                this.view.setBackgroudImage(thumbnailUrlBuilder.toString());
            }
        }
    }

    public void changed(Countdown.RemainingTime major, Countdown.RemainingTime minor) {
        this.view.setStartIn(major);
    }
}

