/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats.RaceEndWithBoatsView;
import com.sap.sailing.gwt.autoplay.client.places.screens.afterliveraceloop.boats.RaceEndWithBoatsViewImpl;
import com.sap.sailing.gwt.autoplay.client.places.screens.preliveraceloop.leaderboard.PreLiveRaceLeaderboardWithImageViewImpl;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.SingleRaceLeaderboardPanel;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.client.panels.ResizableFlowPanel;

public class RaceEndWithBoatsViewImpl
extends ResizeComposite
implements RaceEndWithBoatsView {
    private static RaceEndWithBoatsViewImplUiBinder uiBinder = (RaceEndWithBoatsViewImplUiBinder)GWT.create(RaceEndWithBoatsViewImplUiBinder.class);
    @UiField
    ResizableFlowPanel leaderBoardHolder;
    @UiField
    ResizableFlowPanel infoHolder;
    @UiField
    FlowPanel image1;
    @UiField
    FlowPanel image2;
    @UiField
    FlowPanel image3;
    @UiField
    Label subline1;
    @UiField
    Label subline2;
    @UiField
    Label subline3;
    @UiField
    Label statisticValue1;
    @UiField
    Label statisticProperty1;
    @UiField
    Label statisticValue2;
    @UiField
    Label statisticProperty2;
    @UiField
    Label statisticValue3;
    @UiField
    Label statisticProperty3;
    private NumberFormat compactFormat = NumberFormat.getFormat((String)"#.0");
    private PreLiveRaceLeaderboardWithImageViewImpl.ImageProvider provider;

    public RaceEndWithBoatsViewImpl(PreLiveRaceLeaderboardWithImageViewImpl.ImageProvider provider) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.provider = provider;
    }

    public void startingWith(RaceEndWithBoatsView.NextRaceWithBoatsPresenter p, AcceptsOneWidget panel) {
        panel.setWidget((IsWidget)this);
    }

    public void setLeaderBoard(SingleRaceLeaderboardPanel leaderboardPanel) {
        this.leaderBoardHolder.add((Widget)leaderboardPanel);
    }

    public void setFirst(CompetitorDTO c) {
        this.subline1.setText("1. " + c.getName());
        this.setImage(this.image1, this.provider.getImageUrl(c), true);
    }

    public void setSecond(CompetitorDTO c) {
        this.subline2.setText("2. " + c.getName());
        this.setImage(this.image2, this.provider.getImageUrl(c), false);
    }

    public void setThird(CompetitorDTO c) {
        this.subline3.setText("3. " + c.getName());
        this.setImage(this.image3, this.provider.getImageUrl(c), false);
    }

    private void setImage(FlowPanel image, String imageUrl, boolean slightlyLarger) {
        image.getElement().getStyle().setBackgroundImage("url(" + imageUrl + ")");
        image.getElement().getStyle().setWidth((double)(slightlyLarger ? 100 : 90), Style.Unit.PCT);
        image.getElement().getStyle().setProperty("height", "90%");
        image.getElement().getStyle().setProperty("margin", "auto");
        image.getElement().getStyle().setProperty("backgroundPosition", "center bottom");
        image.getElement().getStyle().setProperty("backgroundSize", "contain");
        image.getElement().getStyle().setProperty("backgroundRepeat", "no-repeat");
    }

    public void setStatistic(int competitorCount, Distance distance, Duration duration) {
        this.statisticProperty1.setText(StringMessages.INSTANCE.competitors());
        this.statisticValue1.setText(String.valueOf(competitorCount));
        this.statisticProperty2.setText(StringMessages.INSTANCE.distance());
        if (distance == null) {
            this.statisticValue2.setText(StringMessages.INSTANCE.noDataFound());
        } else {
            this.statisticValue2.setText(String.valueOf(this.compactFormat.format(distance.getSeaMiles())) + " " + StringMessages.INSTANCE.seaMiles());
        }
        this.statisticProperty3.setText(StringMessages.INSTANCE.durationPlain());
        this.statisticValue3.setText(String.valueOf(this.compactFormat.format(duration.asMinutes())) + " " + StringMessages.INSTANCE.minutes());
    }
}

