/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.server.riot.impl;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiAPI;
import com.igtimi.IgtimiData;
import com.igtimi.IgtimiDevice;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.ChannelManagementVisitor;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.MsgVisitor;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotConnection;
import com.sap.sailing.domain.igtimiadapter.server.riot.impl.RiotServerImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RiotConnectionImpl
implements RiotConnection {
    private static final Logger logger = Logger.getLogger(RiotConnectionImpl.class.getName());
    private static final ExtensionRegistry protobufExtensionRegistry = ExtensionRegistry.newInstance();
    private String serialNumber;
    private String deviceGroupToken;
    private final ByteBuffer messageLengthBuffer;
    private ByteBuffer messageBuffer;
    private int nextMessageLength;
    private final SocketChannel socketChannel;
    private final RiotServerImpl riotServer;
    private final ScheduledFuture<?> heartbeatSendingTask;
    private TimePoint lastHeartbeatReceivedAt;

    RiotConnectionImpl(SocketChannel socketChannel, RiotServerImpl riotServer) {
        this.socketChannel = socketChannel;
        this.riotServer = riotServer;
        this.messageLengthBuffer = ByteBuffer.allocate(5);
        this.heartbeatSendingTask = this.scheduleHeartbeat();
    }

    private ScheduledFuture<?> scheduleHeartbeat() {
        return ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(this::sendHeartbeat, 15L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getDeviceGroupToken() {
        return this.deviceGroupToken;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public TimePoint getLastHeartbeatReceivedAt() {
        return this.lastHeartbeatReceivedAt;
    }

    @Override
    public void close() throws IOException {
        try {
            this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setDisconnect(IgtimiStream.ServerDisconnecting.newBuilder().setCode(500).setReason("Connection closed by server"))).build());
        }
        finally {
            this.heartbeatSendingTask.cancel(false);
            this.socketChannel.close();
        }
    }

    @Override
    public void sendCommand(String command) throws IOException {
        this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setDeviceManagement(IgtimiDevice.DeviceManagement.newBuilder().setRequest(IgtimiDevice.DeviceManagementRequest.newBuilder().setCommand(IgtimiDevice.DeviceCommand.newBuilder().setText(command)))).build());
    }

    @Override
    public void dataReceived(ByteBuffer data) {
        data.flip();
        while (data.hasRemaining()) {
            if (this.nextMessageLength == 0) {
                byte b = data.get();
                this.messageLengthBuffer.put(b);
                int oldPosition = this.messageLengthBuffer.position();
                this.messageLengthBuffer.flip();
                try {
                    this.nextMessageLength = CodedInputStream.newInstance((ByteBuffer)this.messageLengthBuffer).readRawVarint32();
                    this.messageLengthBuffer.clear();
                    this.messageBuffer = ByteBuffer.allocate(this.nextMessageLength);
                }
                catch (IOException ioe) {
                    this.messageLengthBuffer.limit(this.messageLengthBuffer.capacity());
                    this.messageLengthBuffer.position(oldPosition);
                }
                continue;
            }
            byte[] copyBuffer = new byte[Math.min(data.remaining(), this.messageBuffer.remaining())];
            data.get(copyBuffer);
            this.messageBuffer.put(copyBuffer);
            if (this.messageBuffer.hasRemaining()) continue;
            this.nextMessageLength = 0;
            try {
                this.messageBuffer.flip();
                IgtimiStream.Msg message = IgtimiStream.Msg.parseFrom((ByteBuffer)this.messageBuffer, (ExtensionRegistryLite)protobufExtensionRegistry);
                this.processMessage(message);
                this.riotServer.notifyListeners(message, this.serialNumber);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.SEVERE, "Error parsing message from device " + this.serialNumber, e);
            }
        }
    }

    private void sendPositiveAuthResponse() {
        new Thread(() -> {
            RiotConnectionImpl riotConnectionImpl = this;
            synchronized (riotConnectionImpl) {
                while (this.serialNumber == null) {
                    try {
                        logger.info("Waiting for serial number before returning successful auth response with device group token");
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            IgtimiStream.Authentication.AuthResponse response = IgtimiStream.Authentication.AuthResponse.newBuilder().setTimestamp(System.currentTimeMillis()).setAck(true).setCode(200).setReason("Authenticated").build();
            logger.info("Sending auth response for device " + this.serialNumber);
            try {
                this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setAuth(IgtimiStream.Authentication.newBuilder().setAuthResponse(response))).build());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Couldn't send authentication response to device " + this.getSerialNumber(), e);
            }
        }, "sending positive Igtimi auth response when device serial number is known").start();
    }

    private void send(AbstractMessage message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        message.writeDelimitedTo((OutputStream)bos);
        ByteBuffer buf = ByteBuffer.allocate(bos.size());
        buf.put(bos.toByteArray());
        buf.flip();
        this.socketChannel.write(buf);
    }

    private void processMessage(IgtimiStream.Msg message) {
        MsgVisitor.accept((IgtimiStream.Msg)message, (MsgVisitor)new MsgVisitor(){

            public void handleDeviceManagement(IgtimiDevice.DeviceManagement deviceManagement) {
                RiotConnectionImpl.this.updateSerialNumber(deviceManagement.getSerialNumber());
            }

            public void handleData(IgtimiData.Data data) {
                for (IgtimiData.DataMsg dataMsg : data.getDataList()) {
                    RiotConnectionImpl.this.updateSerialNumber(dataMsg.getSerialNumber());
                }
            }

            public void handleChannelManagement(IgtimiStream.ChannelManagement channelManagement) {
                ChannelManagementVisitor.accept((IgtimiStream.ChannelManagement)channelManagement, (ChannelManagementVisitor)new ChannelManagementVisitor(){

                    public void handleAuth(IgtimiStream.Authentication auth) {
                        IgtimiAPI.Token token;
                        if (auth.hasAuthRequest() && (token = auth.getAuthRequest().getToken()).hasDeviceGroupToken()) {
                            RiotConnectionImpl.this.deviceGroupToken = token.getDeviceGroupToken();
                            logger.info("Received auth request from device " + RiotConnectionImpl.this.serialNumber + " with device group token " + RiotConnectionImpl.this.deviceGroupToken);
                            RiotConnectionImpl.this.sendPositiveAuthResponse();
                        }
                    }

                    public void handleHeartbeat(long heartbeat) {
                        RiotConnectionImpl.this.lastHeartbeatReceivedAt = TimePoint.now();
                        RiotConnectionImpl.this.updateDeviceHeartbeatIfSerialNumberKnown();
                    }
                });
            }

            public void handleAckResponse(IgtimiStream.AckResponse ackResponse) {
                logger.info("Received AckResponse from device " + RiotConnectionImpl.this.getSerialNumber() + ": " + ackResponse);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSerialNumber(String serialNumber) {
        if (Util.hasLength((String)serialNumber)) {
            boolean serialNumberWasUnknown;
            RiotConnectionImpl riotConnectionImpl = this;
            synchronized (riotConnectionImpl) {
                serialNumberWasUnknown = this.serialNumber == null;
                this.serialNumber = serialNumber;
                if (serialNumberWasUnknown) {
                    this.notifyAll();
                }
            }
            if (serialNumberWasUnknown && this.lastHeartbeatReceivedAt != null) {
                this.updateDeviceHeartbeatIfSerialNumberKnown();
            }
        }
    }

    private void updateDeviceHeartbeatIfSerialNumberKnown() {
        Device device;
        if (this.serialNumber != null && (device = this.riotServer.getDeviceBySerialNumber(this.serialNumber)) != null) {
            try {
                this.riotServer.updateDeviceLastHeartbeat(device.getId(), this.lastHeartbeatReceivedAt, this.getSocketChannel().getRemoteAddress().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void sendHeartbeat() {
        try {
            this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setHeartbeat(1L)).build());
        }
        catch (ClosedChannelException cce) {
            logger.warning("Channel " + this.socketChannel + " closed. Forwarding exception to stop sending heartbeat to closed connection");
            throw new RuntimeException(cce);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem while trying to send heartbeat message to device " + this.getSerialNumber(), e);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "RiotConnectionImpl [serialNumber=" + this.serialNumber + ", socketChannel=" + this.socketChannel + "]";
    }
}

