/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.server.riot;

import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiData;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.FixFactory;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.igtimiadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.igtimiadapter.server.RiotWebsocketHandler;
import com.sap.sailing.domain.igtimiadapter.server.replication.ReplicableRiotServer;
import com.sap.sailing.domain.igtimiadapter.server.replication.RiotReplicationOperation;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotConnection;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotMessageListener;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotStandardCommand;
import com.sap.sailing.domain.igtimiadapter.server.riot.impl.RiotServerImpl;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.replication.Replicable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Set;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.parser.ParseException;

public interface RiotServer
extends Replicable<ReplicableRiotServer, RiotReplicationOperation<?>> {
    public static RiotServer create(int port, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory) throws Exception {
        return new RiotServerImpl(port, domainObjectFactory, mongoObjectFactory);
    }

    public static RiotServer create(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory) throws Exception {
        return new RiotServerImpl(domainObjectFactory, mongoObjectFactory);
    }

    public void addListener(RiotMessageListener var1);

    public void removeListener(RiotMessageListener var1);

    public void stop() throws IOException;

    public int getPort() throws IOException;

    public Iterable<Device> getDevices();

    public Device getDeviceById(long var1);

    public Device getDeviceBySerialNumber(String var1);

    public Device createDevice(String var1);

    public void removeDevice(long var1);

    public void updateDeviceName(long var1, String var3);

    public void updateDeviceLastHeartbeat(long var1, TimePoint var3, String var4);

    public Iterable<DataAccessWindow> getDataAccessWindows();

    public DataAccessWindow getDataAccessWindowById(long var1);

    public Iterable<DataAccessWindow> getDataAccessWindows(Iterable<String> var1, MultiTimeRange var2);

    public DataAccessWindow createDataAccessWindow(String var1, TimePoint var2, TimePoint var3);

    public void removeDataAccessWindow(long var1);

    public Iterable<IgtimiStream.Msg> getMessages(String var1, MultiTimeRange var2, Set<IgtimiData.DataPoint.DataCase> var3) throws MalformedURLException, IllegalStateException, ClientProtocolException, IOException, ParseException;

    public void addWebSocketClient(RiotWebsocketHandler var1);

    public void removeWebSocketClient(RiotWebsocketHandler var1);

    public IgtimiStream.Msg getLastMessage(String var1, IgtimiData.DataPoint.DataCase var2, MultiTimeRange var3) throws InvalidProtocolBufferException, ParseException, IOException;

    default public <T extends Fix> T getLastFix(String serialNumber, Class<T> type, MultiTimeRange timeRanges) throws InvalidProtocolBufferException, ParseException, IOException {
        Fix tResult;
        Iterable fixes;
        IgtimiStream.Msg lastMessage = this.getLastMessage(serialNumber, IgtimiData.DataPoint.DataCase.forNumber((int)Type.getType(type).getCode()), timeRanges);
        Fix result = lastMessage != null ? ((fixes = new FixFactory().createFixes(lastMessage)) != null ? (tResult = (Fix)Util.first((Iterable)fixes)) : null) : null;
        return (T)result;
    }

    public Iterable<RiotConnection> getLiveConnections();

    public boolean sendStandardCommand(String var1, RiotStandardCommand var2) throws IOException;
}

