/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.server;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.PersistenceFactory;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sailing.domain.igtimiadapter.server.riot.impl.RiotServerImpl;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.Replicable;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.ClearStateTestSupport;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String RIOT_PORT_PROPERTY_NAME = "igtimi.riot.port";
    private static BundleContext context;
    private static Activator instance;
    private RiotServer riotServer;
    private FullyInitializedReplicableTracker<SecurityService> securityServiceServiceTracker;
    private SecurityService securityServiceTest;

    public Activator() {
        instance = this;
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String riotPortAsString = System.getProperty(RIOT_PORT_PROPERTY_NAME, "0");
        int bindPort = Integer.valueOf(riotPortAsString);
        DomainObjectFactory domainObjectFactory = PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory();
        MongoObjectFactory mongoObjectFactory = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory();
        this.riotServer = RiotServer.create(bindPort, domainObjectFactory, mongoObjectFactory);
        context.registerService(RiotServer.class, (Object)this.riotServer, null);
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", this.riotServer.getId().toString());
        context.registerService(Replicable.class, (Object)this.riotServer, replicableServiceProperties);
        context.registerService(ClearStateTestSupport.class.getName(), (Object)new ClearStateTestSupport(){

            public void clearState() throws Exception {
                ((RiotServerImpl)Activator.this.riotServer).clear();
            }
        }, null);
        new Thread(() -> {
            this.securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
            try {
                SecurityService securityService = (SecurityService)this.securityServiceServiceTracker.getInitializedService(0L);
                for (DataAccessWindow daw : this.riotServer.getDataAccessWindows()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)daw);
                }
                for (Device device : this.riotServer.getDevices()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)device);
                }
                String igtimiAccountTypeName = SecuredDomainType.IGTIMI_ACCOUNT.getName();
                securityService.assumeOwnershipMigrated(igtimiAccountTypeName);
                securityService.assumeOwnershipMigrated(SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW.getName());
                securityService.assumeOwnershipMigrated(SecuredDomainType.IGTIMI_DEVICE.getName());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error trying to create missing ownerships for Igtimi entities", e);
            }
        }).start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.getRiotServer().stop();
        context = null;
    }

    public static Activator getInstance() {
        if (instance == null) {
            instance = new Activator();
        }
        return instance;
    }

    public RiotServer getRiotServer() {
        return this.riotServer;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityServiceTest = securityService;
    }

    public SecurityService getSecurityService() {
        try {
            return this.securityServiceTest == null ? (SecurityService)this.securityServiceServiceTracker.getInitializedService(0L) : this.securityServiceTest;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

