/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackerManager;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.JSONService;
import com.sap.sailing.domain.tractracadapter.RaceRecord;
import com.sap.sailing.domain.tractracadapter.TracTracAdapter;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.impl.DomainFactoryImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class TracTracAdapterImpl
implements TracTracAdapter {
    private static final Logger logger = Logger.getLogger(TracTracAdapter.class.getName());
    private final DomainFactory tractracDomainFactory;
    private final long delayToLiveInMillis;

    public TracTracAdapterImpl(com.sap.sailing.domain.base.DomainFactory baseDomainFactory) {
        this.tractracDomainFactory = new DomainFactoryImpl(baseDomainFactory);
        this.delayToLiveInMillis = 5000L;
    }

    @Override
    public DomainFactory getTracTracDomainFactory() {
        return this.tractracDomainFactory;
    }

    @Override
    public RaceHandle addTracTracRace(TrackerManager trackerManager, URL paramURL, URI liveURI, URI storedURI, URI courseDesignUpdateURI, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, long timeoutInMilliseconds, String tracTracUsername, String tracTracPassword, String raceStatus, String raceVisibility, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, int timeoutInMillis, boolean useOfficialEventsToUpdateRaceLog, RaceTrackingHandler raceTrackingHandler) throws Exception {
        return trackerManager.addRace(null, this.getTracTracDomainFactory().createTrackingConnectivityParameters(paramURL, liveURI, storedURI, courseDesignUpdateURI, null, null, this.delayToLiveInMillis, null, false, raceLogStore, regattaLogStore, tracTracUsername, tracTracPassword, raceStatus, raceVisibility, trackWind, correctWindDirectionByMagneticDeclination, false, timeoutInMillis, useOfficialEventsToUpdateRaceLog, null, null), timeoutInMilliseconds, raceTrackingHandler);
    }

    @Override
    public RaceHandle addTracTracRace(TrackerManager trackerManager, RegattaIdentifier regattaToAddTo, URL paramURL, URI liveURI, URI storedURI, URI courseDesignUpdateURI, TimePoint startOfTracking, TimePoint endOfTracking, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, long timeoutInMilliseconds, Duration offsetToStartTimeOfSimulatedRace, boolean useInternalMarkPassingAlgorithm, String tracTracUsername, String tracTracPassword, String raceStatus, String raceVisibility, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, boolean useOfficialEventsToUpdateRaceLog, URI liveURIFromConfiguration, URI storedURIFromConfiguration) throws Exception {
        return trackerManager.addRace(regattaToAddTo, this.getTracTracDomainFactory().createTrackingConnectivityParameters(paramURL, liveURI, storedURI, courseDesignUpdateURI, startOfTracking, endOfTracking, this.delayToLiveInMillis, offsetToStartTimeOfSimulatedRace, useInternalMarkPassingAlgorithm, raceLogStore, regattaLogStore, tracTracUsername, tracTracPassword, raceStatus, raceVisibility, trackWind, correctWindDirectionByMagneticDeclination, false, (int)timeoutInMilliseconds, useOfficialEventsToUpdateRaceLog, liveURIFromConfiguration, storedURIFromConfiguration), timeoutInMilliseconds);
    }

    @Override
    public Util.Pair<String, List<RaceRecord>> getTracTracRaceRecords(URL jsonURL, boolean loadClientParams) throws IOException, java.text.ParseException, ParseException, URISyntaxException {
        logger.info("Retrieving TracTrac race records from " + jsonURL);
        JSONService jsonService = this.getTracTracDomainFactory().parseJSONURLWithRaceRecords(jsonURL, loadClientParams);
        logger.info("OK retrieving TracTrac race records from " + jsonURL);
        return new Util.Pair((Object)jsonService.getEventName(), jsonService.getRaceRecords());
    }

    @Override
    public RaceRecord getSingleTracTracRaceRecord(URL jsonURL, String raceId, boolean loadClientParams) throws Exception {
        JSONService service = this.getTracTracDomainFactory().parseJSONURLForOneRaceRecord(jsonURL, raceId, loadClientParams);
        if (!service.getRaceRecords().isEmpty()) {
            return service.getRaceRecords().get(0);
        }
        return null;
    }

    @Override
    public TracTracConfiguration createTracTracConfiguration(String creatorName, String name, String jsonURL, String liveDataURI, String storedDataURI, String courseDesignUpdateURI, String tracTracUsername, String tracTracPassword) {
        return this.getTracTracDomainFactory().createTracTracConfiguration(creatorName, name, jsonURL, liveDataURI, storedDataURI, courseDesignUpdateURI, tracTracUsername, tracTracPassword);
    }
}

