/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.subscription.lib.api.SubscriptionLocator;
import com.tractrac.subscription.lib.api.competitor.ICompetitorsListener;
import com.tractrac.subscription.lib.api.event.IConnectionStatusListener;
import com.tractrac.subscription.lib.api.event.IEventMessageListener;
import com.tractrac.subscription.lib.api.event.IServerTimeListener;
import com.tractrac.subscription.lib.api.map.IMapItemsListener;
import com.tractrac.subscription.lib.api.race.IRacesListener;
import com.tractrac.subscription.lib.api.race.IStartStopTimesChangeListener;
import java.net.URI;

public class EventSubscriberWrapper
implements IEventSubscriber {
    private IEventSubscriber delegate;
    private final IEvent tractracEvent;
    private final URI liveURI;
    private final URI storedURI;
    private int startCounter;

    public EventSubscriberWrapper(IEvent tractracEvent, URI liveURI, URI storedURI) throws SubscriberInitializationException {
        this.tractracEvent = tractracEvent;
        this.liveURI = liveURI;
        this.storedURI = storedURI;
        this.startCounter = 0;
        this.delegate = this.createEventSubscriber();
    }

    private IEventSubscriber createEventSubscriber() throws SubscriberInitializationException {
        return SubscriptionLocator.getSusbcriberFactory().createEventSubscriber(this.tractracEvent, this.liveURI, this.storedURI);
    }

    public void subscribeConnectionStatus(IConnectionStatusListener listener) {
        this.delegate.subscribeConnectionStatus(listener);
    }

    public void unsubscribeConnectionStatus(IConnectionStatusListener listener) {
        this.delegate.unsubscribeConnectionStatus(listener);
    }

    public synchronized void start() {
        if (this.startCounter++ == 0) {
            this.delegate.start();
        }
    }

    public synchronized void stop() {
        if (--this.startCounter == 0) {
            this.delegate.stop();
            try {
                this.delegate = this.createEventSubscriber();
            }
            catch (SubscriberInitializationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    public void subscribeMapItems(IMapItemsListener listener) {
        this.delegate.subscribeMapItems(listener);
    }

    public void unsubscribeMapItems(IMapItemsListener listener) {
        this.delegate.unsubscribeMapItems(listener);
    }

    public void subscribeEventTimesChanges(IStartStopTimesChangeListener listener) {
        this.delegate.subscribeEventTimesChanges(listener);
    }

    public void unsubscribeEventTimesChanges(IStartStopTimesChangeListener listener) {
        this.delegate.unsubscribeEventTimesChanges(listener);
    }

    public void subscribeEventMessages(IEventMessageListener listener) {
        this.delegate.subscribeEventMessages(listener);
    }

    public void unsubscribeEventMessages(IEventMessageListener listener) {
        this.delegate.unsubscribeEventMessages(listener);
    }

    public void subscribeServerTime(IServerTimeListener serverTimeListener) {
        this.delegate.subscribeServerTime(serverTimeListener);
    }

    public void unsubscribeServerTime(IServerTimeListener serverTimeListener) {
        this.delegate.unsubscribeServerTime(serverTimeListener);
    }

    public void subscribeRaces(IRacesListener listener) {
        this.delegate.subscribeRaces(listener);
    }

    public void unsubscribeRaces(IRacesListener listener) {
        this.delegate.unsubscribeRaces(listener);
    }

    public void subscribeCompetitors(ICompetitorsListener listener) {
        this.delegate.subscribeCompetitors(listener);
    }

    public void unsubscribeCompetitors(ICompetitorsListener listener) {
        this.delegate.unsubscribeCompetitors(listener);
    }
}

