/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.LeaderboardGroupBase;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.MigratableRegatta;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CourseImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicPerson;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.KilometersPerHourSpeedWithBearingImpl;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.base.impl.SidelineImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.ranking.RankingMetricsFactory;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.impl.CourseDesignUpdateHandler;
import com.sap.sailing.domain.tracking.impl.FinishTimeUpdateHandler;
import com.sap.sailing.domain.tracking.impl.RaceAbortedHandler;
import com.sap.sailing.domain.tracking.impl.StartTimeUpdateHandler;
import com.sap.sailing.domain.tracking.impl.TrackingConnectorInfoImpl;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.JSONService;
import com.sap.sailing.domain.tractracadapter.MetadataParser;
import com.sap.sailing.domain.tractracadapter.Receiver;
import com.sap.sailing.domain.tractracadapter.ReceiverType;
import com.sap.sailing.domain.tractracadapter.TracTracConfiguration;
import com.sap.sailing.domain.tractracadapter.TracTracRaceTracker;
import com.sap.sailing.domain.tractracadapter.impl.CompetitorChangeReceiver;
import com.sap.sailing.domain.tractracadapter.impl.EventSubscriberWrapper;
import com.sap.sailing.domain.tractracadapter.impl.JSONServiceImpl;
import com.sap.sailing.domain.tractracadapter.impl.MarkPassingReceiver;
import com.sap.sailing.domain.tractracadapter.impl.MarkPositionReceiver;
import com.sap.sailing.domain.tractracadapter.impl.MetadataParserImpl;
import com.sap.sailing.domain.tractracadapter.impl.RaceAndCompetitorStatusWithRaceLogReconciler;
import com.sap.sailing.domain.tractracadapter.impl.RaceCourseReceiver;
import com.sap.sailing.domain.tractracadapter.impl.RaceStartedAndFinishedReceiver;
import com.sap.sailing.domain.tractracadapter.impl.RaceTrackingConnectivityParametersImpl;
import com.sap.sailing.domain.tractracadapter.impl.RawPositionReceiver;
import com.sap.sailing.domain.tractracadapter.impl.SensorDataReceiver;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sailing.domain.tractracadapter.impl.TracTracConfigurationImpl;
import com.sap.sailing.domain.tractracadapter.impl.TracTracCourseDesignUpdateHandler;
import com.sap.sailing.domain.tractracadapter.impl.TracTracRaceTrackerImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.AbstractColor;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.WeakIdentityHashMap;
import com.sap.sse.shared.util.WeakValueCache;
import com.tractrac.model.lib.api.data.IPosition;
import com.tractrac.model.lib.api.event.CreateModelException;
import com.tractrac.model.lib.api.event.ICompetitor;
import com.tractrac.model.lib.api.event.ICompetitorClass;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.model.lib.api.map.IPositionedItem;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.SubscriberInitializationException;
import com.tractrac.util.lib.api.exceptions.TimeOutException;
import difflib.PatchFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.json.simple.parser.ParseException;

public class DomainFactoryImpl
implements DomainFactory {
    private static final Logger logger = Logger.getLogger(DomainFactoryImpl.class.getName());
    private final com.sap.sailing.domain.base.DomainFactory baseDomainFactory;
    private final WeakValueCache<IMapItem, ControlPoint> controlPointCache = new WeakValueCache(new HashMap());
    private final Map<Util.Pair<String, UUID>, DynamicPerson> personCache = new HashMap<Util.Pair<String, UUID>, DynamicPerson>();
    private final WeakValueCache<Util.Pair<String, String>, Regatta> regattaCache = new WeakValueCache(new HashMap());
    private final WeakIdentityHashMap<IRace, Regatta> weakDefaultRegattaCache = new WeakIdentityHashMap();
    private final WeakValueCache<UUID, RaceDefinition> raceCache = new WeakValueCache(new ConcurrentHashMap());
    private final MetadataParser metadataParser;
    private final Set<Competitor> competitorsCurrentlyBeingMigrated;
    private final ConcurrentMap<Util.Triple<IEvent, URI, URI>, IEventSubscriber> eventSubscriberCache;

    public DomainFactoryImpl(com.sap.sailing.domain.base.DomainFactory baseDomainFactory) {
        this.baseDomainFactory = baseDomainFactory;
        this.metadataParser = new MetadataParserImpl();
        this.competitorsCurrentlyBeingMigrated = Collections.synchronizedSet(new HashSet());
        this.eventSubscriberCache = new ConcurrentHashMap<Util.Triple<IEvent, URI, URI>, IEventSubscriber>();
    }

    @Override
    public MetadataParser getMetadataParser() {
        return this.metadataParser;
    }

    @Override
    public com.sap.sailing.domain.base.DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    @Override
    public Position createPosition(IPosition position) {
        return new DegreePosition(position.getLatitude(), position.getLongitude());
    }

    @Override
    public GPSFixMoving createGPSFixMoving(IPosition position) {
        GPSFixMovingImpl result = new GPSFixMovingImpl(this.createPosition(position), (TimePoint)new MillisecondsTimePoint(position.getTimestamp()), (SpeedWithBearing)new KilometersPerHourSpeedWithBearingImpl(position.getSpeed(), (Bearing)new DegreeBearingImpl(position.getDirection())), (Bearing)(position.getTrueHeading() == null ? null : new DegreeBearingImpl(position.getTrueHeading().doubleValue())));
        return result;
    }

    @Override
    public TimePoint createTimePoint(long timestamp) {
        return new MillisecondsTimePoint(timestamp);
    }

    @Override
    public void updateCourseWaypoints(Course courseToUpdate, Iterable<Util.Pair<IMapItem, PassingInstruction>> controlPoints) throws PatchFailedException {
        ArrayList<Util.Pair> newDomainControlPoints = new ArrayList<Util.Pair>();
        for (Util.Pair<IMapItem, PassingInstruction> tractracControlPoint : controlPoints) {
            ControlPoint newDomainControlPoint = this.getOrCreateControlPoint((IMapItem)tractracControlPoint.getA());
            newDomainControlPoints.add(new Util.Pair((Object)newDomainControlPoint, (Object)((PassingInstruction)tractracControlPoint.getB())));
        }
        courseToUpdate.update(newDomainControlPoints, courseToUpdate.getAssociatedRoles(), courseToUpdate.getOriginatingCourseTemplateIdOrNull(), this.baseDomainFactory);
    }

    @Override
    public List<Sideline> createSidelines(String raceMetadataString, Iterable<? extends IMapItem> allEventControlPoints) {
        ArrayList<Sideline> sidelines = new ArrayList<Sideline>();
        Map<String, Iterable<IPositionedItem>> sidelinesMetadata = this.getMetadataParser().parseSidelinesFromRaceMetadata(raceMetadataString, allEventControlPoints);
        for (Map.Entry<String, Iterable<IPositionedItem>> sidelineEntry : sidelinesMetadata.entrySet()) {
            if (Util.size(sidelineEntry.getValue()) <= 0) continue;
            sidelines.add(this.createSideline(sidelineEntry.getKey(), sidelineEntry.getValue()));
        }
        return sidelines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControlPoint getOrCreateControlPoint(IMapItem mapItem) {
        WeakValueCache<IMapItem, ControlPoint> weakValueCache = this.controlPointCache;
        synchronized (weakValueCache) {
            ControlPoint domainControlPoint = (ControlPoint)this.controlPointCache.get((Object)mapItem);
            if (domainControlPoint == null) {
                ArrayList<Mark> marks = new ArrayList<Mark>();
                for (IPositionedItem positionedItem : mapItem.getPositionedItems()) {
                    Mark mark = this.getOrCreateMark(positionedItem);
                    marks.add(mark);
                }
                if (mapItem.isMultiple()) {
                    Iterator markIter = marks.iterator();
                    Mark mark1 = (Mark)markIter.next();
                    Mark mark2 = (Mark)markIter.next();
                    domainControlPoint = this.baseDomainFactory.createControlPointWithTwoMarks((Serializable)mapItem.getId(), mark1, mark2, mapItem.getName(), mapItem.getShortName());
                } else {
                    Mark mark = (Mark)marks.iterator().next();
                    domainControlPoint = mark;
                }
                this.controlPointCache.put((Object)mapItem, (Object)domainControlPoint);
            }
            return domainControlPoint;
        }
    }

    public Mark getOrCreateMark(IPositionedItem positionedItem) {
        MetadataParser.ControlPointMetaData markMetadata = this.getMetadataParser().parseControlPointMetadata(positionedItem);
        Mark mark = this.baseDomainFactory.getOrCreateMark(markMetadata.getId(), markMetadata.getName(), markMetadata.getName(), markMetadata.getType(), markMetadata.getColor(), markMetadata.getShape(), markMetadata.getPattern());
        return mark;
    }

    @Override
    public Course createCourse(String name, Iterable<Util.Pair<IMapItem, PassingInstruction>> controlPoints) {
        ArrayList<Waypoint> waypointList = new ArrayList<Waypoint>();
        for (Util.Pair<IMapItem, PassingInstruction> controlPoint : controlPoints) {
            Waypoint waypoint = this.baseDomainFactory.createWaypoint(this.getOrCreateControlPoint((IMapItem)controlPoint.getA()), (PassingInstruction)controlPoint.getB());
            waypointList.add(waypoint);
        }
        return new CourseImpl(name, waypointList);
    }

    @Override
    public Sideline createSideline(String name, Iterable<IPositionedItem> positionedItems) {
        ArrayList<Mark> marks = new ArrayList<Mark>();
        for (IPositionedItem controlPoint : positionedItems) {
            Mark cp = this.getOrCreateMark(controlPoint);
            for (Mark mark : cp.getMarks()) {
                marks.add(mark);
            }
        }
        return new SidelineImpl(name, marks);
    }

    @Override
    public Competitor resolveCompetitor(ICompetitor competitor) {
        return this.baseDomainFactory.getCompetitorAndBoatStore().getExistingCompetitorById((Serializable)competitor.getId());
    }

    @Override
    public void updateCompetitor(ICompetitor competitor, RaceTrackingHandler raceTrackingHandler) {
        Competitor domainCompetitor = this.resolveCompetitor(competitor);
        if (domainCompetitor != null) {
            if (domainCompetitor.hasBoat()) {
                this.getOrCreateCompetitorWithBoat(competitor, raceTrackingHandler);
            } else {
                this.getOrCreateCompetitor(competitor, raceTrackingHandler);
            }
            logger.info("Competitor " + competitor + " was updated on TracTrac side. Maybe consider updating in competitor store as well. " + "TracTrac competitor maps to " + domainCompetitor.getName() + " with ID " + domainCompetitor.getId().toString());
        } else {
            logger.info("Could not find competitor " + competitor + " in competitor store.");
        }
    }

    private Competitor getOrCreateCompetitor(ICompetitor competitor, RaceTrackingHandler raceTrackingHandler) {
        String name = this.getCompetitorNameOrDescription(competitor);
        Competitor result = this.getOrCreateCompetitor(competitor.getId(), competitor.getNationality(), name, competitor.getShortName(), competitor.getHandicapToT(), competitor.getHandicapToD(), null, raceTrackingHandler);
        return result;
    }

    private CompetitorWithBoat getOrCreateCompetitorWithBoat(ICompetitor competitor, RaceTrackingHandler raceTrackingHandler) {
        String sailId = competitor.getShortName();
        String competitorClassName = competitor.getCompetitorClass() == null ? null : competitor.getCompetitorClass().getName();
        String name = this.getCompetitorNameOrDescription(competitor);
        CompetitorWithBoat result = this.getOrCreateCompetitorWithBoat(competitor.getId(), competitor.getNationality(), name, null, competitor.getHandicapToT(), competitor.getHandicapToD(), null, competitorClassName, sailId, raceTrackingHandler);
        return result;
    }

    private String getCompetitorNameOrDescription(ICompetitor competitor) {
        String name = competitor.getName() == null || competitor.getName().isEmpty() ? competitor.getDescription() : competitor.getName();
        return name;
    }

    private CompetitorWithBoat getOrCreateCompetitorWithBoat(UUID competitorId, String nationalityAsString, String name, String shortName, float timeOnTimeFactor, float timeOnDistanceAllowanceInSecondsPerNauticalMile, String searchTag, String competitorClassName, String sailId, RaceTrackingHandler raceTrackingHandler) {
        CompetitorAndBoatStore competitorStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        CompetitorWithBoat domainCompetitor = competitorStore.getExistingCompetitorWithBoatById((Serializable)competitorId);
        if (domainCompetitor == null || competitorStore.isCompetitorToUpdateDuringGetOrCreate((Competitor)domainCompetitor)) {
            Nationality nationality;
            BoatClass boatClass = this.getOrCreateBoatClass(competitorClassName);
            try {
                nationality = this.getOrCreateNationality(nationalityAsString);
            }
            catch (IllegalArgumentException iae) {
                nationality = null;
                logger.log(Level.SEVERE, "Unknown nationality " + nationalityAsString + " for competitor " + name + "; leaving null", iae);
            }
            DynamicTeam team = this.createTeam(name, nationality, competitorId);
            DynamicBoat boat = competitorStore.getOrCreateBoat(domainCompetitor == null ? UUID.randomUUID() : domainCompetitor.getBoat().getId(), null, boatClass, sailId, null, true);
            domainCompetitor = raceTrackingHandler.getOrCreateCompetitorWithBoat(competitorStore, (Serializable)competitorId, name, shortName, null, null, null, team, Double.valueOf(timeOnTimeFactor), (Duration)new MillisecondsDurationImpl((long)(timeOnDistanceAllowanceInSecondsPerNauticalMile * 1000.0f)), searchTag, boat);
        }
        return domainCompetitor;
    }

    private Competitor getOrCreateCompetitor(UUID competitorId, String nationalityAsString, String name, String shortName, float timeOnTimeFactor, float timeOnDistanceAllowanceInSecondsPerNauticalMile, String searchTag, RaceTrackingHandler raceTrackingHandler) {
        CompetitorAndBoatStore competitorStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        Competitor domainCompetitor = competitorStore.getExistingCompetitorById((Serializable)competitorId);
        if (domainCompetitor == null || competitorStore.isCompetitorToUpdateDuringGetOrCreate(domainCompetitor)) {
            Nationality nationality;
            try {
                nationality = this.getOrCreateNationality(nationalityAsString);
            }
            catch (IllegalArgumentException iae) {
                nationality = null;
                logger.log(Level.SEVERE, "Unknown nationality " + nationalityAsString + " for competitor " + name + "; leaving null", iae);
            }
            DynamicTeam team = this.createTeam(name, nationality, competitorId);
            domainCompetitor = raceTrackingHandler.getOrCreateCompetitor(competitorStore, (Serializable)competitorId, name, shortName, null, null, null, team, Double.valueOf(timeOnTimeFactor), (Duration)new MillisecondsDurationImpl((long)(timeOnDistanceAllowanceInSecondsPerNauticalMile * 1000.0f)), searchTag);
        }
        return domainCompetitor;
    }

    @Override
    public Boat getOrCreateBoat(Serializable boatId, String boatName, BoatClass boatClass, String sailId, Color boatColor, RaceTrackingHandler raceTrackingHandler) {
        CompetitorAndBoatStore competitorStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        DynamicBoat domainBoat = competitorStore.getExistingBoatById(boatId);
        if (domainBoat == null) {
            domainBoat = raceTrackingHandler.getOrCreateBoat(this.baseDomainFactory.getCompetitorAndBoatStore(), boatId, boatName, boatClass, sailId, boatColor);
        }
        return domainBoat;
    }

    private DynamicTeam createTeam(String name, Nationality nationality, UUID competitorId) {
        String[] stringArray;
        if (name == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = name.split("\\b*\\+\\b*");
        }
        String[] sailorNames = stringArray;
        ArrayList<DynamicPerson> sailors = new ArrayList<DynamicPerson>();
        String[] stringArray3 = sailorNames;
        int n = sailorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sailorName = stringArray3[n2];
            sailors.add(this.getOrCreatePerson(sailorName.trim(), nationality, competitorId));
            ++n2;
        }
        TeamImpl result = new TeamImpl(name, sailors, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicPerson getOrCreatePerson(String name, Nationality nationality, UUID competitorId) {
        Map<Util.Pair<String, UUID>, DynamicPerson> map = this.personCache;
        synchronized (map) {
            Util.Pair key = new Util.Pair((Object)name, (Object)competitorId);
            DynamicPerson result = this.personCache.get(key);
            if (result == null) {
                result = new PersonImpl(name, nationality, null, "");
                this.personCache.put((Util.Pair<String, UUID>)key, result);
            }
            return result;
        }
    }

    @Override
    public BoatClass getOrCreateBoatClass(String competitorClassName) {
        return this.baseDomainFactory.getOrCreateBoatClass(competitorClassName == null ? "" : competitorClassName);
    }

    @Override
    public Nationality getOrCreateNationality(String nationalityName) {
        return this.baseDomainFactory.getOrCreateNationality(nationalityName);
    }

    @Override
    public RaceDefinition getExistingRaceDefinitionForRace(UUID raceId) {
        return (RaceDefinition)this.raceCache.get((Object)raceId);
    }

    @Override
    public RaceDefinition getAndWaitForRaceDefinition(UUID raceId) {
        return this.getAndWaitForRaceDefinition(raceId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaceDefinition getAndWaitForRaceDefinition(UUID raceId, long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        RaceDefinition result = (RaceDefinition)this.raceCache.get((Object)raceId);
        boolean interrupted = false;
        if (result == null) {
            WeakValueCache<UUID, RaceDefinition> weakValueCache = this.raceCache;
            synchronized (weakValueCache) {
                result = (RaceDefinition)this.raceCache.get((Object)raceId);
                while (!(timeoutInMilliseconds != -1L && System.currentTimeMillis() - start >= timeoutInMilliseconds || interrupted || result != null)) {
                    try {
                        if (timeoutInMilliseconds == -1L) {
                            this.raceCache.wait();
                        } else {
                            long timeToWait = timeoutInMilliseconds - (System.currentTimeMillis() - start);
                            if (timeToWait > 0L) {
                                this.raceCache.wait(timeToWait);
                            }
                        }
                        result = (RaceDefinition)this.raceCache.get((Object)raceId);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Regatta getOrCreateDefaultRegatta(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, IRace race, TrackedRegattaRegistry trackedRegattaRegistry) {
        return this.getOrCreateDefaultRegatta(raceLogStore, regattaLogStore, race, trackedRegattaRegistry, RankingMetricsFactory.getRankingMetricConstructor((RankingMetrics)RankingMetrics.ONE_DESIGN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Regatta getOrCreateDefaultRegatta(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, IRace race, TrackedRegattaRegistry trackedRegattaRegistry, RankingMetricConstructor rankingMetricConstructor) {
        WeakValueCache<Util.Pair<String, String>, Regatta> weakValueCache = this.regattaCache;
        synchronized (weakValueCache) {
            Regatta result = (Regatta)this.weakDefaultRegattaCache.get((Object)race);
            if (result == null) {
                Util.Pair<String, BoatClass> defaultRegattaNameAndBoatClass = this.getDefaultRegattaNameAndBoatClass(race);
                BoatClass boatClass = (BoatClass)defaultRegattaNameAndBoatClass.getB();
                Util.Pair key = new Util.Pair((Object)((String)defaultRegattaNameAndBoatClass.getA()), (Object)(boatClass == null ? null : boatClass.getName()));
                result = (Regatta)this.regattaCache.get((Object)key);
                if (result == null) {
                    result = new RegattaImpl(raceLogStore, regattaLogStore, RegattaImpl.getDefaultName((String)((String)defaultRegattaNameAndBoatClass.getA()), (String)boatClass.getName()), boatClass, false, CompetitorRegistrationType.CLOSED, null, null, trackedRegattaRegistry, this.getBaseDomainFactory().createScoringScheme(ScoringSchemeType.LOW_POINT), (Serializable)race.getId(), null, false, false, rankingMetricConstructor, UUID.randomUUID().toString());
                    this.regattaCache.put((Object)key, (Object)result);
                    this.weakDefaultRegattaCache.put((Object)race, (Object)result);
                    logger.info("Created regatta " + result.getName() + " (" + result.hashCode() + ") because none found for key " + key);
                }
            }
            return result;
        }
    }

    private Util.Pair<String, BoatClass> getDefaultRegattaNameAndBoatClass(IRace race) {
        ArrayList<ICompetitorClass> competitorClassList = new ArrayList<ICompetitorClass>();
        this.getCompetingCompetitors(race).forEach(competitor -> competitorClassList.add(competitor.getCompetitor().getCompetitorClass()));
        Util.Pair defaultRegattaNameAndBoatClass = new Util.Pair((Object)race.getEvent().getName(), (Object)this.getDominantBoatClass((Collection<ICompetitorClass>)competitorClassList));
        return defaultRegattaNameAndBoatClass;
    }

    @Override
    public Iterable<Receiver> getUpdateReceivers(DynamicTrackedRegatta trackedRegatta, IRace tractracRace, WindStore windStore, long delayToLiveInMillis, Simulator simulator, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, LeaderboardGroupResolver leaderboardGroupResolver, URI updateURI, String tracTracUsername, String tracTracPassword, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, boolean useInternalMarkPassingAlgorithm, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, RaceAndCompetitorStatusWithRaceLogReconciler raceAndCompetitorStatusWithRaceLogReconciler, ReceiverType ... types) {
        IEvent tractracEvent = tractracRace.getEvent();
        ArrayList<Receiver> result = new ArrayList<Receiver>();
        ReceiverType[] receiverTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiverType type = receiverTypeArray[n2];
            switch (type) {
                case RACECOURSE: {
                    result.add(new RaceCourseReceiver(this, trackedRegatta, tractracEvent, tractracRace, windStore, raceDefinitionSetToUpdate, delayToLiveInMillis, 30000L, simulator, updateURI, tracTracUsername, tracTracPassword, eventSubscriber, raceSubscriber, useInternalMarkPassingAlgorithm, raceLogResolver, leaderboardGroupResolver, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry));
                    break;
                }
                case MARKPOSITIONS: {
                    result.add(new MarkPositionReceiver(trackedRegatta, tractracEvent, tractracRace, simulator, this, eventSubscriber, raceSubscriber, timeoutInMilliseconds));
                    break;
                }
                case RAWPOSITIONS: {
                    result.add(new RawPositionReceiver(trackedRegatta, tractracEvent, this, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds));
                    break;
                }
                case MARKPASSINGS: {
                    if (useInternalMarkPassingAlgorithm) break;
                    result.add(new MarkPassingReceiver(trackedRegatta, tractracEvent, simulator, this, eventSubscriber, raceSubscriber, timeoutInMilliseconds));
                    break;
                }
                case RACESTARTFINISH: {
                    result.add(new RaceStartedAndFinishedReceiver(trackedRegatta, tractracEvent, simulator, this, eventSubscriber, raceSubscriber, timeoutInMilliseconds));
                    break;
                }
                case SENSORDATA: {
                    result.add(new SensorDataReceiver(trackedRegatta, tractracEvent, simulator, this, eventSubscriber, raceSubscriber, timeoutInMilliseconds));
                    break;
                }
                case COMPETITOR: {
                    result.add(new CompetitorChangeReceiver(trackedRegatta, tractracEvent, tractracRace, simulator, this, eventSubscriber, raceSubscriber, timeoutInMilliseconds, raceAndCompetitorStatusWithRaceLogReconciler));
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Iterable<Receiver> getUpdateReceivers(DynamicTrackedRegatta trackedRegatta, long delayToLiveInMillis, Simulator simulator, WindStore windStore, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry, LeaderboardGroupResolver leaderboardGroupResolver, IRace tractracRace, URI updateURI, String tracTracUsername, String tracTracPassword, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, boolean useInternalMarkPassingAlgorithm, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, RaceAndCompetitorStatusWithRaceLogReconciler raceAndCompetitorStatusWithRaceLogReconciler) {
        ArrayList<ReceiverType> receiverTypes = new ArrayList<ReceiverType>();
        receiverTypes.addAll(Arrays.asList(ReceiverType.RACECOURSE, ReceiverType.MARKPASSINGS, ReceiverType.MARKPOSITIONS, ReceiverType.RACESTARTFINISH, ReceiverType.RAWPOSITIONS, ReceiverType.SENSORDATA));
        if (raceAndCompetitorStatusWithRaceLogReconciler != null) {
            receiverTypes.add(ReceiverType.COMPETITOR);
        }
        return this.getUpdateReceivers(trackedRegatta, tractracRace, windStore, delayToLiveInMillis, simulator, raceDefinitionSetToUpdate, trackedRegattaRegistry, raceLogResolver, markPassingRaceFingerprintRegistry, leaderboardGroupResolver, updateURI, tracTracUsername, tracTracPassword, eventSubscriber, raceSubscriber, useInternalMarkPassingAlgorithm, timeoutInMilliseconds, raceTrackingHandler, raceAndCompetitorStatusWithRaceLogReconciler, receiverTypes.toArray(new ReceiverType[receiverTypes.size()]));
    }

    @Override
    public Serializable getRaceID(IRace tractracRace) {
        return tractracRace.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RaceDefinition removeRace(IEvent tractracEvent, IRace tractracRace, Regatta regattaToLoadRaceInto, TrackedRegattaRegistry trackedRegattaRegistry) {
        RaceDefinition raceDefinition;
        WeakValueCache<UUID, RaceDefinition> weakValueCache = this.raceCache;
        synchronized (weakValueCache) {
            raceDefinition = this.getExistingRaceDefinitionForRace(tractracRace.getId());
            if (raceDefinition != null) {
                this.raceCache.remove((Object)tractracRace.getId());
                logger.info("Removed race " + raceDefinition.getName() + " from TracTrac DomainFactoryImpl");
            }
        }
        if (raceDefinition != null) {
            weakValueCache = this.regattaCache;
            synchronized (weakValueCache) {
                Util.Pair key;
                Regatta regatta;
                if (regattaToLoadRaceInto != null) {
                    regatta = regattaToLoadRaceInto;
                    key = new Util.Pair((Object)regatta.getName(), (Object)regatta.getBoatClass().getName());
                } else {
                    Util.Pair<String, BoatClass> defaultRegattaNameAndBoatClass = this.getDefaultRegattaNameAndBoatClass(tractracRace);
                    key = new Util.Pair((Object)((String)defaultRegattaNameAndBoatClass.getA()), defaultRegattaNameAndBoatClass.getB() == null ? null : ((BoatClass)defaultRegattaNameAndBoatClass.getB()).getName());
                    regatta = (Regatta)this.regattaCache.get((Object)key);
                }
                if (regatta != null && Util.contains((Iterable)regatta.getAllRaces(), (Object)raceDefinition) && Util.size((Iterable)regatta.getAllRaces()) == 1) {
                    logger.info("Removing regatta " + regatta.getName() + " (" + regatta.hashCode() + ") from TracTrac DomainFactoryImpl");
                    this.regattaCache.remove((Object)key);
                    this.weakDefaultRegattaCache.remove((Object)tractracRace);
                }
            }
        }
        return raceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicTrackedRace getOrCreateRaceDefinitionAndTrackedRace(DynamicTrackedRegatta trackedRegatta, UUID raceId, String raceName, BoatClass boatClass, Map<Competitor, Boat> competitorsAndBoats, Course course, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, URI tracTracUpdateURI, UUID tracTracEventUuid, String tracTracUsername, String tracTracPassword, boolean ignoreTracTracMarkPassings, RaceLogAndTrackedRaceResolver raceLogResolver, Consumer<DynamicTrackedRace> runBeforeExposingRace, IRace tractracRace, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        WeakValueCache<UUID, RaceDefinition> weakValueCache = this.raceCache;
        synchronized (weakValueCache) {
            String reasonForNotAddingRaceToRegatta;
            RaceDefinition raceDefinition = (RaceDefinition)this.raceCache.get((Object)raceId);
            if (raceDefinition == null) {
                logger.info("Creating RaceDefinitionImpl for race " + raceName);
                try {
                    raceDefinition = raceTrackingHandler.createRaceDefinition(trackedRegatta.getRegatta(), raceName, course, boatClass, competitorsAndBoats, (Serializable)raceId);
                }
                catch (RuntimeException exception) {
                    reasonForNotAddingRaceToRegatta = "Error while creating race " + raceDefinition + " for regatta " + trackedRegatta.getRegatta() + ": " + exception.getMessage();
                    this.errorWhileTryingToTrackRace(trackedRegatta, raceDefinitionSetToUpdate, raceDefinition, reasonForNotAddingRaceToRegatta);
                }
            } else {
                logger.info("Already found RaceDefinitionImpl for race " + raceName);
            }
            DynamicTrackedRace trackedRace = null;
            if (raceDefinition != null) {
                trackedRace = trackedRegatta.getExistingTrackedRace(raceDefinition);
                if (trackedRace == null) {
                    if (raceDefinition.getBoatClass() == trackedRegatta.getRegatta().getBoatClass()) {
                        trackedRegatta.getRegatta().addRace(raceDefinition);
                        TrackingConnectorInfoImpl trackingConnectorInfo = null;
                        if (tractracRace != null) {
                            URL webUrl = tractracRace.getEvent().getWebURL();
                            String webUrlString = webUrl == null ? null : webUrl.toString();
                            trackingConnectorInfo = new TrackingConnectorInfoImpl("TracTrac", "https://www.tractrac.com/", webUrlString);
                        }
                        trackedRace = this.createTrackedRace((TrackedRegatta)trackedRegatta, raceDefinition, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, raceDefinitionSetToUpdate, ignoreTracTracMarkPassings, raceLogResolver, raceTrackingHandler, (TrackingConnectorInfo)trackingConnectorInfo, markPassingRaceFingerprintRegistry);
                        logger.info("Added race " + raceDefinition + " to regatta " + trackedRegatta.getRegatta());
                        if (runBeforeExposingRace != null) {
                            logger.fine("Running callback for tracked race creation for " + trackedRace.getRace());
                            runBeforeExposingRace.accept(trackedRace);
                        }
                        this.addTracTracUpdateHandlers(tracTracUpdateURI, tracTracEventUuid, tracTracUsername, tracTracPassword, raceDefinition, trackedRace, tractracRace);
                        this.raceCache.put((Object)raceId, (Object)raceDefinition);
                        this.raceCache.notifyAll();
                    } else {
                        reasonForNotAddingRaceToRegatta = "Not adding race " + raceDefinition + " to regatta " + trackedRegatta.getRegatta() + " because boat class " + raceDefinition.getBoatClass() + " doesn't match regatta's boat class " + trackedRegatta.getRegatta().getBoatClass();
                        this.errorWhileTryingToTrackRace(trackedRegatta, raceDefinitionSetToUpdate, raceDefinition, reasonForNotAddingRaceToRegatta);
                    }
                } else {
                    logger.info("Found existing tracked race for race " + raceName + " with ID " + raceId);
                }
            }
            return trackedRace;
        }
    }

    private void errorWhileTryingToTrackRace(DynamicTrackedRegatta trackedRegatta, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, RaceDefinition raceDefinition, String reasonForNotAddingRaceToRegatta) {
        logger.warning(reasonForNotAddingRaceToRegatta);
        try {
            raceDefinitionSetToUpdate.raceNotLoaded(reasonForNotAddingRaceToRegatta);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Something else went wrong while trying to notify the RaceDefinition set that the race " + raceDefinition + " could not be added to the the regatta " + trackedRegatta.getRegatta(), e);
        }
    }

    @Override
    public Iterable<IMapItem> getControlsForCourseArea(IEvent tracTracEvent, String tracTracCourseAreaName) {
        HashSet<IMapItem> result = new HashSet<IMapItem>();
        if (tracTracCourseAreaName != null) {
            for (IMapItem control : tracTracEvent.getMapItems()) {
                if (control.getCourseArea() == null || !control.getCourseArea().equals(tracTracCourseAreaName)) continue;
                result.add(control);
            }
        }
        return result;
    }

    @Override
    public ControlPoint getExistingControlWithTwoMarks(Iterable<IMapItem> candidates, Mark first, Mark second) {
        HashSet<Mark> pairOfMarksToFind = new HashSet<Mark>();
        pairOfMarksToFind.add(first);
        pairOfMarksToFind.add(second);
        for (IMapItem control : candidates) {
            HashSet marksInExistingControlPoint = new HashSet();
            ControlPoint controlPoint = this.getOrCreateControlPoint(control);
            Util.addAll((Iterable)controlPoint.getMarks(), marksInExistingControlPoint);
            if (!marksInExistingControlPoint.equals(pairOfMarksToFind)) continue;
            return controlPoint;
        }
        return null;
    }

    @Override
    public void addTracTracUpdateHandlers(URI tracTracUpdateURI, UUID tracTracEventUuid, String tracTracUsername, String tracTracPassword, RaceDefinition raceDefinition, DynamicTrackedRace trackedRace, IRace tractracRace) {
        TracTracCourseDesignUpdateHandler courseDesignHandler = new TracTracCourseDesignUpdateHandler(tracTracUpdateURI, tracTracUsername, tracTracPassword, tracTracEventUuid, raceDefinition.getId(), tractracRace, this);
        StartTimeUpdateHandler startTimeHandler = new StartTimeUpdateHandler(tracTracUpdateURI, tracTracUsername, tracTracPassword, (Serializable)tracTracEventUuid, raceDefinition.getId(), trackedRace.getTrackedRegatta().getRegatta());
        RaceAbortedHandler raceAbortedHandler = new RaceAbortedHandler(tracTracUpdateURI, tracTracUsername, tracTracPassword, (Serializable)tracTracEventUuid, raceDefinition.getId());
        FinishTimeUpdateHandler finishTimeUpdateHandler = new FinishTimeUpdateHandler(tracTracUpdateURI, tracTracUsername, tracTracPassword, (Serializable)tracTracEventUuid, raceDefinition.getId(), trackedRace.getTrackedRegatta().getRegatta());
        this.baseDomainFactory.addUpdateHandlers(trackedRace, (CourseDesignUpdateHandler)courseDesignHandler, startTimeHandler, raceAbortedHandler, finishTimeUpdateHandler);
    }

    private DynamicTrackedRace createTrackedRace(TrackedRegatta trackedRegatta, RaceDefinition race, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, boolean useMarkPassingCalculator, RaceLogAndTrackedRaceResolver raceLogResolver, RaceTrackingHandler raceTrackingHandler, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
        return raceTrackingHandler.createTrackedRace(trackedRegatta, race, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, race.getBoatClass().getApproximateManeuverDurationInMilliseconds(), raceDefinitionSetToUpdate, useMarkPassingCalculator, raceLogResolver, Optional.empty(), trackingConnectorInfo, markPassingRaceFingerprintRegistry);
    }

    @Override
    public Map<Competitor, Boat> getOrCreateCompetitorsAndTheirBoats(DynamicTrackedRegatta trackedRegatta, LeaderboardGroupResolver leaderboardGroupResolver, IRace race, BoatClass defaultBoatClass, RaceTrackingHandler raceTrackingHandler) {
        CompetitorAndBoatStore competitorAndBoatStore = this.baseDomainFactory.getCompetitorAndBoatStore();
        HashMap<Competitor, Boat> competitorsAndBoats = new HashMap<Competitor, Boat>();
        Regatta regatta = trackedRegatta.getRegatta();
        LeaderboardGroup leaderboardGroup = leaderboardGroupResolver.resolveLeaderboardGroupByRegattaName(regatta.getName());
        AtomicBoolean leaderboardGroupConsistencyChecked = new AtomicBoolean(false);
        this.getCompetingCompetitors(race).forEach(rc -> {
            UUID competitorId = rc.getCompetitor().getId();
            MetadataParser.BoatMetaData competitorBoatInfo = this.getMetadataParser().parseCompetitorBoat((IRaceCompetitor)rc);
            Regatta regatta2 = regatta;
            synchronized (regatta2) {
                if (competitorBoatInfo != null && !regatta.canBoatsOfCompetitorsChangePerRace()) {
                    if (regatta instanceof MigratableRegatta) {
                        MigratableRegatta migratableRegatta = (MigratableRegatta)regatta;
                        migratableRegatta.migrateCanBoatsOfCompetitorsChangePerRace();
                        if (!leaderboardGroupConsistencyChecked.get()) {
                            this.checkConsistencyOfRegattaTypeInSeries(leaderboardGroup, regatta);
                            leaderboardGroupConsistencyChecked.set(true);
                        }
                    } else {
                        logger.log(Level.SEVERE, "Bug2822 DB-Migration: Regatta " + regatta.getName() + " has wrong type 'canBoatsOfCompetitorsChangePerRace' but can't be migrated because it is not of type MigratableRegattaImpl");
                    }
                } else if (!leaderboardGroupConsistencyChecked.get()) {
                    this.checkConsistencyOfRegattaTypeInSeries(leaderboardGroup, regatta);
                    leaderboardGroupConsistencyChecked.set(true);
                }
            }
            if (regatta.canBoatsOfCompetitorsChangePerRace()) {
                Competitor competitorToUse;
                String sailId;
                Object boatId;
                if (competitorBoatInfo != null) {
                    boatId = this.createUniqueBoatIdentifierFromBoatMetadata(regatta, (LeaderboardGroupBase)leaderboardGroup, competitorBoatInfo);
                    sailId = competitorBoatInfo.getId();
                } else {
                    boatId = this.createUniqueBoatIdentifierFromCompetitor(rc.getCompetitor());
                    sailId = rc.getCompetitor().getShortName();
                }
                DynamicBoat existingBoat = competitorAndBoatStore.getExistingBoatById((Serializable)boatId);
                Competitor existingCompetitor = competitorAndBoatStore.getExistingCompetitorById((Serializable)competitorId);
                if (existingCompetitor != null) {
                    boolean needToMigrate;
                    Set<Competitor> set = this.competitorsCurrentlyBeingMigrated;
                    synchronized (set) {
                        if (!this.competitorsCurrentlyBeingMigrated.contains(existingCompetitor)) {
                            needToMigrate = existingCompetitor.hasBoat();
                            if (needToMigrate) {
                                this.competitorsCurrentlyBeingMigrated.add(existingCompetitor);
                            }
                        } else {
                            needToMigrate = false;
                            logger.fine("Bug2822 DB-Migration: Not migrating competitor " + existingCompetitor.getName() + " because a migration for it is already ongoing");
                        }
                    }
                    if (needToMigrate) {
                        competitorToUse = competitorAndBoatStore.migrateToCompetitorWithoutBoat((CompetitorWithBoat)existingCompetitor);
                        if (competitorToUse.getShortName() != rc.getCompetitor().getShortName()) {
                            boolean savedIsCompetitorToUpdateDuringGetOrCreate = competitorAndBoatStore.isCompetitorToUpdateDuringGetOrCreate(competitorToUse);
                            competitorAndBoatStore.allowCompetitorResetToDefaults(competitorToUse);
                            competitorAndBoatStore.updateCompetitor(competitorToUse.getId().toString(), competitorToUse.getName(), rc.getCompetitor().getShortName(), competitorToUse.getColor(), competitorToUse.getEmail(), competitorToUse.getNationality(), competitorToUse.getTeam().getImage(), competitorToUse.getFlagImage(), competitorToUse.getTimeOnTimeFactor(), competitorToUse.getTimeOnDistanceAllowancePerNauticalMile(), competitorToUse.getSearchTag(), true);
                            if (savedIsCompetitorToUpdateDuringGetOrCreate) {
                                competitorAndBoatStore.allowCompetitorResetToDefaults(competitorToUse);
                            }
                        }
                        this.competitorsCurrentlyBeingMigrated.remove(existingCompetitor);
                    } else {
                        competitorToUse = this.getOrCreateCompetitor(rc.getCompetitor(), raceTrackingHandler);
                    }
                } else {
                    competitorToUse = this.getOrCreateCompetitor(rc.getCompetitor(), raceTrackingHandler);
                }
                Object boatToUse = existingBoat != null ? existingBoat : (competitorBoatInfo != null ? this.getOrCreateBoat((Serializable)boatId, competitorBoatInfo.getName(), defaultBoatClass, sailId, AbstractColor.getCssColor((String)competitorBoatInfo.getColor()), raceTrackingHandler) : this.getOrCreateBoat((Serializable)boatId, null, defaultBoatClass, sailId, null, raceTrackingHandler));
                competitorsAndBoats.put(competitorToUse, (Boat)boatToUse);
            } else {
                CompetitorWithBoat competitorWithBoat = this.getOrCreateCompetitorWithBoat(rc.getCompetitor(), raceTrackingHandler);
                competitorsAndBoats.put((Competitor)competitorWithBoat, competitorWithBoat.getBoat());
            }
        });
        return competitorsAndBoats;
    }

    private boolean checkConsistencyOfRegattaTypeInSeries(LeaderboardGroup leaderboardGroup, Regatta regatta) {
        boolean result = true;
        boolean canBoatsOfCompetitorsChangePerRace = regatta.canBoatsOfCompetitorsChangePerRace();
        String boatsCanChangelogMessage = "";
        if (leaderboardGroup != null) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!(leaderboard instanceof RegattaLeaderboard)) continue;
                RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                boolean regattaHasTrackedRaces = Util.size((Iterable)regattaLeaderboard.getTrackedRaces()) > 0;
                boolean regattaCanBoatsChange = regattaLeaderboard.getRegatta().canBoatsOfCompetitorsChangePerRace();
                boatsCanChangelogMessage = String.valueOf(boatsCanChangelogMessage) + regattaLeaderboard.getName();
                boatsCanChangelogMessage = String.valueOf(boatsCanChangelogMessage) + ": trackedRaces=" + regattaHasTrackedRaces;
                boatsCanChangelogMessage = String.valueOf(boatsCanChangelogMessage) + ": canBoatsChange=" + regattaCanBoatsChange + "; ";
                if (!regattaHasTrackedRaces || canBoatsOfCompetitorsChangePerRace == regattaCanBoatsChange) continue;
                result = false;
                break;
            }
        }
        if (!result) {
            logger.log(Level.SEVERE, "Bug2822 DB-Migration: Regatta " + regatta.getName() + " has different value of 'canBoatsOfCompetitorsChangePerRace' than other regattas in leaderboardGroup " + leaderboardGroup.getName());
            logger.log(Level.SEVERE, "Bug2822 DB-Migration: leaderboardGroup state: " + boatsCanChangelogMessage);
        }
        return result;
    }

    private Serializable createUniqueBoatIdentifierFromBoatMetadata(Regatta regatta, LeaderboardGroupBase leaderboardGroup, MetadataParser.BoatMetaData boatMetadata) {
        Object boatIdentifier = null;
        boatIdentifier = boatMetadata.getUuid() != null ? boatMetadata.getUuid() : (leaderboardGroup != null ? this.buildEscapedCompositeIdentifier(leaderboardGroup.getId().toString(), boatMetadata.getId()) : this.buildEscapedCompositeIdentifier(regatta.getId().toString(), boatMetadata.getId()));
        return boatIdentifier;
    }

    private String createUniqueBoatIdentifierFromCompetitor(ICompetitor competitor) {
        String boatIdentifier = competitor.getId().toString();
        return boatIdentifier;
    }

    private String buildEscapedCompositeIdentifier(String id1, String id2) {
        return String.format("%s#%s", this.escapeIdentifierFragment(id1), this.escapeIdentifierFragment(id2));
    }

    private String escapeIdentifierFragment(String fragment) {
        return fragment.replace("\\", "\\\\").replace("#", "\\#");
    }

    private Stream<IRaceCompetitor> getCompetingCompetitors(IRace race) {
        return race.getRaceCompetitors().stream().filter(rc -> !rc.getCompetitor().isNonCompeting());
    }

    @Override
    public BoatClass resolveDominantBoatClassOfRace(IRace race) {
        ArrayList<ICompetitorClass> competitorClasses = new ArrayList<ICompetitorClass>();
        this.getCompetingCompetitors(race).forEach(rc -> competitorClasses.add(rc.getCompetitor().getCompetitorClass()));
        return this.getDominantBoatClass((Collection<ICompetitorClass>)competitorClasses);
    }

    private BoatClass getDominantBoatClass(Collection<ICompetitorClass> competitorClasses) {
        ArrayList<String> competitorClassNames = new ArrayList<String>();
        for (ICompetitorClass competitorClass : competitorClasses) {
            competitorClassNames.add(competitorClass == null ? null : competitorClass.getName());
        }
        BoatClass dominantBoatClass = this.getDominantBoatClass((Iterable<String>)competitorClassNames);
        return dominantBoatClass;
    }

    @Override
    public BoatClass getDominantBoatClass(Iterable<String> competitorClassNames) {
        BoatClass result;
        if (competitorClassNames == null) {
            result = null;
        } else {
            ArrayList<BoatClass> boatClasses = new ArrayList<BoatClass>();
            for (String competitorClassName : competitorClassNames) {
                BoatClass boatClass = this.getOrCreateBoatClass(competitorClassName);
                boatClasses.add(boatClass);
            }
            result = (BoatClass)Util.getDominantObject(boatClasses);
        }
        return result;
    }

    @Override
    public Mark getMark(IPositionedItem positionedItem) {
        return this.getOrCreateMark(positionedItem);
    }

    @Override
    public MarkPassing createMarkPassing(TimePoint timePoint, Waypoint passed, Competitor competitor) {
        return this.baseDomainFactory.createMarkPassing(timePoint, passed, competitor);
    }

    @Override
    public TracTracRaceTracker createRaceTracker(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, WindStore windStore, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, RaceTrackingConnectivityParametersImpl connectivityParams, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws URISyntaxException, SubscriberInitializationException, IOException, InterruptedException, CreateModelException, TimeOutException {
        return new TracTracRaceTrackerImpl(this, raceLogStore, regattaLogStore, windStore, trackedRegattaRegistry, raceLogResolver, leaderboardGroupResolver, connectivityParams, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    @Override
    public RaceTracker createRaceTracker(Regatta regatta, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, WindStore windStore, TrackedRegattaRegistry trackedRegattaRegistry, RaceLogAndTrackedRaceResolver raceLogResolver, LeaderboardGroupResolver leaderboardGroupResolver, RaceTrackingConnectivityParametersImpl connectivityParams, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) throws URISyntaxException, CreateModelException, SubscriberInitializationException, IOException, InterruptedException, TimeOutException {
        return new TracTracRaceTrackerImpl(regatta, this, raceLogStore, regattaLogStore, windStore, trackedRegattaRegistry, raceLogResolver, leaderboardGroupResolver, connectivityParams, timeoutInMilliseconds, raceTrackingHandler, markPassingRaceFingerprintRegistry);
    }

    @Override
    public JSONService parseJSONURLWithRaceRecords(URL jsonURL, boolean loadClientParams) throws IOException, java.text.ParseException, ParseException, URISyntaxException {
        return new JSONServiceImpl(jsonURL, loadClientParams);
    }

    @Override
    public TracTracConfiguration createTracTracConfiguration(String creatorName, String name, String jsonURL, String liveDataURI, String storedDataURI, String courseDesignUpdateURI, String tracTracUsername, String tracTracPassword) {
        return new TracTracConfigurationImpl(creatorName, name, jsonURL, liveDataURI, storedDataURI, courseDesignUpdateURI, tracTracUsername, tracTracPassword);
    }

    @Override
    public RaceTrackingConnectivityParameters createTrackingConnectivityParameters(URL paramURL, URI liveURI, URI storedURI, URI courseDesignUpdateURI, TimePoint startOfTracking, TimePoint endOfTracking, long delayToLiveInMillis, Duration offsetToStartTimeOfSimulatedRace, boolean useInternalMarkPassingAlgorithm, RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String tracTracUsername, String tracTracPassword, String raceStatus, String raceVisibility, boolean trackWind, boolean correctWindDirectionByMagneticDeclination, boolean preferReplayIfAvailable, int timeoutInMillis, boolean useOfficialEventsToUpdateRaceLog, URI liveURIFromConfiguration, URI storedURIFromConfiguration) throws Exception {
        return new RaceTrackingConnectivityParametersImpl(paramURL, liveURI, storedURI, courseDesignUpdateURI, startOfTracking, endOfTracking, delayToLiveInMillis, offsetToStartTimeOfSimulatedRace, useInternalMarkPassingAlgorithm, raceLogStore, regattaLogStore, this, tracTracUsername, tracTracPassword, raceStatus, raceVisibility, trackWind, correctWindDirectionByMagneticDeclination, preferReplayIfAvailable, timeoutInMillis, useOfficialEventsToUpdateRaceLog, liveURIFromConfiguration, storedURIFromConfiguration);
    }

    @Override
    public JSONService parseJSONURLForOneRaceRecord(URL jsonURL, String raceId, boolean loadClientParams) throws IOException, java.text.ParseException, ParseException, URISyntaxException {
        return new JSONServiceImpl(jsonURL, raceId, loadClientParams);
    }

    @Override
    public IEventSubscriber getOrCreateEventSubscriber(IEvent tractracEvent, URI liveURI, URI storedURI) {
        return this.eventSubscriberCache.computeIfAbsent((Util.Triple<IEvent, URI, URI>)new Util.Triple((Object)tractracEvent, (Object)liveURI, (Object)storedURI), key -> {
            try {
                return new EventSubscriberWrapper((IEvent)key.getA(), (URI)key.getB(), (URI)key.getC());
            }
            catch (SubscriberInitializationException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

