/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;

public interface TracTracConfiguration
extends WithQualifiedObjectIdentifier {
    public String getName();

    public String getJSONURL();

    public String getLiveDataURI();

    public String getStoredDataURI();

    public String getUpdateURI();

    public String getTracTracUsername();

    public String getTracTracPassword();

    public String getCreatorName();

    default public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    default public HasPermissions getPermissionType() {
        return SecuredDomainType.TRACTRAC_ACCOUNT;
    }

    default public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return TracTracConfiguration.getTypeRelativeObjectIdentifier(this.getJSONURL(), this.getCreatorName());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(String jsonUrl, String username) {
        return username == null ? new TypeRelativeObjectIdentifier(new String[]{jsonUrl}) : new TypeRelativeObjectIdentifier(new String[]{jsonUrl, username});
    }
}

