/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.impl;

import com.sap.sse.common.Util;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.impl.ReleaseImpl;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReleaseRepositoryImpl
implements ReleaseRepository {
    private static final Logger logger = Logger.getLogger(ReleaseRepositoryImpl.class.getName());
    private final String repositoryBase;
    private final String masterReleaseNamePrefix;

    public ReleaseRepositoryImpl(String repositoryBase, String masterReleaseNamePrefix) {
        this.repositoryBase = repositoryBase;
        this.masterReleaseNamePrefix = masterReleaseNamePrefix;
    }

    @Override
    public String getRepositoryBase() {
        return this.repositoryBase;
    }

    @Override
    public String getMasterReleaseNamePrefix() {
        return this.masterReleaseNamePrefix;
    }

    private Iterable<Release> getAvailableReleases() {
        LinkedList<Release> result = new LinkedList<Release>();
        try {
            URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(this.getRepositoryBase()));
            InputStream index = (InputStream)connection.getContent();
            int read = 0;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((read = index.read()) != -1) {
                bos.write(read);
            }
            index.close();
            String contents = bos.toString();
            Pattern pattern = Pattern.compile("<a href=\"(([^/]*)-([0-9]*))/\">([^/]*)-([0-9]*)/</a>");
            Matcher m = pattern.matcher(contents);
            int lastMatch = 0;
            while (m.find(lastMatch)) {
                result.add(new ReleaseImpl(m.group(1), this));
                lastMatch = m.end();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error loading releases from repository at " + this.getRepositoryBase() + ". Continuing empty.", e);
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public Iterator<Release> iterator() {
        return this.getAvailableReleases().iterator();
    }

    @Override
    public Release getLatestRelease(String releaseNamePrefix) {
        Release result = null;
        for (Release release : this.getAvailableReleases()) {
            if (!release.getBaseName().equals(releaseNamePrefix) || result != null && !release.getCreationDate().after(result.getCreationDate())) continue;
            result = release;
        }
        return result;
    }

    @Override
    public Release getRelease(String releaseName) {
        return (Release)Util.first((Iterable)Util.filter(this.getAvailableReleases(), r -> r.getName().equals(releaseName)));
    }
}

