/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.UserDataProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public interface Release
extends UserDataProvider,
Named {
    public static final String RELEASE_NOTES_FILE_NAME = "release-notes.txt";
    public static final String ARCHIVE_EXTENSION = ".tar.gz";

    public ReleaseRepository getRepository();

    public String getBaseName();

    public TimePoint getCreationDate();

    default public String getFolderURL() {
        return String.valueOf(this.getRepository().getRepositoryBase()) + "/" + this.getName() + "/";
    }

    default public URL getReleaseNotesURL() throws MalformedURLException {
        return new URL(String.valueOf(this.getFolderURL()) + RELEASE_NOTES_FILE_NAME);
    }

    default public URL getDeployableArchiveURL() throws MalformedURLException {
        return new URL(String.valueOf(this.getFolderURL()) + this.getName() + ARCHIVE_EXTENSION);
    }

    @Override
    default public Map<ProcessConfigurationVariable, String> getUserData() {
        HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>();
        result.put(DefaultProcessConfigurationVariables.INSTALL_FROM_RELEASE, this.getName());
        return result;
    }
}

