/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.windfield;

import com.sap.sailing.simulator.windfield.RandomStreamManager;
import com.sap.sailing.simulator.windfield.impl.BlastRandomSeedManagerImpl;
import java.io.Serializable;
import java.util.logging.Logger;

public class WindControlParameters
implements Serializable {
    private static final long serialVersionUID = -8512613791406845298L;
    public boolean showOmniscient;
    public boolean showOpportunist;
    public Double baseWindSpeed;
    public Double windBearing;
    public Double baseWindBearing;
    public Double curSpeed;
    public Double curBearing;
    public Double frequency;
    public Double amplitude;
    public Double leftWindSpeed;
    public Double middleWindSpeed;
    public Double rightWindSpeed;
    public Double blastProbability;
    public Double maxBlastSize;
    public Double blastWindSpeed;
    public Double blastWindSpeedVar;
    public boolean resetBlastRandomStream = false;
    private RandomStreamManager blastRandomStreamManager;
    private static Logger logger = Logger.getLogger(WindControlParameters.class.getName());

    public WindControlParameters() {
        this.setDefaults();
    }

    public WindControlParameters(double speedInKnots, double bearing) {
        this.setDefaults();
        this.baseWindSpeed = speedInKnots;
        this.baseWindBearing = bearing;
    }

    public void setDefaults() {
        this.baseWindSpeed = 12.0;
        this.curSpeed = 0.0;
        this.curBearing = 0.0;
        this.windBearing = 0.0;
        this.baseWindBearing = 0.0;
        this.frequency = 0.0;
        this.amplitude = 15.0;
        this.leftWindSpeed = 100.0;
        this.middleWindSpeed = 100.0;
        this.rightWindSpeed = 100.0;
        this.blastProbability = 25.0;
        this.maxBlastSize = 1.0;
        this.blastWindSpeed = 120.0;
        this.blastWindSpeedVar = 10.0;
        if (this.blastRandomStreamManager == null || !this.resetBlastRandomStream) {
            this.setBlastRandomStreamManager(new BlastRandomSeedManagerImpl());
        } else {
            logger.info("Resetting random seeds for wind field.");
            this.blastRandomStreamManager.reset();
        }
    }

    public RandomStreamManager getBlastRandomStreamManager() {
        return this.blastRandomStreamManager;
    }

    public void setBlastRandomStreamManager(RandomStreamManager blastRandomStreamManager) {
        this.blastRandomStreamManager = blastRandomStreamManager;
    }
}

