/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.PathType;
import com.sap.sailing.simulator.Path;
import com.sap.sailing.simulator.RaceProperties;
import com.sap.sailing.simulator.SimulationParameters;
import com.sap.sailing.simulator.Simulator;
import com.sap.sailing.simulator.SimulatorUISelection;
import com.sap.sailing.simulator.TimedPositionWithSpeed;
import com.sap.sailing.simulator.impl.ConfigurationManager;
import com.sap.sailing.simulator.impl.PathGeneratorOpportunistEuclidian360;
import com.sap.sailing.simulator.impl.PathGeneratorTracTrac;
import com.sap.sailing.simulator.impl.PathGeneratorTreeGrow360;
import com.sap.sailing.simulator.impl.PathImpl;
import com.sap.sailing.simulator.impl.SimulatorUISelectionImpl;
import com.sap.sailing.simulator.impl.SimulatorUtils;
import com.sap.sailing.simulator.impl.SparseSimulationDataException;
import com.sap.sailing.simulator.impl.TimedPositionWithSpeedImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class SimulatorImpl
implements Simulator {
    private static final Logger LOGGER = Logger.getLogger("com.sap.sailing.simulator");
    private SimulationParameters simulationParameters = null;
    private Path raceCourse = null;
    private PathGeneratorTracTrac pathGenerator = null;

    public SimulatorImpl(SimulationParameters parameters) {
        this.simulationParameters = parameters;
        if (this.simulationParameters.getMode() == 'm') {
            this.initializePathGenerator(parameters, 0, 0, 0);
        }
    }

    @Override
    public void setSimulationParameters(SimulationParameters parameters, SimulatorUISelection selection) {
        this.simulationParameters = parameters;
        this.initializePathGenerator(parameters, selection.getRaceIndex(), selection.getLegIndex(), selection.getCompetitorIndex());
    }

    @Override
    public SimulationParameters getSimulationParameters() {
        return this.simulationParameters;
    }

    @Override
    public Path getPath(PathType pathType) throws SparseSimulationDataException {
        Path path = null;
        try {
            switch (pathType) {
                case OMNISCIENT: {
                    PathGeneratorTreeGrow360 genTreeGrow = new PathGeneratorTreeGrow360(this.simulationParameters);
                    genTreeGrow.setEvaluationParameters(null, 0, null);
                    path = genTreeGrow.getPath();
                    break;
                }
                case ONE_TURNER_LEFT: {
                    PathGeneratorTreeGrow360 genTreeGrow = new PathGeneratorTreeGrow360(this.simulationParameters);
                    genTreeGrow.setEvaluationParameters("L", 1, null);
                    path = genTreeGrow.getPath();
                    break;
                }
                case ONE_TURNER_RIGHT: {
                    PathGeneratorTreeGrow360 genTreeGrow = new PathGeneratorTreeGrow360(this.simulationParameters);
                    genTreeGrow.setEvaluationParameters("R", 1, null);
                    path = genTreeGrow.getPath();
                    break;
                }
                case OPPORTUNIST_LEFT: {
                    PathGeneratorOpportunistEuclidian360 genOpportunistic = new PathGeneratorOpportunistEuclidian360(this.simulationParameters);
                    genOpportunistic.setEvaluationParameters(true);
                    path = genOpportunistic.getPath();
                    break;
                }
                case OPPORTUNIST_RIGHT: {
                    PathGeneratorOpportunistEuclidian360 genOpportunistic = new PathGeneratorOpportunistEuclidian360(this.simulationParameters);
                    genOpportunistic.setEvaluationParameters(false);
                    path = genOpportunistic.getPath();
                }
            }
        }
        catch (SparseSimulationDataException e) {
            LOGGER.warning(String.valueOf(e.getMessage()) + "(PathType: " + pathType.getTxtId() + ")");
            ArrayList<TimedPositionWithSpeed> points = new ArrayList<TimedPositionWithSpeed>();
            points.add(new TimedPositionWithSpeedImpl(this.simulationParameters.getWindField().getStartTime(), this.simulationParameters.getCourse().get(0), null));
            path = new PathImpl(points, null, 0L, true, false);
        }
        return path;
    }

    @Override
    public Path getRaceCourse() {
        return this.raceCourse;
    }

    @Override
    public Path getLegGPSTrack(SimulatorUISelection selection) {
        String fileName = SimulatorUtils.getFileName(selection.getRaceIndex(), selection.getCompetitorIndex(), selection.getLegIndex(), "7#GPS Track");
        Path path = (Path)SimulatorUtils.readObjectFromResources("resources/" + fileName);
        if (path == null) {
            System.err.println("[ERROR][SailingSimulatorImpl][readPathsFromResources] Cannot de-serialize path from resources/7#GPS Track.dat");
            LOGGER.warning("[ERROR][SailingSimulatorImpl][readPathsFromResources] Cannot de-serialize path from resources/7#GPS Track.dat");
            this.pathGenerator.setSelectionParameters(selection.getLegIndex(), selection.getCompetitorIndex());
            path = this.pathGenerator.getPath();
        }
        return path;
    }

    @Override
    public List<String> getLegsNames(int selectedRaceIndex) {
        this.setSimulationParameters(this.simulationParameters, new SimulatorUISelectionImpl(0, selectedRaceIndex, 0, 0));
        List<String> legsNames = null;
        String fileName = String.valueOf(SimulatorUtils.getRaceID(ConfigurationManager.INSTANCE.getRaceURL(selectedRaceIndex))) + "_" + "legsNames.dat";
        legsNames = (List<String>)SimulatorUtils.readObjectFromResources("resources/" + fileName);
        if (legsNames != null && !legsNames.isEmpty()) {
            return legsNames;
        }
        legsNames = this.pathGenerator.getLegsNames();
        SimulatorUtils.saveStringListToFiles(legsNames, fileName);
        return legsNames;
    }

    @Override
    public List<String> getRacesNames() {
        ArrayList<String> racesNames = new ArrayList<String>();
        for (RaceProperties raceInfo : ConfigurationManager.INSTANCE.getRacesInfo()) {
            racesNames.add(raceInfo.getName());
        }
        return racesNames;
    }

    @Override
    public List<String> getCompetitorsNames(int selectedRaceIndex) {
        this.setSimulationParameters(this.simulationParameters, new SimulatorUISelectionImpl(0, selectedRaceIndex, 0, 0));
        List<String> competitorsNames = null;
        String fileName = String.valueOf(SimulatorUtils.getRaceID(ConfigurationManager.INSTANCE.getRaceURL(selectedRaceIndex))) + "_" + "competitorsNames.dat";
        competitorsNames = (List<String>)SimulatorUtils.readObjectFromResources("resources/" + fileName);
        if (competitorsNames != null && !competitorsNames.isEmpty()) {
            return competitorsNames;
        }
        competitorsNames = this.pathGenerator.getComeptitorsNames();
        SimulatorUtils.saveStringListToFiles(competitorsNames, fileName);
        return competitorsNames;
    }

    @Override
    public Path getLeg(int selectedCompetitorIndex, int selectedLegIndex) {
        this.pathGenerator.setSelectionParameters(selectedLegIndex, selectedCompetitorIndex);
        return this.pathGenerator.getPath();
    }

    private void initializePathGenerator(SimulationParameters parameters, int selectedRaceIndex, int selectedLegIndex, int selectedCompetitorIndex) {
        this.pathGenerator = new PathGeneratorTracTrac(parameters);
        this.pathGenerator.setSelectionParameters(selectedLegIndex, selectedCompetitorIndex);
    }
}

